/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.com.github.mustachejava;

import com.salesforce.servicelibs.com.github.mustachejava.DefaultMustacheVisitor;
import com.salesforce.servicelibs.com.github.mustachejava.FragmentKey;
import com.salesforce.servicelibs.com.github.mustachejava.Mustache;
import com.salesforce.servicelibs.com.github.mustachejava.MustacheFactory;
import com.salesforce.servicelibs.com.github.mustachejava.MustacheNotFoundException;
import com.salesforce.servicelibs.com.github.mustachejava.MustacheParser;
import com.salesforce.servicelibs.com.github.mustachejava.MustacheResolver;
import com.salesforce.servicelibs.com.github.mustachejava.MustacheVisitor;
import com.salesforce.servicelibs.com.github.mustachejava.ObjectHandler;
import com.salesforce.servicelibs.com.github.mustachejava.TemplateContext;
import com.salesforce.servicelibs.com.github.mustachejava.codes.DefaultMustache;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.salesforce.servicelibs.com.github.mustachejava.resolver.DefaultResolver;
import com.salesforce.servicelibs.com.github.mustachejava.util.HtmlEscaper;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class DefaultMustacheFactory
implements MustacheFactory {
    protected final ConcurrentHashMap<String, Mustache> mustacheCache = this.createMustacheCache();
    protected ObjectHandler oh = new ReflectionObjectHandler();
    protected final MustacheParser mc = this.createParser();
    protected final ConcurrentHashMap<FragmentKey, Mustache> templateCache = this.createLambdaCache();
    protected int recursionLimit = 100;
    private final MustacheResolver mustacheResolver;
    protected ExecutorService es;
    private final ThreadLocal<Map<String, Mustache>> partialCache = ThreadLocal.withInitial(HashMap::new);

    public DefaultMustacheFactory() {
        this.mustacheResolver = new DefaultResolver();
    }

    public DefaultMustacheFactory(MustacheResolver mustacheResolver) {
        this.mustacheResolver = mustacheResolver;
    }

    public DefaultMustacheFactory(String classpathResourceRoot) {
        this.mustacheResolver = new DefaultResolver(classpathResourceRoot);
    }

    public DefaultMustacheFactory(File fileRoot) {
        this.mustacheResolver = new DefaultResolver(fileRoot);
    }

    public String resolvePartialPath(String dir, String name, String extension) {
        int sepIndex;
        String filePath = name;
        if (!name.startsWith("/")) {
            filePath = dir + filePath;
        }
        String string = name = (sepIndex = name.lastIndexOf("/")) == -1 ? name : name.substring(sepIndex);
        if (!name.endsWith(extension) && !name.contains(".")) {
            filePath = filePath + extension;
        }
        String path = new File(filePath).getPath();
        return DefaultMustacheFactory.ensureForwardSlash(path);
    }

    private static String ensureForwardSlash(String path) {
        return path.replace('\\', '/');
    }

    @Override
    public MustacheVisitor createMustacheVisitor() {
        return new DefaultMustacheVisitor(this);
    }

    @Override
    public Reader getReader(String resourceName) {
        Reader reader = this.mustacheResolver.getReader(resourceName);
        if (reader == null) {
            throw new MustacheNotFoundException(resourceName);
        }
        return reader;
    }

    @Override
    public void encode(String value, Writer writer) {
        HtmlEscaper.escape(value, writer);
    }

    @Override
    public ObjectHandler getObjectHandler() {
        return this.oh;
    }

    public void setObjectHandler(ObjectHandler oh) {
        this.oh = oh;
    }

    public ExecutorService getExecutorService() {
        return this.es;
    }

    public void setExecutorService(ExecutorService es) {
        this.es = es;
    }

    public Mustache getFragment(FragmentKey templateKey) {
        Mustache mustache = this.templateCache.computeIfAbsent(templateKey, this.getFragmentCacheFunction());
        mustache.init();
        return mustache;
    }

    protected Function<FragmentKey, Mustache> getFragmentCacheFunction() {
        return fragmentKey -> {
            StringReader reader = new StringReader(fragmentKey.templateText);
            TemplateContext tc = fragmentKey.tc;
            return this.mc.compile(reader, tc.file(), tc.startChars(), tc.endChars(), tc.startOfLine());
        };
    }

    @Override
    public Mustache compile(String name) {
        Mustache mustache = this.mustacheCache.computeIfAbsent(name, this.getMustacheCacheFunction());
        mustache.init();
        return mustache;
    }

    @Override
    public Mustache compile(Reader reader, String name) {
        return this.compile(reader, name, "{{", "}}");
    }

    public Mustache compile(Reader reader, String file, String sm, String em) {
        Mustache compile = this.mc.compile(reader, file, sm, em);
        compile.init();
        this.partialCache.remove();
        return compile;
    }

    @Override
    public String translate(String from) {
        return from;
    }

    public String filterText(String appended, boolean startOfLine) {
        return appended;
    }

    public void setRecursionLimit(int recursionLimit) {
        this.recursionLimit = recursionLimit;
    }

    public int getRecursionLimit() {
        return this.recursionLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mustache compilePartial(String s2) {
        Map<String, Mustache> cache = this.partialCache.get();
        Mustache cached = cache.get(s2);
        if (cached != null) {
            if (cached instanceof DefaultMustache) {
                ((DefaultMustache)cached).setRecursive();
            }
            return cached;
        }
        try {
            Mustache mustache = this.mc.compile(s2);
            cache.put(s2, mustache);
            mustache.init();
            Mustache mustache2 = mustache;
            return mustache2;
        }
        finally {
            cache.remove(s2);
        }
    }

    protected MustacheParser createParser() {
        return new MustacheParser(this);
    }

    protected Function<String, Mustache> getMustacheCacheFunction() {
        return this.mc::compile;
    }

    protected ConcurrentHashMap<String, Mustache> createMustacheCache() {
        return new ConcurrentHashMap<String, Mustache>();
    }

    protected ConcurrentHashMap<FragmentKey, Mustache> createLambdaCache() {
        return new ConcurrentHashMap<FragmentKey, Mustache>();
    }
}

