/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.rxgrpc.stub;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.rxgrpc.stub.RxCallOptions;
import com.salesforce.rxgrpc.stub.RxClientStreamObserverAndPublisher;
import com.salesforce.rxgrpc.stub.RxSubscriberAndClientProducer;
import com.salesforce.rxgrpc.stub.SubscribeOnlyOnceSingleOperator;
import io.grpc.CallOptions;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.functions.Consumer;
import org.reactivestreams.Publisher;

public final class ClientCalls {
    private ClientCalls() {
    }

    public static <TRequest, TResponse> Single<TResponse> oneToOne(final Single<TRequest> rxRequest, final BiConsumer<TRequest, StreamObserver<TResponse>> delegate, CallOptions options) {
        try {
            return Single.create((SingleOnSubscribe)new SingleOnSubscribe<TResponse>(){

                public void subscribe(final SingleEmitter<TResponse> emitter) {
                    rxRequest.subscribe(new Consumer<TRequest>(){

                        public void accept(TRequest request) {
                            delegate.accept(request, (Object)new StreamObserver<TResponse>(){

                                public void onNext(TResponse tResponse) {
                                    emitter.onSuccess(tResponse);
                                }

                                public void onError(Throwable throwable) {
                                    emitter.onError(throwable);
                                }

                                public void onCompleted() {
                                }
                            });
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        public void accept(Throwable t) {
                            emitter.onError(t);
                        }
                    });
                }
            }).lift(new SubscribeOnlyOnceSingleOperator());
        }
        catch (Throwable throwable) {
            return Single.error((Throwable)throwable);
        }
    }

    public static <TRequest, TResponse> Flowable<TResponse> oneToMany(Single<TRequest> rxRequest, final BiConsumer<TRequest, StreamObserver<TResponse>> delegate, CallOptions options) {
        try {
            final int prefetch = RxCallOptions.getPrefetch(options);
            final int lowTide = RxCallOptions.getLowTide(options);
            return rxRequest.flatMapPublisher(new io.reactivex.functions.Function<TRequest, Publisher<? extends TResponse>>(){

                public Publisher<? extends TResponse> apply(TRequest request) {
                    RxClientStreamObserverAndPublisher consumerStreamObserver = new RxClientStreamObserverAndPublisher(null, null, prefetch, lowTide);
                    delegate.accept(request, consumerStreamObserver);
                    return consumerStreamObserver;
                }
            });
        }
        catch (Throwable throwable) {
            return Flowable.error((Throwable)throwable);
        }
    }

    public static <TRequest, TResponse> Single<TResponse> manyToOne(Flowable<TRequest> flowableSource, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate, CallOptions options) {
        try {
            final RxSubscriberAndClientProducer subscriberAndGRPCProducer = (RxSubscriberAndClientProducer)flowableSource.subscribeWith(new RxSubscriberAndClientProducer());
            RxClientStreamObserverAndPublisher observerAndPublisher = new RxClientStreamObserverAndPublisher(new com.salesforce.reactivegrpc.common.Consumer<CallStreamObserver<?>>(){

                public void accept(CallStreamObserver<?> observer) {
                    subscriberAndGRPCProducer.subscribe(observer);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    subscriberAndGRPCProducer.cancel();
                }
            });
            return Flowable.fromPublisher(observerAndPublisher).doOnSubscribe(s -> {
                StreamObserver cfr_ignored_0 = (StreamObserver)delegate.apply((Object)observerAndPublisher);
            }).singleOrError();
        }
        catch (Throwable throwable) {
            return Single.error((Throwable)throwable);
        }
    }

    public static <TRequest, TResponse> Flowable<TResponse> manyToMany(Flowable<TRequest> flowableSource, Function<StreamObserver<TResponse>, StreamObserver<TRequest>> delegate, CallOptions options) {
        int prefetch = RxCallOptions.getPrefetch(options);
        int lowTide = RxCallOptions.getLowTide(options);
        try {
            final RxSubscriberAndClientProducer subscriberAndGRPCProducer = (RxSubscriberAndClientProducer)flowableSource.subscribeWith(new RxSubscriberAndClientProducer());
            RxClientStreamObserverAndPublisher observerAndPublisher = new RxClientStreamObserverAndPublisher(new com.salesforce.reactivegrpc.common.Consumer<CallStreamObserver<?>>(){

                public void accept(CallStreamObserver<?> observer) {
                    subscriberAndGRPCProducer.subscribe(observer);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    subscriberAndGRPCProducer.cancel();
                }
            }, prefetch, lowTide);
            return Flowable.fromPublisher(observerAndPublisher).doOnSubscribe(s -> {
                StreamObserver cfr_ignored_0 = (StreamObserver)delegate.apply((Object)observerAndPublisher);
            });
        }
        catch (Throwable throwable) {
            return Flowable.error((Throwable)throwable);
        }
    }
}

