/*
 * Decompiled with CFR 0.152.
 */
package utam.lightning.pageobjects.impl;

import java.util.List;
import utam.core.element.BasicElement;
import utam.core.element.Locator;
import utam.core.framework.base.BasePageObject;
import utam.core.framework.base.ElementLocation;
import utam.core.framework.base.ElementMarker;
import utam.core.framework.base.PageObject;
import utam.core.framework.element.BasePageElement;
import utam.core.selenium.element.LocatorBy;
import utam.lightning.pageobjects.ButtonMenu;
import utam.lightning.pageobjects.MenuItem;
import utam.lightning.pageobjects.PrimitiveIcon;
import utam.lightning.pageobjects.Spinner;

public final class ButtonMenuImpl
extends BasePageObject
implements ButtonMenu {
    @ElementMarker.Find(css="slot > lightning-menu-item:nth-child(%d)")
    private ElementLocation menuItem;
    @ElementMarker.Find(css="lightning-menu-item")
    private ElementLocation menuItemByText;
    @ElementMarker.Find(css=".slds-dropdown__list slot > lightning-menu-item")
    private ElementLocation allMenuItems;
    @ElementMarker.Find(css="button", expand=true)
    private ElementLocation button;
    @ElementMarker.Find(css="lightning-spinner", expand=true, nullable=true)
    private ElementLocation spinner;
    @ElementMarker.Find(css=".slds-dropdown", expand=true, nullable=true)
    private ElementLocation dropdown;
    @ElementMarker.Find(css="lightning-primitive-icon", expand=true)
    private ElementLocation icon;

    @Override
    public final ButtonMenu.ButtonElement getButton() {
        BasePageElement root = this.getRootElement();
        return (ButtonMenu.ButtonElement)this.basic((BasicElement)root, this.button).build(ButtonMenu.ButtonElement.class, ButtonElementImpl.class);
    }

    @Override
    public final ButtonMenu.DropdownElement getDropdown() {
        BasePageElement root = this.getRootElement();
        return (ButtonMenu.DropdownElement)this.basic((BasicElement)root, this.dropdown).build(ButtonMenu.DropdownElement.class, DropdownElementImpl.class);
    }

    @Override
    public final <T extends PageObject> List<T> getAllCustomMenuItems(Class<T> pageObjectType) {
        BasePageElement root = this.getRootElement();
        LocatorBy allCustomMenuItemsLocator = LocatorBy.byCss((String)":scope *");
        return this.container((BasicElement)root, false).loadList(pageObjectType, (Locator)allCustomMenuItemsLocator);
    }

    @Override
    public final <T extends PageObject> T getCustomMenuItemByTitle(String title, Class<T> pageObjectType) {
        BasePageElement root = this.getRootElement();
        LocatorBy customMenuItemByTitleLocator = LocatorBy.byCss((String)String.format(":scope *[title='%s']", title));
        return (T)this.container((BasicElement)root, false).load(pageObjectType, (Locator)customMenuItemByTitleLocator);
    }

    @Override
    public final <T extends PageObject> T getCustomMenuItemByIndex(Integer index, Class<T> pageObjectType) {
        BasePageElement root = this.getRootElement();
        LocatorBy customMenuItemByIndexLocator = LocatorBy.byCss((String)String.format(":scope *:nth-of-type(%d)", index));
        return (T)this.container((BasicElement)root, false).load(pageObjectType, (Locator)customMenuItemByIndexLocator);
    }

    @Override
    public final MenuItem getMenuItem(Integer itemIndex) {
        BasePageElement root = this.getRootElement();
        return (MenuItem)this.custom((BasicElement)root, this.menuItem.setParameters(new Object[]{itemIndex})).build(MenuItem.class);
    }

    @Override
    public final MenuItem getMenuItemByText(String text) {
        BasePageElement root = this.getRootElement();
        return (MenuItem)this.custom((BasicElement)root, this.menuItemByText).build(MenuItem.class, elm -> elm.getItemText() != null && elm.getItemText().contains(text));
    }

    @Override
    public final List<MenuItem> getAllMenuItems() {
        BasePageElement root = this.getRootElement();
        return this.custom((BasicElement)root, this.allMenuItems).buildList(MenuItem.class);
    }

    @Override
    public final <T extends PageObject> T getMenuHeaderByIndex(Integer index, Class<T> pageObjectType) {
        BasePageElement root = this.getRootElement();
        LocatorBy menuHeaderByIndexLocator = LocatorBy.byCss((String)String.format("slot > lightning-menu-subheader:nth-child(%d)", index));
        return (T)this.container((BasicElement)root, false).load(pageObjectType, (Locator)menuHeaderByIndexLocator);
    }

    final Spinner getSpinnerElement() {
        BasePageElement root = this.getRootElement();
        return (Spinner)this.custom((BasicElement)root, this.spinner).build(Spinner.class);
    }

    @Override
    public final PrimitiveIcon getIcon() {
        BasePageElement root = this.getRootElement();
        return (PrimitiveIcon)this.custom((BasicElement)root, this.icon).build(PrimitiveIcon.class);
    }

    @Override
    public final Boolean clickButton() {
        ButtonMenu.ButtonElement button0 = this.getButton();
        button0.scrollToCenter();
        Boolean statement1 = (Boolean)this.waitFor(() -> {
            ButtonMenu.ButtonElement pbutton0 = this.getButton();
            pbutton0.click();
            ButtonMenu.DropdownElement pdropdown1 = this.getDropdown();
            if (pdropdown1 == null) {
                return false;
            }
            Boolean pstatement1 = pdropdown1.isVisible();
            return pstatement1;
        });
        return statement1;
    }

    @Override
    public final void hover() {
        ButtonMenu.ButtonElement button0 = this.getButton();
        button0.scrollToTop();
        button0.moveTo();
    }

    @Override
    public final Boolean isLoading() {
        Spinner statement0 = this.getSpinnerElement();
        Boolean matcher0 = statement0 != null;
        return matcher0;
    }

    @Override
    public final Boolean isDropdownOpened() {
        BasePageElement root0 = this.getRootElement();
        String statement0 = root0.getClassAttribute();
        Boolean matcher0 = statement0 != null && statement0.contains("slds-is-open");
        return matcher0;
    }

    @Override
    public final Boolean waitForDropdownToOpen() {
        Boolean statement0 = (Boolean)this.waitFor(() -> {
            ButtonMenu.DropdownElement pdropdown0 = this.getDropdown();
            if (pdropdown0 == null) {
                return false;
            }
            Boolean pstatement0 = pdropdown0.isVisible();
            return pstatement0;
        });
        return statement0;
    }

    @Override
    public final ButtonMenu waitForCustomMenuItemByTitle(String title) {
        this.waitFor(() -> {
            BasePageElement proot0 = this.getRootElement();
            Boolean pstatement0 = proot0.containsElement((Locator)LocatorBy.byCss((String)String.format(":scope *[title='%s']", title)));
            return pstatement0;
        });
        return this;
    }

    public static class DropdownElementImpl
    extends BasePageElement
    implements ButtonMenu.DropdownElement {
    }

    public static class ButtonElementImpl
    extends BasePageElement
    implements ButtonMenu.ButtonElement {
    }
}

