/*
 * Decompiled with CFR 0.152.
 */
package utam.lightning.utils;

import java.util.List;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.lightning.pageobjects.FormattedAddress;
import utam.lightning.pageobjects.OutputField;

public class OutputFieldUtils {
    public static String getFieldValue(UtamUtilitiesContext context, String fieldType) {
        OutputField outputFieldPO = (OutputField)context.getPageObject();
        switch (fieldType) {
            case "name": {
                return outputFieldPO.getNameString();
            }
            case "address": {
                return outputFieldPO.getAddressString();
            }
            case "text": {
                return outputFieldPO.getTextString();
            }
            case "number": {
                return outputFieldPO.getNumberString();
            }
            case "email": {
                return outputFieldPO.getEmailString();
            }
            case "location": {
                return outputFieldPO.getLocationString();
            }
            case "phone": {
                return outputFieldPO.getPhoneString();
            }
            case "url": {
                return outputFieldPO.getUrlString();
            }
            case "richtext": {
                return outputFieldPO.getRichtextString();
            }
            case "lookup": {
                return outputFieldPO.getLookupString();
            }
        }
        throw new AssertionError((Object)String.format("OutputField Page Object utilities: unknown field type '%s'", fieldType));
    }

    public static String getAddress(UtamUtilitiesContext context) {
        OutputField outputFieldPO = (OutputField)context.getPageObject();
        FormattedAddress formattedAddress = outputFieldPO.getFormattedAddress();
        if (formattedAddress.isEnabled().booleanValue()) {
            List<String> textSegments = formattedAddress.getTextContent();
            return String.join((CharSequence)"\n", textSegments);
        }
        return formattedAddress.getTitleText();
    }
}

