/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.pageobjects.chatter.impl;

import utam.core.element.BasicElement;
import utam.core.element.Clickable;
import utam.core.element.Editable;
import utam.core.framework.base.BaseRootPageObject;
import utam.core.framework.base.ElementLocation;
import utam.core.framework.base.ElementMarker;
import utam.core.framework.base.PageMarker;
import utam.core.framework.context.PlatformType;
import utam.core.framework.element.BasePageElement;
import utam.salesforceapp.pageobjects.chatter.ChatterDetail;
import utam.salesforceapp.pageobjects.chatter.ChatterPostCell;

@PageMarker.Find(uiautomator="resourceId(\"com.salesforce.chatter:id/feedHomeViewContainer\")")
@PageMarker.Switch(value=PlatformType.NATIVE)
public final class ChatterDetailAndroidImpl
extends BaseRootPageObject
implements ChatterDetail {
    @ElementMarker.Find(uiautomator="className(\"android.view.ViewGroup\").descriptionMatches(\"^[0-9]+\")")
    private ElementLocation postDetail;
    @ElementMarker.Find(uiautomator="resourceId(\"com.salesforce.chatter:id/feedsdk_mention\")")
    private ElementLocation mentionIcon;
    @ElementMarker.Find(uiautomator="resourceId(\"com.salesforce.chatter:id/feedsdk_attach\")")
    private ElementLocation attachIcon;
    @ElementMarker.Find(uiautomator="resourceId(\"com.salesforce.chatter:id/feedsdk_publisher_submit\")")
    private ElementLocation postButton;
    @ElementMarker.Find(uiautomator="resourceId(\"com.salesforce.chatter:id/feedsdk_publisher_text\")")
    private ElementLocation commentInput;
    @ElementMarker.Find(uiautomator="className(\"android.widget.TextView\").textContains(\"%s\")")
    private ElementLocation linkInPost;

    final MentionIconElement getMentionIconElement() {
        BasePageElement root = this.getRootElement();
        return (MentionIconElement)this.basic((BasicElement)root, this.mentionIcon).build(MentionIconElement.class, MentionIconElementImpl.class);
    }

    final AttachIconElement getAttachIconElement() {
        BasePageElement root = this.getRootElement();
        return (AttachIconElement)this.basic((BasicElement)root, this.attachIcon).build(AttachIconElement.class, AttachIconElementImpl.class);
    }

    final PostButtonElement getPostButtonElement() {
        BasePageElement root = this.getRootElement();
        return (PostButtonElement)this.basic((BasicElement)root, this.postButton).build(PostButtonElement.class, PostButtonElementImpl.class);
    }

    final CommentInputElement getCommentInputElement() {
        BasePageElement root = this.getRootElement();
        return (CommentInputElement)this.basic((BasicElement)root, this.commentInput).build(CommentInputElement.class, CommentInputElementImpl.class);
    }

    final LinkInPostElement getLinkInPostElement(String link) {
        BasePageElement root = this.getRootElement();
        return (LinkInPostElement)this.basic((BasicElement)root, this.linkInPost.setParameters(new Object[]{link})).build(LinkInPostElement.class, LinkInPostElementImpl.class);
    }

    @Override
    public final ChatterPostCell getPostDetail() {
        BasePageElement root = this.getRootElement();
        return (ChatterPostCell)this.custom((BasicElement)root, this.postDetail).build(ChatterPostCell.class);
    }

    public final Object load() {
        Boolean statement0 = (Boolean)this.waitFor(() -> {
            BasePageElement proot0 = this.getRootElement();
            Boolean pstatement0 = proot0.isPresent();
            return pstatement0;
        });
        return statement0;
    }

    @Override
    public final void clickMentionIcon() {
        MentionIconElement mentionIcon0 = this.getMentionIconElement();
        mentionIcon0.click();
    }

    @Override
    public final void clickAttachIcon() {
        AttachIconElement attachIcon0 = this.getAttachIconElement();
        attachIcon0.click();
    }

    @Override
    public final void clickPostButton() {
        PostButtonElement postButton0 = this.getPostButtonElement();
        postButton0.click();
    }

    @Override
    public final void clickOnLinkInPost(String link) {
        LinkInPostElement linkInPost0 = this.getLinkInPostElement(link);
        linkInPost0.click();
    }

    @Override
    public final void typeText(String textToType) {
        CommentInputElement commentInput0 = this.getCommentInputElement();
        commentInput0.setText(textToType);
    }

    public static class LinkInPostElementImpl
    extends BasePageElement
    implements LinkInPostElement {
    }

    public static class CommentInputElementImpl
    extends BasePageElement
    implements CommentInputElement {
    }

    public static class PostButtonElementImpl
    extends BasePageElement
    implements PostButtonElement {
    }

    public static class AttachIconElementImpl
    extends BasePageElement
    implements AttachIconElement {
    }

    public static class MentionIconElementImpl
    extends BasePageElement
    implements MentionIconElement {
    }

    static interface LinkInPostElement
    extends Clickable {
    }

    static interface CommentInputElement
    extends Clickable,
    Editable {
    }

    static interface PostButtonElement
    extends Clickable {
    }

    static interface AttachIconElement
    extends Clickable {
    }

    static interface MentionIconElement
    extends Clickable {
    }
}

