/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.mobilehome;

import java.util.List;
import java.util.function.IntFunction;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.mobilehome.HomeCardList;

public class HomeCardListiOSUtils
extends ImperativeProvider<HomeCardList> {
    private static final int MAX_NUM_OF_FLICK = 25;

    HomeCardListiOSUtils(HomeCardList instance) {
        super((PageObject)instance);
    }

    HomeCardListiOSUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clickCardBadgeWithLabel(UtamUtilitiesContext context, String badgeLabel) {
        HomeCardList pageObject = (HomeCardList)context.getPageObject();
        if (!pageObject.hasCardWithBadgeLabel(badgeLabel).booleanValue()) throw new UtamError("Unable to find nav item with label '" + badgeLabel + "'");
        List<HomeCardList.GetVisibleCardBadgesElement> onScreenItems = pageObject.getVisibleCardBadges();
        HomeCardList.GetVisibleCardBadgesElement matchedItem = HomeCardListiOSUtils.getCardBadgeWithLabel(onScreenItems, badgeLabel);
        if (matchedItem != null) {
            matchedItem.click();
            return;
        } else {
            HomeCardList.GetVisibleCardBadgesElement matchedVisibleItem = HomeCardListiOSUtils.scrollCardBadgeIntoView(context, badgeLabel);
            if (matchedVisibleItem == null) throw new UtamError("Unable to scroll to and click on nav item with label '" + badgeLabel + "'");
            matchedVisibleItem.click();
        }
    }

    private static HomeCardList.GetVisibleCardBadgesElement scrollCardBadgeIntoView(UtamUtilitiesContext context, String itemLabel) {
        IntFunction<HomeCardList.GetVisibleCardBadgesElement> flickFunction = yFlick -> {
            int size;
            HomeCardList pageObject = (HomeCardList)context.getPageObject();
            List<HomeCardList.GetVisibleCardBadgesElement> onScreenCardBadges = pageObject.getVisibleCardBadges();
            int n = size = onScreenCardBadges != null ? onScreenCardBadges.size() : 0;
            if (0 == size) {
                return null;
            }
            HomeCardList.GetVisibleCardBadgesElement matchedVisibleItem = HomeCardListiOSUtils.getCardBadgeWithLabel(onScreenCardBadges, itemLabel);
            if (matchedVisibleItem != null) {
                return matchedVisibleItem;
            }
            String directionalEndBeforeFlick = onScreenCardBadges.get(size - 1).getText();
            String directionalEndAfterFlick = null;
            int flickCount = 0;
            do {
                pageObject.getRoot().flick(0, yFlick);
                ++flickCount;
                onScreenCardBadges = pageObject.getVisibleCardBadges();
                int n2 = size = onScreenCardBadges != null ? onScreenCardBadges.size() : 0;
                if (0 < size) {
                    directionalEndAfterFlick = onScreenCardBadges.get(size - 1).getText();
                    matchedVisibleItem = HomeCardListiOSUtils.getCardBadgeWithLabel(onScreenCardBadges, itemLabel);
                }
                if (matchedVisibleItem != null || directionalEndBeforeFlick == null && directionalEndAfterFlick == null || directionalEndBeforeFlick != null && directionalEndBeforeFlick.equals(directionalEndAfterFlick)) {
                    return matchedVisibleItem;
                }
                onScreenCardBadges = pageObject.getVisibleCardBadges();
                int n3 = size = onScreenCardBadges != null ? onScreenCardBadges.size() : 0;
                if (0 >= size) continue;
                directionalEndBeforeFlick = onScreenCardBadges.get(size - 1).getText();
            } while (flickCount < 25);
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        };
        int yFlick2 = 400;
        HomeCardList.GetVisibleCardBadgesElement matchedVisibleItem = flickFunction.apply(-yFlick2);
        if (matchedVisibleItem == null) {
            matchedVisibleItem = flickFunction.apply(yFlick2);
        }
        return matchedVisibleItem;
    }

    private static HomeCardList.GetVisibleCardBadgesElement getCardBadgeWithLabel(List<HomeCardList.GetVisibleCardBadgesElement> items, String itemLabel) {
        return items.stream().filter(item -> item.getText().equalsIgnoreCase(itemLabel)).findFirst().orElse(null);
    }

    public static Boolean hasCardWithTitle(UtamUtilitiesContext context, String itemLabel) {
        HomeCardList.GetVisibleCardBadgesElement cardTitleElement = HomeCardListiOSUtils.scrollCardBadgeIntoView(context, itemLabel);
        return cardTitleElement != null;
    }

    public static String scrollToElementToGetText(UtamUtilitiesContext context, String itemLabel) {
        HomeCardList pageObject = (HomeCardList)context.getPageObject();
        List<HomeCardList.GetVisibleCardBadgesElement> onScreenCardBadges = pageObject.getVisibleCardBadges();
        int size = onScreenCardBadges.size();
        HomeCardList.GetVisibleCardBadgesElement matchedVisibleItem = HomeCardListiOSUtils.getCardBadgeWithLabel(onScreenCardBadges, itemLabel);
        if (matchedVisibleItem == null && 1 < size) {
            HomeCardList.GetVisibleCardBadgesElement cardTitleElement = HomeCardListiOSUtils.scrollCardBadgeIntoView(context, itemLabel);
            if (cardTitleElement != null && cardTitleElement.isVisible()) {
                return cardTitleElement.getText();
            }
        } else if (matchedVisibleItem != null) {
            return matchedVisibleItem.getText();
        }
        return "";
    }
}

