/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.navigation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.navigation.AppItemsList;

public class AppItemiOSUtils
extends ImperativeProvider<AppItemsList> {
    private static final int MAX_NUM_OF_SCROLL = 25;

    AppItemiOSUtils(AppItemsList instance) {
        super((PageObject)instance);
    }

    AppItemiOSUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clickAppItem(UtamUtilitiesContext context, String appTitle) {
        AppItemsList pageObject = (AppItemsList)context.getPageObject();
        if (!pageObject.hasAppItemWithTitle(appTitle).booleanValue()) throw new UtamError("Unable to find app item with title '" + appTitle + "'");
        List<AppItemsList.GetVisibleAppItemsElement> onScreenItems = pageObject.getVisibleAppItems();
        Optional<AppItemsList.GetVisibleAppItemsElement> matchedItems = AppItemiOSUtils.getAppItemWithTitle(onScreenItems, appTitle);
        if (!matchedItems.isEmpty()) {
            matchedItems.get().click();
            return;
        } else {
            Optional<AppItemsList.GetVisibleAppItemsElement> matchedVisibleItems = AppItemiOSUtils.scrollAppItemIntoView(context, appTitle);
            if (matchedVisibleItems.isEmpty()) throw new UtamError("Unable to scroll to and click on app item with title '" + appTitle + "'");
            matchedVisibleItems.get().click();
        }
    }

    private static Optional<AppItemsList.GetVisibleAppItemsElement> scrollAppItemIntoView(UtamUtilitiesContext context, String appTitle) {
        Optional<AppItemsList.GetVisibleAppItemsElement> matchedVisibleItems;
        AppItemsList pageObject = (AppItemsList)context.getPageObject();
        List<Object> onScreenItems = new ArrayList();
        boolean isFlicked = false;
        int scrollCount = 0;
        int size = 0;
        do {
            if ((size = (onScreenItems = pageObject.getVisibleAppItems()).size()) > 1) {
                String lastBeforeFlick = ((AppItemsList.GetVisibleAppItemsElement)onScreenItems.get(size - 1)).getText();
                pageObject.getRoot().flick(0, -400);
                onScreenItems = pageObject.getVisibleAppItems();
                size = onScreenItems.size();
                if (size > 1) {
                    String lastAfterFlick = ((AppItemsList.GetVisibleAppItemsElement)onScreenItems.get(size - 1)).getText();
                    isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
                }
            }
            matchedVisibleItems = AppItemiOSUtils.getAppItemWithTitle(onScreenItems, appTitle);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (!matchedVisibleItems.isEmpty()) {
            return matchedVisibleItems;
        }
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        scrollCount = 0;
        do {
            size = onScreenItems.size();
            String firstBeforeFlick = ((AppItemsList.GetVisibleAppItemsElement)onScreenItems.get(0)).getText();
            pageObject.getRoot().flick(0, 400);
            onScreenItems = pageObject.getVisibleAppItems();
            size = onScreenItems.size();
            if (size > 0) {
                String firstAfterFlick = ((AppItemsList.GetVisibleAppItemsElement)onScreenItems.get(0)).getText();
                isFlicked = !firstAfterFlick.equals(firstBeforeFlick);
            }
            matchedVisibleItems = AppItemiOSUtils.getAppItemWithTitle(onScreenItems, appTitle);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        return matchedVisibleItems;
    }

    private static Optional<AppItemsList.GetVisibleAppItemsElement> getAppItemWithTitle(List<AppItemsList.GetVisibleAppItemsElement> items, String itemTitle) {
        return items.stream().filter(item -> item.getText().equalsIgnoreCase(itemTitle)).findFirst();
    }
}

