/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.navigation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.navigation.NavItemsList;

public class NavItemsListiOSUtils
extends ImperativeProvider<NavItemsList> {
    private static final int MAX_NUM_OF_SCROLL = 25;

    NavItemsListiOSUtils(NavItemsList instance) {
        super((PageObject)instance);
    }

    NavItemsListiOSUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clickNavItem(UtamUtilitiesContext context, String itemLabel) {
        NavItemsList pageObject = (NavItemsList)context.getPageObject();
        if (!pageObject.hasNavItemWithLabel(itemLabel).booleanValue()) throw new UtamError("Unable to find nav item with label '" + itemLabel + "'");
        List<NavItemsList.GetVisibleNavItemsElement> onScreenItems = pageObject.getVisibleNavItems();
        Optional<NavItemsList.GetVisibleNavItemsElement> matchedItems = NavItemsListiOSUtils.getNavItemWithLabel(onScreenItems, itemLabel);
        if (!matchedItems.isEmpty()) {
            matchedItems.get().click();
            return;
        } else {
            Optional<NavItemsList.GetVisibleNavItemsElement> matchedVisibleItems = NavItemsListiOSUtils.scrollNavItemIntoView(context, itemLabel);
            if (matchedVisibleItems.isEmpty()) throw new UtamError("Unable to scroll to and click on nav item with label '" + itemLabel + "'");
            matchedVisibleItems.get().click();
        }
    }

    private static Optional<NavItemsList.GetVisibleNavItemsElement> scrollNavItemIntoView(UtamUtilitiesContext context, String itemLabel) {
        Optional<NavItemsList.GetVisibleNavItemsElement> matchedVisibleItems;
        NavItemsList pageObject = (NavItemsList)context.getPageObject();
        List<Object> onScreenItems = new ArrayList();
        boolean isFlicked = false;
        int scrollCount = 0;
        int size = 0;
        do {
            if ((size = (onScreenItems = pageObject.getVisibleNavItems()).size()) > 1) {
                String lastBeforeFlick = ((NavItemsList.GetVisibleNavItemsElement)onScreenItems.get(size - 1)).getText();
                pageObject.getRoot().flick(0, -400);
                onScreenItems = pageObject.getVisibleNavItems();
                size = onScreenItems.size();
                if (size > 1) {
                    String lastAfterFlick = ((NavItemsList.GetVisibleNavItemsElement)onScreenItems.get(size - 1)).getText();
                    isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
                }
            }
            matchedVisibleItems = NavItemsListiOSUtils.getNavItemWithLabel(onScreenItems, itemLabel);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (!matchedVisibleItems.isEmpty()) {
            return matchedVisibleItems;
        }
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        scrollCount = 0;
        do {
            size = onScreenItems.size();
            String firstBeforeFlick = ((NavItemsList.GetVisibleNavItemsElement)onScreenItems.get(0)).getText();
            pageObject.getRoot().flick(0, 400);
            onScreenItems = pageObject.getVisibleNavItems();
            size = onScreenItems.size();
            if (size > 0) {
                String firstAfterFlick = ((NavItemsList.GetVisibleNavItemsElement)onScreenItems.get(0)).getText();
                isFlicked = !firstAfterFlick.equals(firstBeforeFlick);
            }
            matchedVisibleItems = NavItemsListiOSUtils.getNavItemWithLabel(onScreenItems, itemLabel);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        return matchedVisibleItems;
    }

    private static Optional<NavItemsList.GetVisibleNavItemsElement> getNavItemWithLabel(List<NavItemsList.GetVisibleNavItemsElement> items, String itemLabel) {
        return items.stream().filter(item -> item.getText().equalsIgnoreCase(itemLabel)).findFirst();
    }
}

