/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.record;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.record.ActionBarOverflow;

public class ActionBarOverflowiOSUtils
extends ImperativeProvider<ActionBarOverflow> {
    private static final int MAX_NUM_OF_SCROLL = 25;

    ActionBarOverflowiOSUtils(ActionBarOverflow instance) {
        super((PageObject)instance);
    }

    ActionBarOverflowiOSUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clickAction(UtamUtilitiesContext context, String label) {
        ActionBarOverflow pageObject = (ActionBarOverflow)context.getPageObject();
        if (!pageObject.getAllActionLabels().contains(label)) throw new UtamError("Unable to find action with label '" + label + "'");
        List<ActionBarOverflow.GetVisibleActionsElement> onScreenItems = pageObject.getVisibleActions();
        Optional<ActionBarOverflow.GetVisibleActionsElement> matchedItems = ActionBarOverflowiOSUtils.getActionWithLabel(onScreenItems, label);
        if (!matchedItems.isEmpty()) {
            matchedItems.get().click();
            return;
        } else {
            Optional<ActionBarOverflow.GetVisibleActionsElement> matchedVisibleItems = ActionBarOverflowiOSUtils.scrollActionIntoView(context, label);
            if (matchedVisibleItems.isEmpty()) throw new UtamError("Unable to scroll to and click on action with label '" + label + "'");
            matchedVisibleItems.get().click();
        }
    }

    private static Optional<ActionBarOverflow.GetVisibleActionsElement> scrollActionIntoView(UtamUtilitiesContext context, String itemLabel) {
        Optional<ActionBarOverflow.GetVisibleActionsElement> matchedVisibleItems;
        ActionBarOverflow pageObject = (ActionBarOverflow)context.getPageObject();
        List<Object> onScreenItems = new ArrayList();
        boolean isFlicked = false;
        int scrollCount = 0;
        int size = 0;
        do {
            if ((size = (onScreenItems = pageObject.getVisibleActions()).size()) > 1) {
                String lastBeforeFlick = ((ActionBarOverflow.GetVisibleActionsElement)onScreenItems.get(size - 1)).getText();
                pageObject.getRoot().flick(0, -200);
                onScreenItems = pageObject.getVisibleActions();
                size = onScreenItems.size();
                if (size > 1) {
                    String lastAfterFlick = ((ActionBarOverflow.GetVisibleActionsElement)onScreenItems.get(size - 1)).getText();
                    isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
                }
            }
            matchedVisibleItems = ActionBarOverflowiOSUtils.getActionWithLabel(onScreenItems, itemLabel);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (!matchedVisibleItems.isEmpty()) {
            return matchedVisibleItems;
        }
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        return matchedVisibleItems;
    }

    private static Optional<ActionBarOverflow.GetVisibleActionsElement> getActionWithLabel(List<ActionBarOverflow.GetVisibleActionsElement> items, String itemLabel) {
        return items.stream().filter(item -> item.getText().equalsIgnoreCase(itemLabel)).findFirst();
    }
}

