/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.record;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.record.FavoriteList;

public class FavoriteListiOSUtils
extends ImperativeProvider<FavoriteList> {
    private static final int MAX_NUM_OF_SCROLL = 25;

    FavoriteListiOSUtils(FavoriteList instance) {
        super((PageObject)instance);
    }

    FavoriteListiOSUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clickRecord(UtamUtilitiesContext context, String title) {
        FavoriteList pageObject = (FavoriteList)context.getPageObject();
        if (!pageObject.hasRecord(title).booleanValue()) throw new UtamError("Unable to find record with title '" + title + "'");
        List<FavoriteList.GetVisibleFavoriteRecordsElement> onScreenItems = pageObject.getVisibleFavoriteRecords();
        Optional<FavoriteList.GetVisibleFavoriteRecordsElement> matchedItems = FavoriteListiOSUtils.getRecordsWithTitle(onScreenItems, title);
        if (!matchedItems.isEmpty()) {
            matchedItems.get().click();
            return;
        } else {
            Optional<FavoriteList.GetVisibleFavoriteRecordsElement> matchedVisibleItems = FavoriteListiOSUtils.scrollRecordIntoView(context, title);
            if (matchedVisibleItems.isEmpty()) throw new UtamError("Unable to scroll to and click on record with title '" + title + "'");
            matchedVisibleItems.get().click();
        }
    }

    private static Optional<FavoriteList.GetVisibleFavoriteRecordsElement> scrollRecordIntoView(UtamUtilitiesContext context, String title) {
        Optional<FavoriteList.GetVisibleFavoriteRecordsElement> matchedVisibleItems;
        FavoriteList pageObject = (FavoriteList)context.getPageObject();
        List<Object> onScreenItems = new ArrayList();
        boolean isFlicked = false;
        int scrollCount = 0;
        int size = 0;
        do {
            if ((size = (onScreenItems = pageObject.getVisibleFavoriteRecords()).size()) > 1) {
                String lastBeforeFlick = ((FavoriteList.GetVisibleFavoriteRecordsElement)onScreenItems.get(size - 1)).getText();
                pageObject.getRoot().flick(0, -400);
                onScreenItems = pageObject.getVisibleFavoriteRecords();
                size = onScreenItems.size();
                if (size > 1) {
                    String lastAfterFlick = ((FavoriteList.GetVisibleFavoriteRecordsElement)onScreenItems.get(size - 1)).getText();
                    isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
                }
            }
            matchedVisibleItems = FavoriteListiOSUtils.getRecordsWithTitle(onScreenItems, title);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (!matchedVisibleItems.isEmpty()) {
            return matchedVisibleItems;
        }
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        scrollCount = 0;
        do {
            size = onScreenItems.size();
            String firstBeforeFlick = ((FavoriteList.GetVisibleFavoriteRecordsElement)onScreenItems.get(0)).getText();
            pageObject.getRoot().flick(0, 400);
            onScreenItems = pageObject.getVisibleFavoriteRecords();
            size = onScreenItems.size();
            if (size > 0) {
                String firstAfterFlick = ((FavoriteList.GetVisibleFavoriteRecordsElement)onScreenItems.get(0)).getText();
                isFlicked = !firstAfterFlick.equals(firstBeforeFlick);
            }
            matchedVisibleItems = FavoriteListiOSUtils.getRecordsWithTitle(onScreenItems, title);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        return matchedVisibleItems;
    }

    private static Optional<FavoriteList.GetVisibleFavoriteRecordsElement> getRecordsWithTitle(List<FavoriteList.GetVisibleFavoriteRecordsElement> items, String title) {
        return items.stream().filter(item -> item.getText().equalsIgnoreCase(title)).findFirst();
    }
}

