/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.record;

import java.util.List;
import java.util.Optional;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.record.ObjectAllLists;

public class ObjectAllListsiOSUtils
extends ImperativeProvider<ObjectAllLists> {
    private static final int MAX_NUM_OF_SCROLL = 25;

    ObjectAllListsiOSUtils(ObjectAllLists instance) {
        super((PageObject)instance);
    }

    ObjectAllListsiOSUtils() {
    }

    public static boolean hasList(UtamUtilitiesContext context, String label) {
        Optional<ObjectAllLists.GetVisibleListCellsElement> matchedItems = ObjectAllListsiOSUtils.scrollListIntoView(context, label);
        return !matchedItems.isEmpty();
    }

    public static void clickListCell(UtamUtilitiesContext context, String label) {
        Optional<ObjectAllLists.GetVisibleListCellsElement> matchedItems = ObjectAllListsiOSUtils.scrollListIntoView(context, label);
        if (matchedItems.isEmpty()) {
            throw new UtamError("Unable to scroll to and click on list with label '" + label + "'");
        }
        matchedItems.get().click();
    }

    private static Optional<ObjectAllLists.GetVisibleListCellsElement> scrollListIntoView(UtamUtilitiesContext context, String label) {
        Optional<ObjectAllLists.GetVisibleListCellsElement> matchedVisibleItems;
        ObjectAllLists pageObject = (ObjectAllLists)context.getPageObject();
        List<ObjectAllLists.GetVisibleListCellsElement> onScreenItems = pageObject.getVisibleListCells();
        Optional<ObjectAllLists.GetVisibleListCellsElement> matchedItems = ObjectAllListsiOSUtils.getListCellWithTitle(onScreenItems, label);
        if (!matchedItems.isEmpty()) {
            return matchedItems;
        }
        boolean isFlicked = false;
        int scrollCount = 0;
        int size = 0;
        do {
            if ((size = onScreenItems.size()) > 1) {
                String lastBeforeFlick = onScreenItems.get(size - 1).getText();
                pageObject.getRoot().flick(0, -400);
                onScreenItems = pageObject.getVisibleListCells();
                size = onScreenItems.size();
                if (size > 1) {
                    String lastAfterFlick = onScreenItems.get(size - 1).getText();
                    isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
                }
            }
            matchedVisibleItems = ObjectAllListsiOSUtils.getListCellWithTitle(onScreenItems, label);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (!matchedVisibleItems.isEmpty()) {
            return matchedVisibleItems;
        }
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        scrollCount = 0;
        do {
            size = onScreenItems.size();
            String firstBeforeFlick = onScreenItems.get(0).getText();
            pageObject.getRoot().flick(0, 400);
            onScreenItems = pageObject.getVisibleListCells();
            size = onScreenItems.size();
            if (size > 0) {
                String firstAfterFlick = onScreenItems.get(0).getText();
                isFlicked = !firstAfterFlick.equals(firstBeforeFlick);
            }
            matchedVisibleItems = ObjectAllListsiOSUtils.getListCellWithTitle(onScreenItems, label);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        return matchedVisibleItems;
    }

    private static Optional<ObjectAllLists.GetVisibleListCellsElement> getListCellWithTitle(List<ObjectAllLists.GetVisibleListCellsElement> items, String label) {
        return items.stream().filter(item -> item.getText().equalsIgnoreCase(label)).findFirst();
    }
}

