/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.record;

import java.util.List;
import java.util.Optional;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.record.SearchResult;

public class SearchResultiOSUtils
extends ImperativeProvider<SearchResult> {
    private static final int MAX_NUM_OF_SCROLL = 25;

    SearchResultiOSUtils(SearchResult instance) {
        super((PageObject)instance);
    }

    SearchResultiOSUtils() {
    }

    public static boolean hasRecord(UtamUtilitiesContext context, String title) {
        Optional<SearchResult.GetVisibleRecordCardsElement> matchedItems = SearchResultiOSUtils.scrollRecordIntoView(context, title);
        return !matchedItems.isEmpty();
    }

    public static void clickRecord(UtamUtilitiesContext context, String title) {
        Optional<SearchResult.GetVisibleRecordCardsElement> matchedItems = SearchResultiOSUtils.scrollRecordIntoView(context, title);
        if (matchedItems.isEmpty()) {
            throw new UtamError("Unable to scroll to and click on record with label '" + title + "'");
        }
        matchedItems.get().click();
    }

    private static Optional<SearchResult.GetVisibleRecordCardsElement> scrollRecordIntoView(UtamUtilitiesContext context, String title) {
        Optional<SearchResult.GetVisibleRecordCardsElement> matchedVisibleItems;
        SearchResult pageObject = (SearchResult)context.getPageObject();
        List<SearchResult.GetVisibleRecordCardsElement> onScreenItems = pageObject.getVisibleRecordCards();
        Optional<SearchResult.GetVisibleRecordCardsElement> matchedItems = SearchResultiOSUtils.getRecordsMatchingTitle(onScreenItems, title);
        if (!matchedItems.isEmpty()) {
            return matchedItems;
        }
        boolean isFlicked = false;
        int scrollCount = 0;
        int size = 0;
        do {
            if ((size = onScreenItems.size()) > 1) {
                String lastBeforeFlick = onScreenItems.get(size - 1).getText();
                pageObject.getRoot().flick(0, -400);
                onScreenItems = pageObject.getVisibleRecordCards();
                size = onScreenItems.size();
                if (size > 1) {
                    String lastAfterFlick = onScreenItems.get(size - 1).getText();
                    isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
                }
            }
            matchedVisibleItems = SearchResultiOSUtils.getRecordsMatchingTitle(onScreenItems, title);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (!matchedVisibleItems.isEmpty()) {
            return matchedVisibleItems;
        }
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        scrollCount = 0;
        do {
            size = onScreenItems.size();
            String firstBeforeFlick = onScreenItems.get(0).getText();
            pageObject.getRoot().flick(0, 400);
            onScreenItems = pageObject.getVisibleRecordCards();
            size = onScreenItems.size();
            if (size > 0) {
                String firstAfterFlick = onScreenItems.get(0).getText();
                isFlicked = !firstAfterFlick.equals(firstBeforeFlick);
            }
            matchedVisibleItems = SearchResultiOSUtils.getRecordsMatchingTitle(onScreenItems, title);
        } while (isFlicked && matchedVisibleItems.isEmpty() && scrollCount++ < 25);
        if (scrollCount > 25) {
            throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
        }
        return matchedVisibleItems;
    }

    private static Optional<SearchResult.GetVisibleRecordCardsElement> getRecordsMatchingTitle(List<SearchResult.GetVisibleRecordCardsElement> items, String title) {
        return items.stream().filter(item -> item.getAttribute("label").contains(title)).findFirst();
    }
}

