/*
 * Decompiled with CFR 0.152.
 */
package utam.lightning.pageobjects.impl;

import java.util.List;
import utam.core.element.BasicElement;
import utam.core.element.Locator;
import utam.core.framework.base.BasePageObject;
import utam.core.framework.base.ElementLocation;
import utam.core.framework.base.ElementMarker;
import utam.core.framework.element.BasePageElement;
import utam.core.selenium.element.LocatorBy;
import utam.lightning.pageobjects.BaseCombobox;
import utam.lightning.pageobjects.BaseComboboxItem;
import utam.lightning.pageobjects.Icon;

public final class BaseComboboxImpl
extends BasePageObject
implements BaseCombobox {
    @ElementMarker.Find(css="div.slds-dropdown_fluid", expand=true)
    private ElementLocation itemsWrapper;
    @ElementMarker.Find(css="lightning-base-combobox-item:nth-of-type(%d)", expand=true)
    private ElementLocation item;
    @ElementMarker.Find(css=".slds-combobox__input", expand=true)
    private ElementLocation selectedItemInput;
    @ElementMarker.Find(css="button[title='Clear Selection']", expand=true)
    private ElementLocation clearSelectionButton;
    @ElementMarker.Find(css="ul[role='group']", expand=true)
    private ElementLocation groups;
    @ElementMarker.Find(css="[aria-checked=true]", expand=true)
    private ElementLocation checkedItem;
    @ElementMarker.Find(css=".slds-is-open", expand=true, nullable=true)
    private ElementLocation opened;
    @ElementMarker.Find(css="lightning-base-combobox-item.slds-has-focus", expand=true, nullable=true)
    private ElementLocation focusedItem;
    @ElementMarker.Find(css="lightning-base-combobox-item", expand=true)
    private ElementLocation itemByLabel;
    @ElementMarker.Find(css="input", expand=true)
    private ElementLocation input;
    @ElementMarker.Find(css="lightning-base-combobox-item", expand=true)
    private ElementLocation itemByValue;
    @ElementMarker.Find(css="lightning-icon", expand=true)
    private ElementLocation triggerIcon;
    @ElementMarker.Find(css=".slds-dropdown-trigger", expand=true)
    private ElementLocation comboboxWrapper;
    @ElementMarker.Find(css="button", expand=true)
    private ElementLocation expandButton;
    @ElementMarker.Find(css="lightning-base-combobox-item", expand=true)
    private ElementLocation items;
    @ElementMarker.Find(css=".slds-combobox__input", expand=true)
    private ElementLocation triggerInput;

    @Override
    public final BaseCombobox.RootElement getRoot() {
        return (BaseCombobox.RootElement)this.getProxy(this.getRootElement(), BaseCombobox.RootElement.class);
    }

    final BaseCombobox.InputElement getInputElement() {
        BaseCombobox.RootElement root = this.getRoot();
        return (BaseCombobox.InputElement)this.basic((BasicElement)root, this.input).build(BaseCombobox.InputElement.class, InputElementImpl.class);
    }

    final BaseCombobox.OpenedElement getOpenedElement() {
        BaseCombobox.RootElement root = this.getRoot();
        return (BaseCombobox.OpenedElement)this.basic((BasicElement)root, this.opened).build(BaseCombobox.OpenedElement.class, OpenedElementImpl.class);
    }

    final BaseCombobox.ExpandButtonElement getExpandButtonElement() {
        BaseCombobox.RootElement root = this.getRoot();
        return (BaseCombobox.ExpandButtonElement)this.basic((BasicElement)root, this.expandButton).build(BaseCombobox.ExpandButtonElement.class, ExpandButtonElementImpl.class);
    }

    @Override
    public final BaseCombobox.TriggerInputElement getTriggerInput() {
        BaseCombobox.RootElement root = this.getRoot();
        return (BaseCombobox.TriggerInputElement)this.basic((BasicElement)root, this.triggerInput).build(BaseCombobox.TriggerInputElement.class, TriggerInputElementImpl.class);
    }

    @Override
    public final List<BasicElement> getGroups() {
        BaseCombobox.RootElement root = this.getRoot();
        return this.basic((BasicElement)root, this.groups).buildList(BasicElement.class, BasePageElement.class);
    }

    final BasicElement getItemsWrapperElement() {
        BaseCombobox.RootElement root = this.getRoot();
        return this.basic((BasicElement)root, this.itemsWrapper).build(BasicElement.class, BasePageElement.class);
    }

    final BasicElement getComboboxWrapperElement() {
        BaseCombobox.RootElement root = this.getRoot();
        return this.basic((BasicElement)root, this.comboboxWrapper).build(BasicElement.class, BasePageElement.class);
    }

    final BasicElement getFocusedItemElement() {
        BaseCombobox.RootElement root = this.getRoot();
        return this.basic((BasicElement)root, this.focusedItem).build(BasicElement.class, BasePageElement.class);
    }

    @Override
    public final BaseCombobox.SelectedItemInputElement getSelectedItemInput() {
        BaseCombobox.RootElement root = this.getRoot();
        return (BaseCombobox.SelectedItemInputElement)this.basic((BasicElement)root, this.selectedItemInput).build(BaseCombobox.SelectedItemInputElement.class, SelectedItemInputElementImpl.class);
    }

    @Override
    public final BasicElement getCheckedItem() {
        BaseCombobox.RootElement root = this.getRoot();
        return this.basic((BasicElement)root, this.checkedItem).build(BasicElement.class, BasePageElement.class);
    }

    final BaseCombobox.ClearSelectionButtonElement getClearSelectionButtonElement() {
        BaseCombobox.RootElement root = this.getRoot();
        return (BaseCombobox.ClearSelectionButtonElement)this.basic((BasicElement)root, this.clearSelectionButton).build(BaseCombobox.ClearSelectionButtonElement.class, ClearSelectionButtonElementImpl.class);
    }

    @Override
    public final Icon getTriggerIcon() {
        BaseCombobox.RootElement root = this.getRoot();
        return (Icon)this.custom((BasicElement)root, this.triggerIcon).build(Icon.class);
    }

    @Override
    public final List<BaseComboboxItem> getItems() {
        BaseCombobox.RootElement root = this.getRoot();
        return this.custom((BasicElement)root, this.items).buildList(BaseComboboxItem.class);
    }

    @Override
    public final BaseComboboxItem getItem(Integer indexStartingOne) {
        BaseCombobox.RootElement root = this.getRoot();
        return (BaseComboboxItem)this.custom((BasicElement)root, this.item.setParameters(new Object[]{indexStartingOne})).build(BaseComboboxItem.class);
    }

    @Override
    public final BaseComboboxItem getItemByValue(String text) {
        BaseCombobox.RootElement root = this.getRoot();
        return (BaseComboboxItem)this.custom((BasicElement)root, this.itemByValue).build(BaseComboboxItem.class, elm -> text.equals(elm.getItemValue()));
    }

    @Override
    public final BaseComboboxItem getItemByLabel(String text) {
        BaseCombobox.RootElement root = this.getRoot();
        return (BaseComboboxItem)this.custom((BasicElement)root, this.itemByLabel).build(BaseComboboxItem.class, elm -> text.equals(elm.getItemLabel()));
    }

    @Override
    public final String getInputAttribute(String attributeName) {
        BaseCombobox.TriggerInputElement triggerInput0 = this.getTriggerInput();
        String statement0 = triggerInput0.getAttribute(attributeName);
        return statement0;
    }

    @Override
    public final Boolean expand() {
        Boolean statement0 = (Boolean)this.waitFor(() -> {
            BaseCombobox.RootElement proot0 = this.getRoot();
            proot0.click();
            BasicElement pitemsWrapper1 = this.getItemsWrapperElement();
            Boolean pstatement1 = pitemsWrapper1.isVisible();
            return pstatement1;
        });
        return statement0;
    }

    @Override
    public final Boolean isOpen() {
        BaseCombobox.OpenedElement statement0 = this.getOpenedElement();
        Boolean matcher0 = statement0 != null;
        return matcher0;
    }

    @Override
    public final void clear() {
        BaseCombobox.TriggerInputElement triggerInput0 = this.getTriggerInput();
        triggerInput0.clear();
    }

    @Override
    public final void setTriggerText(String text) {
        BaseCombobox.TriggerInputElement triggerInput0 = this.getTriggerInput();
        triggerInput0.setText(text);
    }

    @Override
    public final String getTriggerText() {
        BaseCombobox.TriggerInputElement triggerInput0 = this.getTriggerInput();
        String statement0 = triggerInput0.getAttribute("data-value");
        return statement0;
    }

    @Override
    public final String getInputText() {
        BaseCombobox.InputElement input0 = this.getInputElement();
        String statement0 = input0.getValue();
        return statement0;
    }

    @Override
    public final Boolean isDropdownOpened() {
        BasicElement comboboxWrapper0 = this.getComboboxWrapperElement();
        String statement0 = comboboxWrapper0.getClassAttribute();
        Boolean matcher0 = statement0 != null && statement0.contains("slds-is-open");
        return matcher0;
    }

    @Override
    public final Boolean isDisabled() {
        BaseCombobox.TriggerInputElement triggerInput0 = this.getTriggerInput();
        String statement0 = triggerInput0.getClassAttribute();
        Boolean matcher0 = statement0 != null && statement0.contains("slds-is-disabled");
        return matcher0;
    }

    @Override
    public final Boolean isReadonly() {
        BaseCombobox.TriggerInputElement triggerInput0 = this.getTriggerInput();
        String statement0 = triggerInput0.getAttribute("aria-readonly");
        Boolean matcher0 = "true".equals(statement0);
        return matcher0;
    }

    @Override
    public final Boolean waitForItemsToLoad() {
        Boolean statement0 = (Boolean)this.waitFor(() -> {
            BaseCombobox.RootElement proot0 = this.getRoot();
            Boolean pstatement0 = proot0.containsElement((Locator)LocatorBy.byCss((String)"lightning-base-combobox-item"), true);
            return pstatement0;
        });
        return statement0;
    }

    @Override
    public final Boolean waitForItemByValue(String dataValue) {
        Boolean statement0 = (Boolean)this.waitFor(() -> {
            BaseCombobox.RootElement proot0 = this.getRoot();
            Boolean pstatement0 = proot0.containsElement((Locator)LocatorBy.byCss((String)String.format("lightning-base-combobox-item[data-value='%s']", dataValue)), true);
            return pstatement0;
        });
        return statement0;
    }

    @Override
    public final void expandForDisabledInput() {
        BaseCombobox.ExpandButtonElement expandButton0 = this.getExpandButtonElement();
        expandButton0.click();
        BasicElement itemsWrapper1 = this.getItemsWrapperElement();
        itemsWrapper1.waitForVisible();
    }

    @Override
    public final void pickItem(Integer indexStartingOne) {
        BaseComboboxItem statement0 = this.getItem(indexStartingOne);
        statement0.clickItem();
    }

    @Override
    public final void pickItemByLabel(String text) {
        BaseComboboxItem statement0 = this.getItemByLabel(text);
        statement0.clickItem();
    }

    @Override
    public final String getFocusedItemValue() {
        BasicElement focusedItem0 = this.getFocusedItemElement();
        if (focusedItem0 == null) {
            return null;
        }
        String statement0 = focusedItem0.getAttribute("data-value");
        return statement0;
    }

    @Override
    @Deprecated
    public final void setSelectedItemText(String text) {
        BaseCombobox.SelectedItemInputElement selectedItemInput0 = this.getSelectedItemInput();
        selectedItemInput0.setText(text);
    }

    @Override
    public final void clearSelection() {
        BaseCombobox.ClearSelectionButtonElement clearSelectionButton0 = this.getClearSelectionButtonElement();
        clearSelectionButton0.click();
    }

    @Override
    public final void selectItemByValue(String text) {
        BaseComboboxItem itemByValue0 = this.getItemByValue(text);
        itemByValue0.clickItem();
    }

    public static class ClearSelectionButtonElementImpl
    extends BasePageElement
    implements BaseCombobox.ClearSelectionButtonElement {
    }

    public static class SelectedItemInputElementImpl
    extends BasePageElement
    implements BaseCombobox.SelectedItemInputElement {
    }

    public static class TriggerInputElementImpl
    extends BasePageElement
    implements BaseCombobox.TriggerInputElement {
    }

    public static class ExpandButtonElementImpl
    extends BasePageElement
    implements BaseCombobox.ExpandButtonElement {
    }

    public static class OpenedElementImpl
    extends BasePageElement
    implements BaseCombobox.OpenedElement {
    }

    public static class InputElementImpl
    extends BasePageElement
    implements BaseCombobox.InputElement {
    }
}

