/*
 * Decompiled with CFR 0.152.
 */
package utam.lightning.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.lightning.pageobjects.BaseCombobox;
import utam.lightning.pageobjects.BaseComboboxItem;
import utam.lightning.pageobjects.Calendar;
import utam.lightning.pageobjects.Datetimepicker;
import utam.lightning.pageobjects.Input;

public class InputUtils {
    public static void selectDate(UtamUtilitiesContext context, String date) {
        Input inputPO = (Input)context.getPageObject();
        String[] parts = date.split("-");
        Calendar calendar = inputPO.getDatepicker().getCalendar();
        try {
            int expectedMonth;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date inDate = sdf.parse(date);
            calendar.getYearSelector().selectByText(parts[0]);
            int actualMonth = Integer.parseInt(calendar.getMonthText());
            if (actualMonth < expectedMonth) {
                for (expectedMonth = inDate.getMonth(); actualMonth != expectedMonth; --expectedMonth) {
                    calendar.getNextMonthButton().clickButton();
                }
            } else {
                while (actualMonth != expectedMonth) {
                    calendar.getPrevMonthButton().clickButton();
                    ++expectedMonth;
                }
            }
            calendar.clickDayByDate(date);
        }
        catch (ParseException e) {
            throw new RuntimeException("The date [ " + date + " ] was not set the following Exception was thrown during execution:", e);
        }
    }

    public static void selectTime(UtamUtilitiesContext context, String time) {
        Input inputPO = (Input)context.getPageObject();
        BaseCombobox base = null;
        Datetimepicker datetimepicker = inputPO.getDatetimepicker();
        base = datetimepicker != null && datetimepicker.isPresent() ? datetimepicker.getTimepicker().getTimeCombobox() : inputPO.getTimepicker().getTimeCombobox();
        BaseCombobox.RootElement input = base.getRoot();
        input.click();
        BaseComboboxItem options = base.getItems().stream().filter(item -> item.getItemByLabel(time) != null).findAny().orElse(null);
        if (options != null) {
            options.clickItem();
        } else {
            input.setText(time);
            input.blur();
        }
    }

    public static void setCheckboxState(UtamUtilitiesContext context, Boolean state) {
        Input inputPO = (Input)context.getPageObject();
        if (!state.toString().equals(inputPO.getCheckedState())) {
            inputPO.toggleCheckbox();
        }
    }
}

