/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.pageobjects.record.impl;

import utam.core.element.Actionable;
import utam.core.element.BasicElement;
import utam.core.element.Clickable;
import utam.core.element.Editable;
import utam.core.element.Locator;
import utam.core.element.Touchable;
import utam.core.framework.base.BaseRootPageObject;
import utam.core.framework.base.ElementLocation;
import utam.core.framework.base.ElementMarker;
import utam.core.framework.base.PageMarker;
import utam.core.framework.context.PlatformType;
import utam.core.framework.element.BasePageElement;
import utam.core.selenium.element.LocatorBy;
import utam.salesforceapp.pageobjects.record.AnalyticsBrowse;

@PageMarker.Find(uiautomator="resourceId(\"com.salesforce.chatter:id/nav_host_fragment\")")
@PageMarker.Switch(value=PlatformType.NATIVE)
public final class AnalyticsBrowseAndroidImpl
extends BaseRootPageObject
implements AnalyticsBrowse {
    @ElementMarker.Find(uiautomator="resourceId(\"com.salesforce.chatter:id/search_view\")")
    private ElementLocation searchInput;
    @ElementMarker.Find(accessid="%s")
    private ElementLocation analyticsTab;
    @ElementMarker.Find(uiautomator="resourceId(\"com.salesforce.chatter:id/text_view_label\").text(\"%s\")")
    private ElementLocation analyticsRecord;

    final RootElement getRoot() {
        return (RootElement)this.getProxy(this.getRootElement(), RootElement.class);
    }

    final AnalyticsTabElement getAnalyticsTabElement(String title) {
        RootElement root = this.getRoot();
        return (AnalyticsTabElement)this.basic((BasicElement)root, this.analyticsTab.setParameters(new Object[]{title})).build(AnalyticsTabElement.class, AnalyticsTabElementImpl.class);
    }

    final AnalyticsRecordElement getAnalyticsRecordElement(String title) {
        RootElement root = this.getRoot();
        return (AnalyticsRecordElement)this.basic((BasicElement)root, this.analyticsRecord.setParameters(new Object[]{title})).build(AnalyticsRecordElement.class, AnalyticsRecordElementImpl.class);
    }

    final SearchInputElement getSearchInputElement() {
        RootElement root = this.getRoot();
        return (SearchInputElement)this.basic((BasicElement)root, this.searchInput).build(SearchInputElement.class, SearchInputElementImpl.class);
    }

    @Override
    public final Boolean hasLensesTab() {
        RootElement root0 = this.getRoot();
        Boolean statement0 = root0.containsElement((Locator)LocatorBy.byAccessibilityId((String)"Lenses"));
        return statement0;
    }

    @Override
    public final Boolean hasDashboardsTab() {
        RootElement root0 = this.getRoot();
        Boolean statement0 = root0.containsElement((Locator)LocatorBy.byAccessibilityId((String)"Dashboards"));
        return statement0;
    }

    @Override
    public final void switchTabWithTitle(String title) {
        AnalyticsTabElement analyticsTab0 = this.getAnalyticsTabElement(title);
        analyticsTab0.click();
    }

    @Override
    public final Boolean hasAnalyticsRecordWithTitle(String title) {
        Boolean statement0 = (Boolean)this.waitFor(() -> {
            RootElement proot0 = this.getRoot();
            Boolean pstatement0 = proot0.containsElement((Locator)LocatorBy.byUiAutomator((String)String.format("resourceId(\"com.salesforce.chatter:id/text_view_label\").text(\"%s\")", title)));
            return pstatement0;
        });
        return statement0;
    }

    @Override
    public final void clickAnalyticsRecordWithTitle(String title) {
        AnalyticsRecordElement analyticsRecord0 = this.getAnalyticsRecordElement(title);
        analyticsRecord0.click();
    }

    @Override
    public final void typeToSearch(String itemToSearch) {
        SearchInputElement searchInput0 = this.getSearchInputElement();
        searchInput0.clearAndType(itemToSearch);
    }

    @Override
    public final void clearSearch() {
        SearchInputElement searchInput0 = this.getSearchInputElement();
        searchInput0.clear();
    }

    @Override
    public final void pullToRefresh() {
        RootElement root0 = this.getRoot();
        root0.flick(0, 400);
    }

    public static class SearchInputElementImpl
    extends BasePageElement
    implements SearchInputElement {
    }

    public static class AnalyticsRecordElementImpl
    extends BasePageElement
    implements AnalyticsRecordElement {
    }

    public static class AnalyticsTabElementImpl
    extends BasePageElement
    implements AnalyticsTabElement {
    }

    static interface SearchInputElement
    extends Editable,
    Clickable {
    }

    static interface AnalyticsRecordElement
    extends Clickable {
    }

    static interface AnalyticsTabElement
    extends Clickable {
    }

    static interface RootElement
    extends Actionable,
    Touchable {
    }
}

