/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.record;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.record.ActionBarOverflow;

public class ActionBarOverflowAndroidUtils
extends ImperativeProvider<ActionBarOverflow> {
    private static final int MAX_NUM_OF_SCROLL = 25;

    ActionBarOverflowAndroidUtils(ActionBarOverflow instance) {
        super((PageObject)instance);
    }

    ActionBarOverflowAndroidUtils() {
    }

    public static void clickAction(UtamUtilitiesContext context, String label) {
        Optional<ActionBarOverflow.GetVisibleActionsElement> matchedItems = ActionBarOverflowAndroidUtils.scrollActionIntoView(context, label);
        if (matchedItems.isEmpty()) {
            throw new UtamError("Unable to find action with label '" + label + "'");
        }
        matchedItems.get().click();
    }

    private static Optional<ActionBarOverflow.GetVisibleActionsElement> scrollActionIntoView(UtamUtilitiesContext context, String label) {
        ActionBarOverflow pageObject = (ActionBarOverflow)context.getPageObject();
        List<ActionBarOverflow.GetVisibleActionsElement> items = pageObject.getVisibleActions();
        Optional<ActionBarOverflow.GetVisibleActionsElement> targetItem = ActionBarOverflowAndroidUtils.getActionWithLabel(items, label);
        int scrollCount = 0;
        if (targetItem.isEmpty()) {
            boolean isFlicked = false;
            do {
                int numOfItem;
                if ((numOfItem = items.size()) <= 1) continue;
                isFlicked = ActionBarOverflowAndroidUtils.flickList(pageObject, items);
                targetItem = ActionBarOverflowAndroidUtils.getActionWithLabel(items, label);
            } while (isFlicked && targetItem.isEmpty() && scrollCount++ < 25);
            if (scrollCount > 25) {
                throw new UtamError("Failed to scroll element into view due to maximum scroll count reached");
            }
        }
        return targetItem;
    }

    public static List<String> getLabels(UtamUtilitiesContext context) {
        HashSet visibleLabels = new HashSet();
        ActionBarOverflow pageObject = (ActionBarOverflow)context.getPageObject();
        List<ActionBarOverflow.GetVisibleActionsElement> items = pageObject.getVisibleActions();
        boolean isFlicked = false;
        int scrollCount = 0;
        do {
            items = pageObject.getVisibleActions();
            items.stream().forEach(item -> visibleLabels.add(item.getText()));
            int numOfItem = items.size();
            if (numOfItem <= 1) continue;
            isFlicked = ActionBarOverflowAndroidUtils.flickList(pageObject, items);
        } while (isFlicked && scrollCount++ < 25);
        return new ArrayList<String>(visibleLabels);
    }

    private static Optional<ActionBarOverflow.GetVisibleActionsElement> getActionWithLabel(List<ActionBarOverflow.GetVisibleActionsElement> items, String itemLabel) {
        return items.stream().filter(item -> item.getText().equalsIgnoreCase(itemLabel)).findFirst();
    }

    private static boolean flickList(ActionBarOverflow pageObject, List<ActionBarOverflow.GetVisibleActionsElement> items) {
        String lastAfterFlick;
        int numOfItem = items.size();
        String lastBeforeFlick = items.get(numOfItem - 1).getText();
        pageObject.getRoot().flick(0, -200);
        items = pageObject.getVisibleActions();
        numOfItem = items.size();
        return numOfItem > 1 && !(lastAfterFlick = items.get(numOfItem - 1).getText()).equals(lastBeforeFlick);
    }
}

