/*
 * Decompiled with CFR 0.152.
 */
package utam.lightning.pageobjects.impl;

import utam.core.element.BasicElement;
import utam.core.framework.base.BasePageObject;
import utam.core.framework.base.ElementLocation;
import utam.core.framework.base.ElementMarker;
import utam.core.framework.element.BasePageElement;
import utam.lightning.pageobjects.ButtonIcon;
import utam.lightning.pageobjects.Calendar;
import utam.lightning.pageobjects.Select;

public final class CalendarImpl
extends BasePageObject
implements Calendar {
    @ElementMarker.Find(css="lightning-select", expand=true)
    private ElementLocation yearSelector;
    @ElementMarker.Find(css=".slds-datepicker__filter_month", expand=true)
    private ElementLocation month;
    @ElementMarker.Find(css="td[aria-current='date']", expand=true)
    private ElementLocation todaysDate;
    @ElementMarker.Find(css=".slds-align-middle:nth-of-type(1) lightning-button-icon")
    private ElementLocation prevMonthButton;
    @ElementMarker.Find(css="table", expand=true)
    private ElementLocation days;
    @ElementMarker.Find(css="tr td[data-value='%s']")
    private ElementLocation dayByDate;
    @ElementMarker.Find(css="h2[id*='month-title']")
    private ElementLocation currentMonth;
    @ElementMarker.Find(css="tr:nth-of-type(%d) td:nth-of-type(%d)")
    private ElementLocation dayIndexedCell;
    @ElementMarker.Find(css=".slds-align-middle:nth-of-type(2) lightning-button-icon")
    private ElementLocation nextMonthButton;
    @ElementMarker.Find(css="button[name='today']", expand=true)
    private ElementLocation todayButton;

    @Override
    public final BasicElement getRoot() {
        return this.getRootElement();
    }

    final BasicElement getMonthElement() {
        BasicElement root = this.getRoot();
        return this.basic(root, this.month).build(BasicElement.class, BasePageElement.class);
    }

    final BasicElement getCurrentMonthElement() {
        BasicElement month = this.getMonthElement();
        return this.basic(month, this.currentMonth).build(BasicElement.class, BasePageElement.class);
    }

    @Override
    public final Calendar.TodaysDateElement getTodaysDate() {
        BasicElement root = this.getRoot();
        return (Calendar.TodaysDateElement)this.basic(root, this.todaysDate).build(Calendar.TodaysDateElement.class, TodaysDateElementImpl.class);
    }

    final BasicElement getDaysElement() {
        BasicElement root = this.getRoot();
        return this.basic(root, this.days).build(BasicElement.class, BasePageElement.class);
    }

    final Calendar.DayIndexedCellElement getDayIndexedCellElement(Integer row, Integer column) {
        BasicElement days = this.getDaysElement();
        return (Calendar.DayIndexedCellElement)this.basic(days, this.dayIndexedCell.setParameters(new Object[]{row, column})).build(Calendar.DayIndexedCellElement.class, DayIndexedCellElementImpl.class);
    }

    final Calendar.DayByDateElement getDayByDateElement(String date) {
        BasicElement days = this.getDaysElement();
        return (Calendar.DayByDateElement)this.basic(days, this.dayByDate.setParameters(new Object[]{date})).build(Calendar.DayByDateElement.class, DayByDateElementImpl.class);
    }

    final Calendar.TodayButtonElement getTodayButtonElement() {
        BasicElement root = this.getRoot();
        return (Calendar.TodayButtonElement)this.basic(root, this.todayButton).build(Calendar.TodayButtonElement.class, TodayButtonElementImpl.class);
    }

    @Override
    public final ButtonIcon getPrevMonthButton() {
        BasicElement month = this.getMonthElement();
        return (ButtonIcon)this.custom(month, this.prevMonthButton).build(ButtonIcon.class);
    }

    @Override
    public final ButtonIcon getNextMonthButton() {
        BasicElement month = this.getMonthElement();
        return (ButtonIcon)this.custom(month, this.nextMonthButton).build(ButtonIcon.class);
    }

    @Override
    public final Select getYearSelector() {
        BasicElement root = this.getRoot();
        return (Select)this.custom(root, this.yearSelector).build(Select.class);
    }

    @Override
    public final String getMonthText() {
        BasicElement currentMonth0 = this.getCurrentMonthElement();
        String statement0 = currentMonth0.getText();
        return statement0;
    }

    @Override
    public final Boolean todayDateHasFocus() {
        Calendar.TodaysDateElement todaysDate0 = this.getTodaysDate();
        Boolean statement0 = todaysDate0.isFocused();
        return statement0;
    }

    @Override
    public final void clickDayByRowAndColumn(Integer row, Integer column) {
        Calendar.DayIndexedCellElement dayIndexedCell0 = this.getDayIndexedCellElement(row, column);
        dayIndexedCell0.click();
    }

    @Override
    public final void clickDayByDate(String date) {
        Calendar.DayByDateElement dayByDate0 = this.getDayByDateElement(date);
        dayByDate0.click();
    }

    @Override
    public final String getDayText(Integer row, Integer column) {
        Calendar.DayIndexedCellElement dayIndexedCell0 = this.getDayIndexedCellElement(row, column);
        String statement0 = dayIndexedCell0.getText();
        return statement0;
    }

    @Override
    public final void clickToday() {
        Calendar.TodayButtonElement todayButton0 = this.getTodayButtonElement();
        todayButton0.click();
    }

    public static class TodayButtonElementImpl
    extends BasePageElement
    implements Calendar.TodayButtonElement {
    }

    public static class DayByDateElementImpl
    extends BasePageElement
    implements Calendar.DayByDateElement {
    }

    public static class DayIndexedCellElementImpl
    extends BasePageElement
    implements Calendar.DayIndexedCellElement {
    }

    public static class TodaysDateElementImpl
    extends BasePageElement
    implements Calendar.TodaysDateElement {
    }
}

