/*
 * Decompiled with CFR 0.152.
 */
package utam.lightning.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utam.core.element.BasicElement;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.lightning.pageobjects.Datatable;
import utam.lightning.pageobjects.FormattedNumber;
import utam.lightning.pageobjects.FormattedText;
import utam.lightning.pageobjects.FormattedUrl;

public class DatatableUtils {
    public static String getCellValueByIndex(UtamUtilitiesContext context, int rowIndex, int columnIndex) {
        Datatable datatable = (Datatable)context.getPageObject();
        FormattedText formattedText = datatable.getFormattedTextByColumnIndex(rowIndex, columnIndex);
        if (formattedText != null) {
            return formattedText.getInnerText();
        }
        FormattedUrl formattedUrl = datatable.getFormattedUrlByColumnIndex(rowIndex, columnIndex);
        if (formattedUrl != null) {
            return formattedUrl.getUrl();
        }
        FormattedNumber formattedNumber = datatable.getFormattedNumberByColumnIndex(rowIndex, columnIndex);
        if (formattedNumber != null) {
            return formattedNumber.getInnerText();
        }
        return null;
    }

    public static String getCellValueByLabel(UtamUtilitiesContext context, int rowIndex, String fieldLabel) {
        Datatable datatable = (Datatable)context.getPageObject();
        if (datatable.getCellByLabel(rowIndex, fieldLabel) == null) {
            return null;
        }
        FormattedText formattedText = datatable.getFormattedTextByLabel(rowIndex, fieldLabel);
        if (formattedText != null) {
            return formattedText.getInnerText();
        }
        FormattedUrl formattedUrl = datatable.getFormattedUrlByLabel(rowIndex, fieldLabel);
        if (formattedUrl != null) {
            return formattedUrl.getUrl();
        }
        FormattedNumber formattedNumber = datatable.getFormattedNumberByLabel(rowIndex, fieldLabel);
        if (formattedNumber != null) {
            return formattedNumber.getInnerText();
        }
        return null;
    }

    public static void scrollToLastRow(UtamUtilitiesContext context) {
        Datatable datatable = (Datatable)context.getPageObject();
        int numRows = datatable.getNumRows();
        int lastRowNumber = 0;
        Datatable.RowElement lastRow = null;
        while (lastRowNumber < numRows) {
            Datatable.LastRenderedRowElement lastRenderedRow = datatable.getLastRenderedRow();
            lastRowNumber = DatatableUtils.getAttributeAsNumber(context, (BasicElement)lastRenderedRow, "data-row-number");
            lastRow = datatable.getRow(lastRowNumber);
            lastRow.scrollToCenter();
        }
        lastRow = datatable.getRow(numRows);
        lastRow.moveTo();
    }

    public static int getAttributeAsNumber(UtamUtilitiesContext context, BasicElement element, String attr) {
        String attributeAsString = element.getAttribute(attr);
        return Integer.parseInt(attributeAsString);
    }

    public static String getTableWidth(UtamUtilitiesContext context, BasicElement scrollYContainer) {
        String containerStyle = scrollYContainer.getAttribute("style");
        Pattern pattern = Pattern.compile("width:.*?px;");
        Matcher matcher = pattern.matcher(containerStyle);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }
}

