/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.mobilehome;

import java.util.List;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.mobilehome.HomeCardList;

public class HomeCardListUtils
extends ImperativeProvider<HomeCardList> {
    private static final int FLICK_OFFSET = 400;
    private static final int MAX_NUM_OF_FLICK = 25;

    HomeCardListUtils(HomeCardList instance) {
        super((PageObject)instance);
    }

    HomeCardListUtils() {
    }

    public static void clickCardBadgeWithLabel(UtamUtilitiesContext context, String badgeLabel) {
        HomeCardList.GetVisibleCardBadgeWithLabelElement targetBadge = HomeCardListUtils.flickCardBadgeIntoView(context, badgeLabel);
        if (targetBadge == null) {
            throw new UtamError("Unable to find badge with label '" + badgeLabel + "'");
        }
        targetBadge.click();
    }

    public static String flickToElementToGetText(UtamUtilitiesContext context, String badgeLabel) {
        HomeCardList.GetVisibleCardBadgeWithLabelElement targetBadge = HomeCardListUtils.flickCardBadgeIntoView(context, badgeLabel);
        if (targetBadge != null) {
            return targetBadge.getText();
        }
        return null;
    }

    public static boolean hasCardWithBadgeLabel(UtamUtilitiesContext context, String badgeLabel) {
        HomeCardList.GetVisibleCardBadgeWithLabelElement targetBadge = HomeCardListUtils.flickCardBadgeIntoView(context, badgeLabel);
        return targetBadge != null;
    }

    private static HomeCardList.GetVisibleCardBadgeWithLabelElement flickCardBadgeIntoView(UtamUtilitiesContext context, String badgeLabel) {
        HomeCardList pageObject = (HomeCardList)context.getPageObject();
        HomeCardList.GetVisibleCardBadgeWithLabelElement targetBadge = pageObject.getVisibleCardBadgeWithLabel(badgeLabel);
        if (targetBadge != null) {
            return targetBadge;
        }
        targetBadge = HomeCardListUtils.flickCardBadgeIntoViewWithOffset(pageObject, badgeLabel, 400);
        if (targetBadge != null) {
            return targetBadge;
        }
        targetBadge = HomeCardListUtils.flickCardBadgeIntoViewWithOffset(pageObject, badgeLabel, -400);
        return targetBadge;
    }

    private static HomeCardList.GetVisibleCardBadgeWithLabelElement flickCardBadgeIntoViewWithOffset(HomeCardList pageObject, String badgeLabel, int flickOffset) {
        int flickCount = 0;
        int sameCount = 0;
        do {
            boolean isFlicked;
            List<HomeCardList.GetVisibleCardBadgesElement> onScreenItems = pageObject.getVisibleCardBadges();
            String firstBeforeFlick = onScreenItems.get(0).getText();
            String lastBeforeFlick = onScreenItems.get(onScreenItems.size() - 1).getText();
            pageObject.getRoot().flick(0, flickOffset);
            HomeCardList.GetVisibleCardBadgeWithLabelElement targetBadge = pageObject.getVisibleCardBadgeWithLabel(badgeLabel);
            if (targetBadge != null) {
                return targetBadge;
            }
            onScreenItems = pageObject.getVisibleCardBadges();
            String firstAfterFlick = onScreenItems.get(0).getText();
            String lastAfterFlick = onScreenItems.get(onScreenItems.size() - 1).getText();
            boolean bl = isFlicked = !lastAfterFlick.equals(lastBeforeFlick) && !firstAfterFlick.equals(firstBeforeFlick);
            if (isFlicked) {
                sameCount = 0;
                continue;
            }
            ++sameCount;
        } while (sameCount < 2 && flickCount++ < 25);
        if (25 < flickCount) {
            throw new UtamError("Failed to flick element into view due to maximum flick count reached");
        }
        return null;
    }
}

