/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.navigation;

import java.util.List;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.navigation.AppItemsList;

public class AppItemiOSUtils
extends ImperativeProvider<AppItemsList> {
    private static final int FLICK_UP_OFFSET = -400;
    private static final int MAX_NUM_OF_FLICK = 25;

    AppItemiOSUtils(AppItemsList instance) {
        super((PageObject)instance);
    }

    AppItemiOSUtils() {
    }

    public static void clickAppItem(UtamUtilitiesContext context, String appTitle) {
        AppItemsList.GetVisibleAppItemByTitleElement targetApp = AppItemiOSUtils.flickAppItemIntoView(context, appTitle);
        if (targetApp == null) {
            throw new UtamError("Unable to find app item with title '" + appTitle + "'");
        }
        targetApp.click();
    }

    private static AppItemsList.GetVisibleAppItemByTitleElement flickAppItemIntoView(UtamUtilitiesContext context, String appTitle) {
        boolean isFlicked;
        AppItemsList pageObject = (AppItemsList)context.getPageObject();
        AppItemsList.GetVisibleAppItemByTitleElement targetApp = pageObject.getVisibleAppItemByTitle(appTitle);
        if (targetApp != null) {
            return targetApp;
        }
        int flickCount = 0;
        do {
            List<AppItemsList.GetVisibleAppItemsElement> onScreenApps = pageObject.getVisibleAppItems();
            String lastBeforeFlick = onScreenApps.get(onScreenApps.size() - 1).getText();
            pageObject.getRoot().flick(0, -400);
            targetApp = pageObject.getVisibleAppItemByTitle(appTitle);
            if (targetApp != null) {
                return targetApp;
            }
            onScreenApps = pageObject.getVisibleAppItems();
            String lastAfterFlick = onScreenApps.get(onScreenApps.size() - 1).getText();
            boolean bl = isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
        } while (isFlicked && flickCount++ < 25);
        if (25 < flickCount) {
            throw new UtamError("Failed to flick element into view due to maximum flick count reached");
        }
        return null;
    }
}

