/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.navigation;

import java.util.List;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.navigation.NavItemsList;

public class NavItemsListiOSUtils
extends ImperativeProvider<NavItemsList> {
    private static final int FLICK_UP_OFFSET = -400;
    private static final int MAX_NUM_OF_FLICK = 25;

    NavItemsListiOSUtils(NavItemsList instance) {
        super((PageObject)instance);
    }

    NavItemsListiOSUtils() {
    }

    public static void clickNavItem(UtamUtilitiesContext context, String itemLabel) {
        NavItemsList.GetVisibleNavItemWithLabelElement targetItem = NavItemsListiOSUtils.flickNavItemIntoView(context, itemLabel);
        if (targetItem == null) {
            throw new UtamError("Unable to find nav item with label '" + itemLabel + "'");
        }
        targetItem.click();
    }

    private static NavItemsList.GetVisibleNavItemWithLabelElement flickNavItemIntoView(UtamUtilitiesContext context, String itemLabel) {
        boolean isFlicked;
        NavItemsList pageObject = (NavItemsList)context.getPageObject();
        NavItemsList.GetVisibleNavItemWithLabelElement targetItem = pageObject.getVisibleNavItemWithLabel(itemLabel);
        if (targetItem != null) {
            return targetItem;
        }
        int flickCount = 0;
        do {
            List<NavItemsList.GetVisibleNavItemsElement> onScreenItems = pageObject.getVisibleNavItems();
            String lastBeforeFlick = onScreenItems.get(onScreenItems.size() - 1).getText();
            pageObject.getRoot().flick(0, -400);
            targetItem = pageObject.getVisibleNavItemWithLabel(itemLabel);
            if (targetItem != null) {
                return targetItem;
            }
            onScreenItems = pageObject.getVisibleNavItems();
            String lastAfterFlick = onScreenItems.get(onScreenItems.size() - 1).getText();
            boolean bl = isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
        } while (isFlicked && flickCount++ < 25);
        if (25 < flickCount) {
            throw new UtamError("Failed to flick element into view due to maximum flick count reached");
        }
        return null;
    }
}

