/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.record;

import java.util.List;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.record.ActionBarOverflow;

public class ActionBarOverflowUtils
extends ImperativeProvider<ActionBarOverflow> {
    private static final int FLICK_UP_OFFSET = -300;
    private static final int MAX_NUM_OF_FLICK = 25;

    ActionBarOverflowUtils(ActionBarOverflow instance) {
        super((PageObject)instance);
    }

    ActionBarOverflowUtils() {
    }

    public static void clickAction(UtamUtilitiesContext context, String actionLabel) {
        ActionBarOverflow.GetActionWithLabelElement targetAction = ActionBarOverflowUtils.flickActionIntoView(context, actionLabel);
        if (targetAction == null) {
            throw new UtamError("Unable to find action with label '" + actionLabel + "'");
        }
        targetAction.click();
    }

    private static ActionBarOverflow.GetActionWithLabelElement flickActionIntoView(UtamUtilitiesContext context, String actionLabel) {
        boolean isFlicked;
        ActionBarOverflow pageObject = (ActionBarOverflow)context.getPageObject();
        ActionBarOverflow.GetActionWithLabelElement targetAction = pageObject.getActionWithLabel(actionLabel);
        if (targetAction != null) {
            return targetAction;
        }
        int flickCount = 0;
        do {
            List<ActionBarOverflow.GetVisibleActionsElement> onScreenActions = pageObject.getVisibleActions();
            String lastBeforeFlick = onScreenActions.get(onScreenActions.size() - 1).getText();
            pageObject.getRoot().flick(0, -300);
            targetAction = pageObject.getActionWithLabel(actionLabel);
            if (targetAction != null) {
                return targetAction;
            }
            onScreenActions = pageObject.getVisibleActions();
            String lastAfterFlick = onScreenActions.get(onScreenActions.size() - 1).getText();
            boolean bl = isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
        } while (isFlicked && flickCount++ < 25);
        if (25 < flickCount) {
            throw new UtamError("Failed to flick element into view due to maximum flick count reached");
        }
        return null;
    }
}

