/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.record;

import java.util.List;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.record.FavoriteList;

public class FavoriteListiOSUtils
extends ImperativeProvider<FavoriteList> {
    private static final int FLICK_UP_OFFSET = -400;
    private static final int MAX_NUM_OF_FLICK = 25;

    FavoriteListiOSUtils(FavoriteList instance) {
        super((PageObject)instance);
    }

    FavoriteListiOSUtils() {
    }

    public static void clickRecord(UtamUtilitiesContext context, String title) {
        FavoriteList.GetVisibleFavoriteRecordWithTitleElement targetRecord = FavoriteListiOSUtils.flickRecordIntoView(context, title);
        if (targetRecord == null) {
            throw new UtamError("Unable to find record with title '" + title + "'");
        }
        targetRecord.click();
    }

    private static FavoriteList.GetVisibleFavoriteRecordWithTitleElement flickRecordIntoView(UtamUtilitiesContext context, String title) {
        boolean isFlicked;
        FavoriteList pageObject = (FavoriteList)context.getPageObject();
        FavoriteList.GetVisibleFavoriteRecordWithTitleElement targetRecord = pageObject.getVisibleFavoriteRecordWithTitle(title);
        if (targetRecord != null) {
            return targetRecord;
        }
        int flickCount = 0;
        do {
            List<FavoriteList.GetVisibleFavoriteRecordsElement> onScreenRecords = pageObject.getVisibleFavoriteRecords();
            String lastBeforeFlick = onScreenRecords.get(onScreenRecords.size() - 1).getText();
            pageObject.getRoot().flick(0, -400);
            targetRecord = pageObject.getVisibleFavoriteRecordWithTitle(title);
            if (targetRecord != null) {
                return targetRecord;
            }
            onScreenRecords = pageObject.getVisibleFavoriteRecords();
            String lastAfterFlick = onScreenRecords.get(onScreenRecords.size() - 1).getText();
            boolean bl = isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
        } while (isFlicked && flickCount++ < 25);
        if (25 < flickCount) {
            throw new UtamError("Failed to flick element into view due to maximum flick count reached");
        }
        return null;
    }
}

