/*
 * Decompiled with CFR 0.152.
 */
package utam.salesforceapp.utils.record;

import java.util.List;
import utam.core.framework.base.ImperativeProvider;
import utam.core.framework.base.PageObject;
import utam.core.framework.base.UtamUtilitiesContext;
import utam.core.framework.consumer.UtamError;
import utam.salesforceapp.pageobjects.record.SearchResult;

public class SearchResultiOSUtils
extends ImperativeProvider<SearchResult> {
    private static final int FLICK_UP_OFFSET = -400;
    private static final int MAX_NUM_OF_FLICK = 25;

    SearchResultiOSUtils(SearchResult instance) {
        super((PageObject)instance);
    }

    SearchResultiOSUtils() {
    }

    public static boolean hasRecord(UtamUtilitiesContext context, String title) {
        return SearchResultiOSUtils.flickRecordIntoView(context, title) != null;
    }

    public static void clickRecord(UtamUtilitiesContext context, String title) {
        SearchResult.GetVisibleRecordWithTitleElement targetRecord = SearchResultiOSUtils.flickRecordIntoView(context, title);
        if (targetRecord == null) {
            throw new UtamError("Unable to find record with title '" + title + "'");
        }
        targetRecord.click();
    }

    private static SearchResult.GetVisibleRecordWithTitleElement flickRecordIntoView(UtamUtilitiesContext context, String title) {
        boolean isFlicked;
        SearchResult pageObject = (SearchResult)context.getPageObject();
        SearchResult.GetVisibleRecordWithTitleElement targetRecord = pageObject.getVisibleRecordWithTitle(title);
        if (targetRecord != null) {
            return targetRecord;
        }
        int flickCount = 0;
        do {
            List<SearchResult.GetVisibleRecordCardsElement> onScreenRecords = pageObject.getVisibleRecordCards();
            String lastBeforeFlick = onScreenRecords.get(onScreenRecords.size() - 1).getText();
            pageObject.getRoot().flick(0, -400);
            targetRecord = pageObject.getVisibleRecordWithTitle(title);
            if (targetRecord != null) {
                return targetRecord;
            }
            onScreenRecords = pageObject.getVisibleRecordCards();
            String lastAfterFlick = onScreenRecords.get(onScreenRecords.size() - 1).getText();
            boolean bl = isFlicked = !lastAfterFlick.equals(lastBeforeFlick);
        } while (isFlicked && flickCount++ < 25);
        if (25 < flickCount) {
            throw new UtamError("Failed to flick element into view due to maximum flick count reached");
        }
        return null;
    }
}

