/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.plugin.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfFiles
implements Enumeration<InputStream> {
    private Log log;
    private List<File> files;
    private int current = 0;

    public ListOfFiles(Log log, List<File> files) {
        this.log = log;
        this.files = files;
    }

    @Override
    public boolean hasMoreElements() {
        return this.current < this.files.size();
    }

    @Override
    public InputStream nextElement() {
        FileInputStream is = null;
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more files.");
        }
        try {
            File nextElement = this.files.get(this.current);
            ++this.current;
            is = new FileInputStream(nextElement);
        }
        catch (FileNotFoundException e) {
            this.log.error((CharSequence)("The file [" + this.files.get(this.current).getName() + "] was not found."), (Throwable)e);
        }
        return is;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (File file : this.files) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(file.getName());
        }
        return stringBuilder.append("]").toString();
    }

    public int size() {
        return this.files.size();
    }
}

