/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.plugin.minify;

import com.samaxes.maven.plugin.minify.ProcessCSSFilesTask;
import com.samaxes.maven.plugin.minify.ProcessJSFilesTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class MinifyMojo
extends AbstractMojo {
    private String webappSourceDir;
    private String webappTargetDir;
    private String cssSourceDir;
    private String jsSourceDir;
    private List<String> cssSourceFiles = new ArrayList<String>();
    private List<String> jsSourceFiles = new ArrayList<String>();
    private String cssSourceIncludes;
    private String cssSourceExcludes;
    private String jsSourceIncludes;
    private String jsSourceExcludes;
    private String cssFinalFile;
    private String jsFinalFile;
    private int linebreak;
    private boolean nomunge;
    private boolean verbose;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;
    private int bufferSize;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Future<?> processCSSFilesTask = executor.submit(new ProcessCSSFilesTask(this.getLog(), this.bufferSize, this.webappSourceDir, this.webappTargetDir, this.cssSourceDir, this.cssSourceFiles, this.cssSourceIncludes, this.cssSourceExcludes, this.cssFinalFile, this.linebreak));
        Future<?> processJSFilesTask = executor.submit(new ProcessJSFilesTask(this.getLog(), this.bufferSize, this.webappSourceDir, this.webappTargetDir, this.jsSourceDir, this.jsSourceFiles, this.jsSourceIncludes, this.jsSourceExcludes, this.jsFinalFile, this.linebreak, !this.nomunge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations));
        try {
            if (processCSSFilesTask != null) {
                processCSSFilesTask.get();
            }
            if (processJSFilesTask != null) {
                processJSFilesTask.get();
            }
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }
}

