/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.plugin.minify;

import com.samaxes.maven.plugin.common.ListOfFiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessFilesTask
implements Runnable {
    protected static final String SUFFIX = ".min";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected Log log;
    protected File targetDir;
    protected File finalFile;
    protected int linebreak;
    private Integer bufferSize;
    private File sourceDir;
    private List<File> files = new ArrayList<File>();

    public ProcessFilesTask(Log log, Integer bufferSize, String webappSourceDir, String webappTargetDir, String filesDir, List<String> filenames, String sourceIncludes, String sourceExcludes, String finalFilename, int linebreak) {
        this.log = log;
        this.bufferSize = bufferSize;
        this.linebreak = linebreak;
        this.sourceDir = new File(webappSourceDir.concat(File.separator).concat(filesDir));
        this.targetDir = new File(webappTargetDir.concat(File.separator).concat(filesDir));
        ArrayList includedFiles = sourceIncludes != null && !"".equals(sourceIncludes) ? this.getFilesToInclude(this.sourceDir, sourceIncludes, sourceExcludes) : new ArrayList();
        for (String filename : filenames) {
            File sourceFile = new File(this.sourceDir, filename);
            log.debug((CharSequence)("Adding source file [" + sourceFile.getName() + "]"));
            this.files.add(sourceFile);
        }
        for (File includedFile : includedFiles) {
            if (this.files.contains(includedFile)) continue;
            log.debug((CharSequence)("Adding source file [" + includedFile.getName() + "]"));
            this.files.add(includedFile);
        }
        if (this.targetDir.exists() || this.targetDir.mkdirs()) {
            this.finalFile = new File(this.targetDir, finalFilename);
        }
    }

    @Override
    public void run() {
        this.mergeFiles();
        this.minify();
    }

    private String[] getIncludes(String include) {
        return StringUtils.split((String)StringUtils.defaultString((Object)include), (String)",");
    }

    private String[] getExcludes(String exclude) {
        return StringUtils.isNotEmpty((String)exclude) ? StringUtils.split((String)exclude, (String)",") : EMPTY_STRING_ARRAY;
    }

    private List<File> getFilesToInclude(File baseDir, String include, String exclude) {
        String[] includedFilenames;
        DirectoryScanner scanner = new DirectoryScanner();
        ArrayList<File> includedFiles = new ArrayList<File>();
        String[] includes = this.getIncludes(include);
        String[] excludes = this.getExcludes(exclude);
        scanner.setBasedir(baseDir);
        if (excludes != null) {
            scanner.setExcludes(excludes);
        }
        scanner.addDefaultExcludes();
        if (includes != null && includes.length > 0) {
            scanner.setIncludes(includes);
        }
        scanner.scan();
        for (String includedFilename : includedFilenames = scanner.getIncludedFiles()) {
            includedFiles.add(new File(baseDir, includedFilename));
        }
        return includedFiles;
    }

    private void mergeFiles() {
        ListOfFiles listOfFiles = new ListOfFiles(this.log, this.files);
        this.log.info((CharSequence)("Merging files " + listOfFiles.toString()));
        if (listOfFiles.size() > 0) {
            try {
                int length;
                SequenceInputStream sequence = new SequenceInputStream(listOfFiles);
                FileOutputStream out = new FileOutputStream(this.finalFile);
                byte[] buffer = new byte[this.bufferSize.intValue()];
                while ((length = sequence.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
                sequence.close();
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                this.log.error((CharSequence)"An error has occurred while concatenating files.", (Throwable)e);
            }
        }
    }

    abstract void minify();
}

