/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.plugin.minify;

import com.samaxes.maven.plugin.common.JavaScriptErrorReporter;
import com.samaxes.maven.plugin.minify.ProcessFilesTask;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessJSFilesTask
extends ProcessFilesTask {
    private boolean munge;
    private boolean verbose;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;

    public ProcessJSFilesTask(Log log, Integer bufferSize, String webappSourceDir, String webappTargetDir, String filesDir, List<String> filenames, String sourceIncludes, String sourceExcludes, String finalFilename, int linebreak, boolean munge, boolean verbose, boolean preserveAllSemiColons, boolean disableOptimizations) {
        super(log, bufferSize, webappSourceDir, webappTargetDir, filesDir, filenames, sourceIncludes, sourceExcludes, finalFilename, linebreak);
        this.munge = munge;
        this.verbose = verbose;
        this.preserveAllSemiColons = preserveAllSemiColons;
        this.disableOptimizations = disableOptimizations;
    }

    @Override
    protected void minify() {
        if (this.finalFile.exists()) {
            String name = this.finalFile.getName();
            String extension = name.substring(name.lastIndexOf(46));
            File destFile = new File(this.targetDir, name.replace(extension, ".min".concat(extension)));
            this.log.info((CharSequence)("Minifying file [" + name + "]"));
            try {
                FileReader reader = new FileReader(this.finalFile);
                FileWriter writer = new FileWriter(destFile);
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)reader, (ErrorReporter)new JavaScriptErrorReporter(this.log, name));
                compressor.compress((Writer)writer, this.linebreak, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
                ((Reader)reader).close();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                this.log.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }
}

