/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.google.common.base.Strings;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import com.samaxes.maven.minify.common.ClosureConfig;
import com.samaxes.maven.minify.common.YuiConfig;
import com.samaxes.maven.minify.plugin.ProcessCSSFilesTask;
import com.samaxes.maven.minify.plugin.ProcessFilesTask;
import com.samaxes.maven.minify.plugin.ProcessJSFilesTask;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="minify", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class MinifyMojo
extends AbstractMojo {
    @Deprecated
    @Parameter(property="debug")
    private Boolean debug;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="bufferSize", defaultValue="4096")
    private int bufferSize;
    @Parameter(property="charset", defaultValue="${project.build.sourceEncoding}")
    private String charset;
    @Parameter(property="suffix", defaultValue="min")
    private String suffix;
    @Parameter(property="nosuffix", defaultValue="false")
    private boolean nosuffix;
    @Parameter(property="skipMerge", defaultValue="false")
    private boolean skipMerge;
    @Parameter(property="skipMinify", defaultValue="false")
    private boolean skipMinify;
    @Parameter(property="webappSourceDir", defaultValue="${basedir}/src/main/webapp")
    private String webappSourceDir;
    @Parameter(property="webappTargetDir", defaultValue="${project.build.directory}/${project.build.finalName}")
    private String webappTargetDir;
    @Parameter(property="cssSourceDir", defaultValue="css")
    private String cssSourceDir;
    @Parameter(property="cssSourceFiles", alias="cssFiles")
    private ArrayList<String> cssSourceFiles;
    @Parameter(property="cssSourceIncludes", alias="cssIncludes")
    private ArrayList<String> cssSourceIncludes;
    @Parameter(property="cssSourceExcludes", alias="cssExcludes")
    private ArrayList<String> cssSourceExcludes;
    @Parameter(property="cssTargetDir")
    private String cssTargetDir;
    @Parameter(property="cssFinalFile", defaultValue="style.css")
    private String cssFinalFile;
    @Parameter(property="cssEngine", defaultValue="YUI")
    private Engine cssEngine;
    @Parameter(property="jsSourceDir", defaultValue="js")
    private String jsSourceDir;
    @Parameter(property="jsSourceFiles", alias="jsFiles")
    private ArrayList<String> jsSourceFiles;
    @Parameter(property="jsSourceIncludes", alias="jsIncludes")
    private ArrayList<String> jsSourceIncludes;
    @Parameter(property="jsSourceExcludes", alias="jsExcludes")
    private ArrayList<String> jsSourceExcludes;
    @Parameter(property="jsTargetDir")
    private String jsTargetDir;
    @Parameter(property="jsFinalFile", defaultValue="script.js")
    private String jsFinalFile;
    @Parameter(property="jsEngine", defaultValue="YUI")
    private Engine jsEngine;
    @Deprecated
    @Parameter(property="linebreak")
    private Integer linebreak;
    @Parameter(property="yuiLinebreak", defaultValue="-1")
    private int yuiLinebreak;
    @Deprecated
    @Parameter(property="munge")
    private Boolean munge;
    @Parameter(property="yuiMunge", defaultValue="true")
    private boolean yuiMunge;
    @Deprecated
    @Parameter(property="preserveAllSemiColons")
    private Boolean preserveAllSemiColons;
    @Parameter(property="yuiPreserveAllSemiColons", defaultValue="false")
    private boolean yuiPreserveAllSemiColons;
    @Deprecated
    @Parameter(property="disableOptimizations")
    private Boolean disableOptimizations;
    @Parameter(property="yuiDisableOptimizations", defaultValue="false")
    private boolean yuiDisableOptimizations;
    @Parameter(property="closureLanguageIn", defaultValue="ECMASCRIPT3")
    private CompilerOptions.LanguageMode closureLanguage;
    @Parameter(property="closureCompilationLevel", defaultValue="SIMPLE_OPTIMIZATIONS")
    private CompilationLevel closureCompilationLevel;
    @Parameter(property="closureExterns")
    private ArrayList<String> closureExterns;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkDeprecatedOptions();
        if (this.skipMerge && this.skipMinify) {
            this.getLog().warn((CharSequence)"Both merge and minify steps are configured to be skipped.");
            return;
        }
        this.fillOptionalValues();
        YuiConfig yuiConfig = this.fillYuiConfig();
        ClosureConfig closureConfig = this.fillClosureConfig();
        ArrayList<ProcessFilesTask> processFilesTasks = new ArrayList<ProcessFilesTask>();
        processFilesTasks.add(new ProcessCSSFilesTask(this.getLog(), this.debug, this.bufferSize, this.charset, this.suffix, this.nosuffix, this.skipMerge, this.skipMinify, this.webappSourceDir, this.webappTargetDir, this.cssSourceDir, this.cssSourceFiles, this.cssSourceIncludes, this.cssSourceExcludes, this.cssTargetDir, this.cssFinalFile, this.cssEngine, yuiConfig));
        processFilesTasks.add(new ProcessJSFilesTask(this.getLog(), this.debug, this.bufferSize, this.charset, this.suffix, this.nosuffix, this.skipMerge, this.skipMinify, this.webappSourceDir, this.webappTargetDir, this.jsSourceDir, this.jsSourceFiles, this.jsSourceIncludes, this.jsSourceExcludes, this.jsTargetDir, this.jsFinalFile, this.jsEngine, yuiConfig, closureConfig));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            List futures = executor.invokeAll(processFilesTasks);
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new MojoFailureException(e.getMessage(), (Throwable)e);
                }
            }
            executor.shutdown();
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkDeprecatedOptions() {
        if (this.debug == null) {
            this.debug = this.verbose;
        } else {
            this.getLog().warn((CharSequence)"The option 'debug' is deprecated and will be removed on the next version. Use 'verbose' instead.");
        }
        if (this.linebreak == null) {
            this.linebreak = this.yuiLinebreak;
        } else {
            this.getLog().warn((CharSequence)"The option 'linebreak' is deprecated and will be removed on the next version. Use 'yuiLinebreak' instead.");
        }
        if (this.munge == null) {
            this.munge = this.yuiMunge;
        } else {
            this.getLog().warn((CharSequence)"The option 'munge' is deprecated and will be removed on the next version. Use 'yuiMunge' instead.");
        }
        if (this.preserveAllSemiColons == null) {
            this.preserveAllSemiColons = this.yuiPreserveAllSemiColons;
        } else {
            this.getLog().warn((CharSequence)"The option 'preserveAllSemiColons' is deprecated and will be removed on the next version. Use 'yuiPreserveAllSemiColons' instead.");
        }
        if (this.disableOptimizations == null) {
            this.disableOptimizations = this.yuiDisableOptimizations;
        } else {
            this.getLog().warn((CharSequence)"The option 'disableOptimizations' is deprecated and will be removed on the next version. Use 'yuiDisableOptimizations' instead.");
        }
    }

    private void fillOptionalValues() {
        if (Strings.isNullOrEmpty((String)this.cssTargetDir)) {
            this.cssTargetDir = this.cssSourceDir;
        }
        if (Strings.isNullOrEmpty((String)this.jsTargetDir)) {
            this.jsTargetDir = this.jsSourceDir;
        }
    }

    private YuiConfig fillYuiConfig() {
        return new YuiConfig(this.linebreak, this.munge, this.preserveAllSemiColons, this.disableOptimizations);
    }

    private ClosureConfig fillClosureConfig() {
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        for (String extern : this.closureExterns) {
            externs.add(SourceFile.fromFile((String)(this.webappSourceDir + File.separator + extern), (Charset)Charset.forName(this.charset)));
        }
        return new ClosureConfig(this.closureLanguage, this.closureCompilationLevel, externs);
    }

    public static enum Engine {
        YUI,
        CLOSURE;

    }
}

