/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.SourceFile;
import com.samaxes.maven.minify.common.Aggregation;
import com.samaxes.maven.minify.common.AggregationConfiguration;
import com.samaxes.maven.minify.common.ClosureConfig;
import com.samaxes.maven.minify.common.YuiConfig;
import com.samaxes.maven.minify.plugin.ProcessCSSFilesTask;
import com.samaxes.maven.minify.plugin.ProcessFilesTask;
import com.samaxes.maven.minify.plugin.ProcessJSFilesTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="minify", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class MinifyMojo
extends AbstractMojo {
    @Deprecated
    @Parameter(property="debug")
    private Boolean debug;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="bufferSize", defaultValue="4096")
    private int bufferSize;
    @Parameter(property="charset", defaultValue="${project.build.sourceEncoding}")
    private String charset;
    @Parameter(property="suffix", defaultValue=".min")
    private String suffix;
    @Parameter(property="nosuffix", defaultValue="false")
    private boolean nosuffix;
    @Parameter(property="skipMerge", defaultValue="false")
    private boolean skipMerge;
    @Parameter(property="skipMinify", defaultValue="false")
    private boolean skipMinify;
    @Parameter(property="webappSourceDir", defaultValue="${basedir}/src/main/webapp")
    private String webappSourceDir;
    @Parameter(property="webappTargetDir", defaultValue="${project.build.directory}/${project.build.finalName}")
    private String webappTargetDir;
    @Parameter(property="bundleConfiguration")
    private String bundleConfiguration;
    @Parameter(property="cssSourceDir", defaultValue="css")
    private String cssSourceDir;
    @Parameter(property="cssSourceFiles", alias="cssFiles")
    private ArrayList<String> cssSourceFiles;
    @Parameter(property="cssSourceIncludes", alias="cssIncludes")
    private ArrayList<String> cssSourceIncludes;
    @Parameter(property="cssSourceExcludes", alias="cssExcludes")
    private ArrayList<String> cssSourceExcludes;
    @Parameter(property="cssTargetDir")
    private String cssTargetDir;
    @Parameter(property="cssFinalFile", defaultValue="style.css")
    private String cssFinalFile;
    @Parameter(property="cssEngine", defaultValue="YUI")
    private Engine cssEngine;
    @Parameter(property="jsSourceDir", defaultValue="js")
    private String jsSourceDir;
    @Parameter(property="jsSourceFiles", alias="jsFiles")
    private ArrayList<String> jsSourceFiles;
    @Parameter(property="jsSourceIncludes", alias="jsIncludes")
    private ArrayList<String> jsSourceIncludes;
    @Parameter(property="jsSourceExcludes", alias="jsExcludes")
    private ArrayList<String> jsSourceExcludes;
    @Parameter(property="jsTargetDir")
    private String jsTargetDir;
    @Parameter(property="jsFinalFile", defaultValue="script.js")
    private String jsFinalFile;
    @Parameter(property="jsEngine", defaultValue="YUI")
    private Engine jsEngine;
    @Deprecated
    @Parameter(property="linebreak")
    private Integer linebreak;
    @Parameter(property="yuiLineBreak", defaultValue="-1")
    private int yuiLineBreak;
    @Deprecated
    @Parameter(property="munge")
    private Boolean munge;
    @Parameter(property="yuiNoMunge", defaultValue="false")
    private boolean yuiNoMunge;
    @Deprecated
    @Parameter(property="preserveAllSemiColons")
    private Boolean preserveAllSemiColons;
    @Parameter(property="yuiPreserveSemicolons", defaultValue="false")
    private boolean yuiPreserveSemicolons;
    @Deprecated
    @Parameter(property="disableOptimizations")
    private Boolean disableOptimizations;
    @Parameter(property="yuiDisableOptimizations", defaultValue="false")
    private boolean yuiDisableOptimizations;
    @Parameter(property="closureLanguageIn", defaultValue="ECMASCRIPT6")
    private CompilerOptions.LanguageMode closureLanguageIn;
    @Parameter(property="closureLanguageOut", defaultValue="ECMASCRIPT5")
    private CompilerOptions.LanguageMode closureLanguageOut;
    @Parameter(property="closureEnvironment", defaultValue="BROWSER")
    private CompilerOptions.Environment closureEnvironment;
    @Parameter(property="closureCompilationLevel", defaultValue="SIMPLE_OPTIMIZATIONS")
    private CompilationLevel closureCompilationLevel;
    @Parameter(property="closureExterns")
    private ArrayList<String> closureExterns;
    @Parameter(property="closureCreateSourceMap", defaultValue="false")
    private boolean closureCreateSourceMap;
    @Parameter(property="closureSortDependencies", defaultValue="false")
    private boolean closureSortDependencies;
    @Parameter(property="closureWarningLevels")
    private HashMap<String, String> closureWarningLevels;
    @Parameter(property="closureAngularPass", defaultValue="false")
    private boolean closureAngularPass;
    @Parameter(property="closureExtraAnnotations")
    private ArrayList<String> closureExtraAnnotations;
    @Parameter(property="closureDefine")
    private HashMap<String, String> closureDefine;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Collection<ProcessFilesTask> processFilesTasks;
        this.checkDeprecatedOptions();
        if (this.skipMerge && this.skipMinify) {
            this.getLog().warn((CharSequence)"Both merge and minify steps are configured to be skipped.");
            return;
        }
        this.fillOptionalValues();
        YuiConfig yuiConfig = this.fillYuiConfig();
        ClosureConfig closureConfig = this.fillClosureConfig();
        try {
            processFilesTasks = this.createTasks(yuiConfig, closureConfig);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        ExecutorService executor = Executors.newFixedThreadPool(processFilesTasks.size());
        try {
            List futures = executor.invokeAll(processFilesTasks);
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            executor.shutdown();
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void checkDeprecatedOptions() {
        if (this.debug == null) {
            this.debug = this.verbose;
        } else {
            this.getLog().warn((CharSequence)"The option 'debug' is deprecated and will be removed on the next version. Use 'verbose' instead.");
        }
        if (this.linebreak == null) {
            this.linebreak = this.yuiLineBreak;
        } else {
            this.getLog().warn((CharSequence)"The option 'linebreak' is deprecated and will be removed on the next version. Use 'yuiLineBreak' instead.");
        }
        if (this.munge == null) {
            this.munge = !this.yuiNoMunge;
        } else {
            this.getLog().warn((CharSequence)"The option 'munge' is deprecated and will be removed on the next version. Use 'yuiNoMunge' instead.");
        }
        if (this.preserveAllSemiColons == null) {
            this.preserveAllSemiColons = this.yuiPreserveSemicolons;
        } else {
            this.getLog().warn((CharSequence)"The option 'preserveAllSemiColons' is deprecated and will be removed on the next version. Use 'yuiPreserveSemicolons' instead.");
        }
        if (this.disableOptimizations == null) {
            this.disableOptimizations = this.yuiDisableOptimizations;
        } else {
            this.getLog().warn((CharSequence)"The option 'disableOptimizations' is deprecated and will be removed on the next version. Use 'yuiDisableOptimizations' instead.");
        }
    }

    private void fillOptionalValues() {
        if (Strings.isNullOrEmpty((String)this.cssTargetDir)) {
            this.cssTargetDir = this.cssSourceDir;
        }
        if (Strings.isNullOrEmpty((String)this.jsTargetDir)) {
            this.jsTargetDir = this.jsSourceDir;
        }
        if (Strings.isNullOrEmpty((String)this.charset)) {
            this.charset = Charset.defaultCharset().name();
        }
    }

    private YuiConfig fillYuiConfig() {
        return new YuiConfig(this.linebreak, this.munge, this.preserveAllSemiColons, this.disableOptimizations);
    }

    private ClosureConfig fillClosureConfig() throws MojoFailureException {
        DependencyOptions dependencyOptions = new DependencyOptions();
        dependencyOptions.setDependencySorting(this.closureSortDependencies);
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        for (String extern : this.closureExterns) {
            externs.add(SourceFile.fromFile((String)(this.webappSourceDir + File.separator + extern), (Charset)Charset.forName(this.charset)));
        }
        HashMap<DiagnosticGroup, CheckLevel> warningLevels = new HashMap<DiagnosticGroup, CheckLevel>();
        DiagnosticGroups diagnosticGroups = new DiagnosticGroups();
        for (Map.Entry<String, String> warningLevel : this.closureWarningLevels.entrySet()) {
            DiagnosticGroup diagnosticGroup = diagnosticGroups.forName(warningLevel.getKey());
            if (diagnosticGroup == null) {
                throw new MojoFailureException("Failed to process closureWarningLevels: " + warningLevel.getKey() + " is an invalid DiagnosticGroup");
            }
            try {
                CheckLevel checkLevel = CheckLevel.valueOf((String)warningLevel.getValue());
                warningLevels.put(diagnosticGroup, checkLevel);
            }
            catch (IllegalArgumentException e) {
                throw new MojoFailureException("Failed to process closureWarningLevels: " + warningLevel.getKey() + " is an invalid CheckLevel");
            }
        }
        return new ClosureConfig(this.closureLanguageIn, this.closureLanguageOut, this.closureEnvironment, this.closureCompilationLevel, dependencyOptions, externs, this.closureCreateSourceMap, warningLevels, this.closureAngularPass, this.closureExtraAnnotations, this.closureDefine);
    }

    private Collection<ProcessFilesTask> createTasks(YuiConfig yuiConfig, ClosureConfig closureConfig) throws MojoFailureException, FileNotFoundException {
        ArrayList tasks = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)this.bundleConfiguration)) {
            AggregationConfiguration aggregationConfiguration;
            try (FileReader bundleConfigurationReader = new FileReader(this.bundleConfiguration);){
                aggregationConfiguration = (AggregationConfiguration)new Gson().fromJson((Reader)bundleConfigurationReader, AggregationConfiguration.class);
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to open the bundle configuration file [" + this.bundleConfiguration + "].", (Throwable)e);
            }
            for (Aggregation aggregation : aggregationConfiguration.getBundles()) {
                if (Aggregation.AggregationType.css.equals((Object)aggregation.getType())) {
                    tasks.add(this.createCSSTask(yuiConfig, closureConfig, aggregation.getFiles(), Collections.emptyList(), Collections.emptyList(), aggregation.getName()));
                    continue;
                }
                if (!Aggregation.AggregationType.js.equals((Object)aggregation.getType())) continue;
                tasks.add(this.createJSTask(yuiConfig, closureConfig, aggregation.getFiles(), Collections.emptyList(), Collections.emptyList(), aggregation.getName()));
            }
        } else {
            tasks.add(this.createCSSTask(yuiConfig, closureConfig, this.cssSourceFiles, this.cssSourceIncludes, this.cssSourceExcludes, this.cssFinalFile));
            tasks.add(this.createJSTask(yuiConfig, closureConfig, this.jsSourceFiles, this.jsSourceIncludes, this.jsSourceExcludes, this.jsFinalFile));
        }
        return tasks;
    }

    private ProcessFilesTask createCSSTask(YuiConfig yuiConfig, ClosureConfig closureConfig, List<String> cssSourceFiles, List<String> cssSourceIncludes, List<String> cssSourceExcludes, String cssFinalFile) throws FileNotFoundException {
        return new ProcessCSSFilesTask(this.getLog(), this.debug, this.bufferSize, Charset.forName(this.charset), this.suffix, this.nosuffix, this.skipMerge, this.skipMinify, this.webappSourceDir, this.webappTargetDir, this.cssSourceDir, cssSourceFiles, cssSourceIncludes, cssSourceExcludes, this.cssTargetDir, cssFinalFile, this.cssEngine, yuiConfig);
    }

    private ProcessFilesTask createJSTask(YuiConfig yuiConfig, ClosureConfig closureConfig, List<String> jsSourceFiles, List<String> jsSourceIncludes, List<String> jsSourceExcludes, String jsFinalFile) throws FileNotFoundException {
        return new ProcessJSFilesTask(this.getLog(), this.debug, this.bufferSize, Charset.forName(this.charset), this.suffix, this.nosuffix, this.skipMerge, this.skipMinify, this.webappSourceDir, this.webappTargetDir, this.jsSourceDir, jsSourceFiles, jsSourceIncludes, jsSourceExcludes, this.jsTargetDir, jsFinalFile, this.jsEngine, yuiConfig, closureConfig);
    }

    public static enum Engine {
        YUI,
        CLOSURE;

    }
}

