/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j;

import com.samczsun.skype4j.Skype;
import com.samczsun.skype4j.exceptions.handler.ErrorHandler;
import com.samczsun.skype4j.internal.client.FullClient;
import com.samczsun.skype4j.internal.client.GuestClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class SkypeBuilder {
    private final String username;
    private final String password;
    private Set<String> resources = new HashSet<String>();
    private List<ErrorHandler> errorHandlers = new ArrayList<ErrorHandler>();
    private Logger customLogger;
    private String chatId;

    public SkypeBuilder(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public SkypeBuilder(String username) {
        this.username = username;
        this.password = null;
    }

    public SkypeBuilder withAllResources() {
        this.resources.addAll(Arrays.asList("/v1/users/ME/conversations/ALL/properties", "/v1/users/ME/conversations/ALL/messages", "/v1/users/ME/contacts/ALL", "/v1/threads/ALL"));
        return this;
    }

    public SkypeBuilder withResource(String resource) {
        this.resources.add(resource);
        return this;
    }

    public SkypeBuilder withLogger(Logger logger) {
        this.customLogger = logger;
        return this;
    }

    public SkypeBuilder withExceptionHandler(ErrorHandler errorHandler) {
        this.errorHandlers.add(errorHandler);
        return this;
    }

    public SkypeBuilder withChat(String id) {
        if (!id.startsWith("19:")) {
            throw new IllegalArgumentException("Invalid chat id");
        }
        if (this.password != null) {
            throw new IllegalArgumentException("Not guest account");
        }
        this.chatId = id;
        return this;
    }

    public Skype build() {
        if (this.resources.isEmpty()) {
            throw new IllegalArgumentException("No resources selected");
        }
        if (this.password != null) {
            return new FullClient(this.username, this.password, this.resources, this.customLogger, this.errorHandlers);
        }
        if (this.chatId != null) {
            return new GuestClient(this.username, this.chatId, this.resources, this.customLogger, this.errorHandlers);
        }
        throw new IllegalArgumentException("No chat specified");
    }
}

