/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal;

import com.eclipsesource.json.JsonObject;
import com.samczsun.skype4j.exceptions.SkypeException;
import com.samczsun.skype4j.internal.MessageType;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.helper.Validate;

public enum EventType {
    NEW_MESSAGE("NewMessage"){

        @Override
        public void handle(SkypeImpl skype, JsonObject eventObj) throws SkypeException, IOException {
            JsonObject resource = eventObj.get("resource").asObject();
            String type = Utils.getString(resource, "messagetype");
            try {
                Validate.notNull(type, "Null type");
                MessageType.getByName(type).handle(skype, resource);
            }
            catch (Throwable t) {
                t.addSuppressed(new SkypeException(resource.toString()));
                throw t;
            }
        }
    }
    ,
    ENDPOINT_PRESENCE("EndpointPresence"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws SkypeException {
        }
    }
    ,
    USER_PRESENCE("UserPresence"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws SkypeException {
        }
    }
    ,
    CONVERSATION_UPDATE("ConversationUpdate"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws SkypeException {
        }
    }
    ,
    THREAD_UPDATE("ThreadUpdate"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws SkypeException {
        }
    };

    private static final Map<String, EventType> byValue;
    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static EventType getByName(String eventType) {
        return byValue.get(eventType);
    }

    public abstract void handle(SkypeImpl var1, JsonObject var2) throws SkypeException, IOException;

    static {
        byValue = new HashMap<String, EventType>();
        for (EventType type : EventType.values()) {
            byValue.put(type.getValue(), type);
        }
    }
}

