/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal;

import com.eclipsesource.json.JsonObject;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.exceptions.handler.ErrorSource;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.SkypeThreadFactory;
import com.samczsun.skype4j.internal.client.FullClient;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.java_websocket.SSLSocketChannel2;
import org.java_websocket.client.DefaultSSLWebSocketClientFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ServerHandshake;

public class SkypeWebSocket
extends WebSocketClient {
    private final SkypeImpl skype;
    private final ExecutorService singleThreaded;
    private Thread pingThread;

    public SkypeWebSocket(final SkypeImpl skype, URI uri) throws NoSuchAlgorithmException, KeyManagementException {
        super(uri, new Draft_17(), null, 2000);
        this.skype = skype;
        this.singleThreaded = Executors.newSingleThreadExecutor(new SkypeThreadFactory(skype, "WSFactory"));
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        this.setWebSocketFactory(new DefaultSSLWebSocketClientFactory(sc, this.singleThreaded){
            private boolean called;
            {
                super(x0, x1);
                this.called = false;
            }

            @Override
            public ByteChannel wrapChannel(SocketChannel channel, SelectionKey key, String host, int port) throws IOException {
                if (!this.called) {
                    Thread.currentThread().setName("Skype4J-WSMainThread-" + skype.getUsername());
                }
                SSLEngine e = this.sslcontext.createSSLEngine(host, port);
                e.setUseClientMode(true);
                SSLSocketChannel2 c = new SSLSocketChannel2(channel, e, this.exec, key){
                    private boolean called;
                    {
                        this.called = false;
                    }

                    @Override
                    public int write(ByteBuffer buffer) throws IOException {
                        if (!this.called) {
                            Thread.currentThread().setName("Skype4J-WSWriteThread-" + skype.getUsername());
                            this.called = true;
                        }
                        return super.write(buffer);
                    }
                };
                return c;
            }
        });
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        this.pingThread = new Thread("Skype4J-Pinger-" + this.skype.getUsername()){
            AtomicInteger currentPing;
            {
                this.currentPing = new AtomicInteger(1);
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(55000L);
                        SkypeWebSocket.this.send("5:" + this.currentPing.getAndIncrement() + "+::{\"name\":\"ping\"}");
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        this.pingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(String s) {
        block25: {
            if (s.startsWith("3:::")) {
                JsonObject message = JsonObject.readFrom(s.substring(4));
                JsonObject body = JsonObject.readFrom(message.get("body").asString());
                int event = body.get("evt").asInt();
                if (event == 6) {
                    try {
                        this.skype.updateContactList();
                    }
                    catch (ConnectionException e) {
                        this.skype.handleError(ErrorSource.UPDATING_CONTACT_LIST, e, false);
                    }
                } else if (event == 14) {
                    try {
                        if (this.skype instanceof FullClient) {
                            this.skype.getContactRequests(true);
                        }
                    }
                    catch (ConnectionException e) {
                        this.skype.getLogger().log(Level.SEVERE, String.format("Unhandled exception while parsing websocket message '%s'", s), e);
                    }
                } else {
                    this.skype.getLogger().log(Level.SEVERE, String.format("Unhandled websocket message '%s'", s));
                }
                JsonObject trouterRequest = new JsonObject();
                trouterRequest.add("ts", System.currentTimeMillis());
                trouterRequest.add("auth", true);
                JsonObject headers = new JsonObject();
                headers.add("trouter-request", trouterRequest);
                JsonObject trouterClient = new JsonObject();
                trouterClient.add("cd", 0);
                JsonObject response = new JsonObject();
                response.add("id", message.get("id").asInt());
                response.add("status", 200);
                response.add("headers", headers);
                response.add("trouter-client", trouterClient);
                response.add("body", "");
                this.send("3:::" + response.toString());
            } else if (s.startsWith("5:")) {
                if (s.contains("reconnect")) {
                    try {
                        this.skype.registerWebSocket();
                    }
                    catch (Exception e) {
                        this.skype.handleError(ErrorSource.REGISTERING_WEBSOCKET, e, false);
                    }
                }
            } else if (s.equals("0::")) {
                try {
                    this.closeBlocking();
                }
                catch (InterruptedException e) {
                    this.skype.handleError(ErrorSource.CLOSING_WEBSOCKET, e, false);
                }
                finally {
                    if (this.pingThread.isAlive()) {
                        this.pingThread.interrupt();
                    }
                    if (this.singleThreaded.isTerminated()) break block25;
                    this.singleThreaded.shutdown();
                    while (!this.singleThreaded.isTerminated()) {
                    }
                }
            }
        }
    }

    @Override
    public void onClose(int i, String s, boolean b) {
        this.pingThread.interrupt();
        this.singleThreaded.shutdown();
        while (!this.singleThreaded.isTerminated()) {
        }
        if (this.skype.getWebSocket() == this) {
            try {
                this.skype.registerWebSocket();
            }
            catch (Exception e) {
                this.skype.handleError(ErrorSource.REGISTERING_WEBSOCKET, e, false);
            }
        }
    }

    @Override
    public void onError(Exception e) {
        this.skype.getLogger().log(Level.SEVERE, "Exception in websocket client", e);
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

