/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal;

import com.eclipsesource.json.JsonObject;
import com.samczsun.skype4j.chat.Chat;
import com.samczsun.skype4j.chat.GroupChat;
import com.samczsun.skype4j.chat.messages.ChatMessage;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.exceptions.NoPermissionException;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.chat.ChatImpl;
import com.samczsun.skype4j.user.Contact;
import com.samczsun.skype4j.user.User;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class UserImpl
implements User {
    private final String username;
    private final ChatImpl chat;
    private final SkypeImpl client;
    private User.Role role = User.Role.USER;
    private Contact contactRep;
    private final List<ChatMessage> messages = new CopyOnWriteArrayList<ChatMessage>();
    private final Map<String, ChatMessage> messageMap = new ConcurrentHashMap<String, ChatMessage>();

    public UserImpl(String username, ChatImpl chat, SkypeImpl client) throws ConnectionException {
        this.username = username;
        this.chat = chat;
        this.client = client;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getDisplayName() throws ConnectionException {
        this.loadContact();
        return this.contactRep.getDisplayName();
    }

    @Override
    public Contact getContact() throws ConnectionException {
        this.loadContact();
        return this.contactRep;
    }

    @Override
    public User.Role getRole() {
        return this.role;
    }

    @Override
    public void setRole(User.Role role) throws ConnectionException, NoPermissionException {
        if (!(this.getChat() instanceof GroupChat)) {
            throw new NoPermissionException();
        }
        Endpoints.MODIFY_MEMBER_URL.open(this.getClient(), this.getChat().getIdentity(), this.getUsername()).on(400, connection -> {
            throw new NoPermissionException();
        }).expect(200, "While updating role").put(new JsonObject().add("role", role.name().toLowerCase()));
        this.updateRole(role);
    }

    @Override
    public SkypeImpl getClient() {
        return this.client;
    }

    @Override
    public Chat getChat() {
        return this.chat;
    }

    @Override
    public List<ChatMessage> getSentMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    @Override
    public ChatMessage getMessageById(String id) {
        return this.messageMap.get(id);
    }

    public void onMessage(ChatMessage message) {
        this.messages.add(message);
        this.messageMap.put(message.getClientId(), message);
    }

    public void updateRole(User.Role role) {
        this.role = role;
    }

    public void insertMessage(ChatMessage m, int i) {
        this.messages.add(i, m);
    }

    private void loadContact() throws ConnectionException {
        if (this.contactRep == null) {
            this.contactRep = this.chat.getClient().getOrLoadContact(this.username);
        }
    }
}

