/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.chat.ChatImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Utils {
    public static JsonObject parseJsonObject(InputStream inputStream) throws IOException {
        return Utils.parseJsonValue(inputStream).asObject();
    }

    public static JsonArray parseJsonArray(InputStream inputStream) throws IOException {
        return Utils.parseJsonValue(inputStream).asArray();
    }

    public static JsonValue parseJsonValue(InputStream inputStream) throws IOException {
        JsonValue jsonValue;
        try (InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");){
            jsonValue = JsonValue.readFrom(reader);
        }
        return jsonValue;
    }

    public static String uploadImage(byte[] image, ImageType uploadType, ChatImpl chat) throws ConnectionException {
        return Utils.upload(image, uploadType, null, chat);
    }

    public static String upload(byte[] data, ImageType type, JsonObject extra, ChatImpl chat) throws ConnectionException {
        JsonObject status;
        JsonObject obj = new JsonObject();
        obj.add("type", type.mime);
        obj.add("permissions", new JsonObject().add(chat.getIdentity(), new JsonArray().add("read")));
        if (extra != null) {
            extra.forEach(m -> obj.add(m.getName(), m.getValue()));
        }
        JsonObject response = Endpoints.OBJECTS.open(chat.getClient(), new Object[0]).as(JsonObject.class).expect(201, "While uploading data").post(obj);
        String id = response.get("id").asString();
        Endpoints.UPLOAD_IMAGE.open(chat.getClient(), id, type.endpoint).header("Content-Type", "multipart/form-data").expect(201, "While uploading data").connect("PUT", data);
        Endpoints.EndpointConnection<JsonObject> econn = Endpoints.IMG_STATUS.open(chat.getClient(), id, type.id).as(JsonObject.class).expect(200, "While getting upload status");
        while (!(status = econn.get()).get("view_state").asString().equals("ready")) {
        }
        return id;
    }

    public static String getString(JsonObject object, String key) {
        return object.get(key) == null ? null : (object.get(key).isNull() ? null : object.get(key).asString());
    }

    public static <T> Stream<T> asStream(Iterable<T> sourceIterable) {
        return Utils.asStream(sourceIterable.iterator());
    }

    public static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        return Utils.asStream(sourceIterator, false);
    }

    public static <T> Stream<T> asStream(Iterator<T> sourceIterator, boolean parallel) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }

    public static void sneakyThrow(Throwable ex) {
        Utils.sneakyThrowInner(ex);
    }

    private static <T extends Throwable> T sneakyThrowInner(Throwable ex) throws T {
        throw ex;
    }

    public static enum ImageType {
        IMGT1("pish/image", "imgpsh", "imgt1"),
        AVATAR("avatar/group", "avatar", "avatar_fullsize"),
        FILE("sharing/file", "original", "thumbnail");

        private String mime;
        private String endpoint;
        private String id;

        private ImageType(String mime, String endpoint, String id) {
            this.mime = mime;
            this.endpoint = endpoint;
            this.id = id;
        }
    }
}

