/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal.threads;

import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.exceptions.handler.ErrorSource;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.SkypeImpl;

public class KeepaliveThread
extends Thread {
    private SkypeImpl skype;

    public KeepaliveThread(SkypeImpl skype) {
        super(String.format("Skype4J-Keepalive-%s", skype.getUsername()));
        this.skype = skype;
    }

    @Override
    public void run() {
        while (this.skype.isLoggedIn()) {
            if (this.skype.isAuthenticated()) {
                try {
                    Endpoints.PING_URL.open(this.skype, new Object[0]).expect(200, "While maintaining session").cookies(this.skype.getCookies()).connect("POST", "sessionId=" + this.skype.getGuid().toString());
                }
                catch (ConnectionException e) {
                    this.skype.handleError(ErrorSource.SESSION_KEEPALIVE, e, true);
                    return;
                }
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return;
        }
    }
}

