/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.AbstractActor;
import akka.actor.Actor;
import akka.actor.ActorCell$;
import akka.actor.ActorContext;
import akka.actor.ActorIdentity;
import akka.actor.ActorIdentity$;
import akka.actor.ActorInitializationException;
import akka.actor.ActorInitializationException$;
import akka.actor.ActorKilledException$;
import akka.actor.ActorRef;
import akka.actor.ActorRef$;
import akka.actor.ActorRefFactory;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSelection$;
import akka.actor.ActorSelectionMessage;
import akka.actor.ActorSystem;
import akka.actor.ActorSystemImpl;
import akka.actor.Address;
import akka.actor.AddressTerminated;
import akka.actor.AddressTerminated$;
import akka.actor.AutoReceivedMessage;
import akka.actor.Cancellable;
import akka.actor.Cell;
import akka.actor.Identify;
import akka.actor.Identify$;
import akka.actor.InternalActorRef;
import akka.actor.Kill$;
import akka.actor.PoisonPill$;
import akka.actor.Props;
import akka.actor.RepointableActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.Terminated;
import akka.actor.dungeon.Children;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.DeathWatch;
import akka.actor.dungeon.Dispatch;
import akka.actor.dungeon.FaultHandling;
import akka.actor.dungeon.ReceiveTimeout;
import akka.annotation.InternalStableApi;
import akka.dispatch.Envelope;
import akka.dispatch.Envelope$;
import akka.dispatch.Mailbox;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.sysmsg.Create;
import akka.dispatch.sysmsg.Create$;
import akka.dispatch.sysmsg.DeathWatchNotification;
import akka.dispatch.sysmsg.DeathWatchNotification$;
import akka.dispatch.sysmsg.EarliestFirstSystemMessageList;
import akka.dispatch.sysmsg.EarliestFirstSystemMessageList$;
import akka.dispatch.sysmsg.Failed;
import akka.dispatch.sysmsg.LatestFirstSystemMessageList;
import akka.dispatch.sysmsg.LatestFirstSystemMessageList$;
import akka.dispatch.sysmsg.NoMessage$;
import akka.dispatch.sysmsg.Recreate;
import akka.dispatch.sysmsg.Recreate$;
import akka.dispatch.sysmsg.Resume;
import akka.dispatch.sysmsg.Resume$;
import akka.dispatch.sysmsg.StashWhenFailed;
import akka.dispatch.sysmsg.StashWhenWaitingForChildren;
import akka.dispatch.sysmsg.Supervise;
import akka.dispatch.sysmsg.Supervise$;
import akka.dispatch.sysmsg.Suspend;
import akka.dispatch.sysmsg.Suspend$;
import akka.dispatch.sysmsg.SystemMessage;
import akka.dispatch.sysmsg.SystemMessageList$;
import akka.dispatch.sysmsg.Terminate;
import akka.dispatch.sysmsg.Terminate$;
import akka.dispatch.sysmsg.Unwatch;
import akka.dispatch.sysmsg.Unwatch$;
import akka.dispatch.sysmsg.Watch;
import akka.dispatch.sysmsg.Watch$;
import akka.event.Logging;
import akka.event.Logging$Debug$;
import akka.event.Logging$Error$;
import akka.japi.Procedure;
import dotty.DottyPredef$;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContextExecutor;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public class ActorCell
implements ActorRefFactory,
ActorContext,
AbstractActor.ActorContext,
Cell,
ReceiveTimeout,
Children,
Dispatch,
DeathWatch,
FaultHandling {
    private Tuple2 akka$actor$dungeon$ReceiveTimeout$$receiveTimeoutData;
    private volatile ChildrenContainer akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly;
    private volatile Map akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly;
    private volatile long akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly;
    private volatile Mailbox akka$actor$dungeon$Dispatch$$_mailboxDoNotCallMeDirectly;
    private Map akka$actor$dungeon$DeathWatch$$watching;
    private Set akka$actor$dungeon$DeathWatch$$watchedBy;
    private Map akka$actor$dungeon$DeathWatch$$terminatedQueued;
    private FaultHandling.FailedInfo akka$actor$dungeon$FaultHandling$$_failed;
    private final ActorSystemImpl system;
    private final InternalActorRef self;
    private final MessageDispatcher dispatcher;
    private final InternalActorRef parent;
    private Props _props;
    private Actor _actor;
    private Envelope currentMessage;
    private List<PartialFunction<Object, BoxedUnit>> behaviorStack;
    private SystemMessage sysmsgStash;

    public static int DefaultState() {
        return ActorCell$.MODULE$.DefaultState();
    }

    public static int SuspendedState() {
        return ActorCell$.MODULE$.SuspendedState();
    }

    public static int SuspendedWaitForChildrenState() {
        return ActorCell$.MODULE$.SuspendedWaitForChildrenState();
    }

    public static ThreadLocal contextStack() {
        return ActorCell$.MODULE$.contextStack();
    }

    public static Set emptyActorRefSet() {
        return ActorCell$.MODULE$.emptyActorRefSet();
    }

    public static List emptyBehaviorStack() {
        return ActorCell$.MODULE$.emptyBehaviorStack();
    }

    public static Cancellable emptyCancellable() {
        return ActorCell$.MODULE$.emptyCancellable();
    }

    public static int newUid() {
        return ActorCell$.MODULE$.newUid();
    }

    public static Tuple2<String, Object> splitNameAndUid(String string) {
        return ActorCell$.MODULE$.splitNameAndUid(string);
    }

    public static Props terminatedProps() {
        return ActorCell$.MODULE$.terminatedProps();
    }

    public static int undefinedUid() {
        return ActorCell$.MODULE$.undefinedUid();
    }

    public ActorCell(ActorSystemImpl system, InternalActorRef self, Props _initialProps, MessageDispatcher dispatcher, InternalActorRef parent) {
        this.system = system;
        this.self = self;
        this.dispatcher = dispatcher;
        this.parent = parent;
        this.akka$actor$dungeon$ReceiveTimeout$$receiveTimeoutData = ReceiveTimeout.super.akka$actor$dungeon$ReceiveTimeout$$initial$receiveTimeoutData();
        this.akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly = Children.super.akka$actor$dungeon$Children$$initial$_childrenRefsDoNotCallMeDirectly();
        this.akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly = Children.super.akka$actor$dungeon$Children$$initial$_functionRefsDoNotCallMeDirectly();
        this.akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly = Children.super.akka$actor$dungeon$Children$$initial$_nextNameDoNotCallMeDirectly();
        Children.super.$init$();
        this.akka$actor$dungeon$Dispatch$$_mailboxDoNotCallMeDirectly = Dispatch.super.akka$actor$dungeon$Dispatch$$initial$_mailboxDoNotCallMeDirectly();
        Dispatch.super.$init$();
        this.akka$actor$dungeon$DeathWatch$$watching = DeathWatch.super.akka$actor$dungeon$DeathWatch$$initial$watching();
        this.akka$actor$dungeon$DeathWatch$$watchedBy = DeathWatch.super.akka$actor$dungeon$DeathWatch$$initial$watchedBy();
        this.akka$actor$dungeon$DeathWatch$$terminatedQueued = DeathWatch.super.akka$actor$dungeon$DeathWatch$$initial$terminatedQueued();
        DeathWatch.super.$init$();
        this.akka$actor$dungeon$FaultHandling$$_failed = FaultHandling.super.akka$actor$dungeon$FaultHandling$$initial$_failed();
        FaultHandling.super.$init$();
        this._props = _initialProps;
        this.behaviorStack = ActorCell$.MODULE$.emptyBehaviorStack();
        this.sysmsgStash = SystemMessageList$.MODULE$.LNil();
    }

    public Tuple2 akka$actor$dungeon$ReceiveTimeout$$receiveTimeoutData() {
        return this.akka$actor$dungeon$ReceiveTimeout$$receiveTimeoutData;
    }

    public void akka$actor$dungeon$ReceiveTimeout$$receiveTimeoutData_$eq(Tuple2 x$1) {
        this.akka$actor$dungeon$ReceiveTimeout$$receiveTimeoutData = x$1;
    }

    @Override
    public ChildrenContainer akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly() {
        return this.akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly;
    }

    public Map akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly() {
        return this.akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly;
    }

    @Override
    public long akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly() {
        return this.akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly;
    }

    @Override
    public void akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly_$eq(ChildrenContainer x$1) {
        this.akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly = x$1;
    }

    public void akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly_$eq(Map x$1) {
        this.akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly = x$1;
    }

    @Override
    public void akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly_$eq(long x$1) {
        this.akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly = x$1;
    }

    @Override
    public Mailbox akka$actor$dungeon$Dispatch$$_mailboxDoNotCallMeDirectly() {
        return this.akka$actor$dungeon$Dispatch$$_mailboxDoNotCallMeDirectly;
    }

    @Override
    public void akka$actor$dungeon$Dispatch$$_mailboxDoNotCallMeDirectly_$eq(Mailbox x$1) {
        this.akka$actor$dungeon$Dispatch$$_mailboxDoNotCallMeDirectly = x$1;
    }

    public Map akka$actor$dungeon$DeathWatch$$watching() {
        return this.akka$actor$dungeon$DeathWatch$$watching;
    }

    public Set akka$actor$dungeon$DeathWatch$$watchedBy() {
        return this.akka$actor$dungeon$DeathWatch$$watchedBy;
    }

    public Map akka$actor$dungeon$DeathWatch$$terminatedQueued() {
        return this.akka$actor$dungeon$DeathWatch$$terminatedQueued;
    }

    public void akka$actor$dungeon$DeathWatch$$watching_$eq(Map x$1) {
        this.akka$actor$dungeon$DeathWatch$$watching = x$1;
    }

    public void akka$actor$dungeon$DeathWatch$$watchedBy_$eq(Set x$1) {
        this.akka$actor$dungeon$DeathWatch$$watchedBy = x$1;
    }

    public void akka$actor$dungeon$DeathWatch$$terminatedQueued_$eq(Map x$1) {
        this.akka$actor$dungeon$DeathWatch$$terminatedQueued = x$1;
    }

    @Override
    public FaultHandling.FailedInfo akka$actor$dungeon$FaultHandling$$_failed() {
        return this.akka$actor$dungeon$FaultHandling$$_failed;
    }

    @Override
    public void akka$actor$dungeon$FaultHandling$$_failed_$eq(FaultHandling.FailedInfo x$1) {
        this.akka$actor$dungeon$FaultHandling$$_failed = x$1;
    }

    @Override
    public ActorSystemImpl system() {
        return this.system;
    }

    @Override
    public InternalActorRef self() {
        return this.self;
    }

    @Override
    public MessageDispatcher dispatcher() {
        return this.dispatcher;
    }

    @Override
    public InternalActorRef parent() {
        return this.parent;
    }

    @Override
    public Props props() {
        return this._props;
    }

    @Override
    public final boolean isLocal() {
        return true;
    }

    @Override
    public final ActorSystemImpl systemImpl() {
        return this.system();
    }

    @Override
    public final InternalActorRef guardian() {
        return this.self();
    }

    @Override
    public final InternalActorRef lookupRoot() {
        return this.self();
    }

    @Override
    public final ActorRefProvider provider() {
        return this.system().provider();
    }

    @Override
    public final ActorContext classicActorContext() {
        return this;
    }

    public int uid() {
        return this.self().path().uid();
    }

    public Actor actor() {
        return this._actor;
    }

    public Envelope currentMessage() {
        return this.currentMessage;
    }

    public void currentMessage_$eq(Envelope x$1) {
        this.currentMessage = x$1;
    }

    @Override
    public final ActorRef getParent() {
        return this.parent();
    }

    @Override
    public final ActorSystem getSystem() {
        return this.system();
    }

    @Override
    public final ExecutionContextExecutor getDispatcher() {
        return this.dispatcher();
    }

    @Override
    public final ActorRef getSelf() {
        return this.self();
    }

    @Override
    public final Props getProps() {
        return this.props();
    }

    public void stash(SystemMessage msg) {
        if (!msg.unlinked()) {
            throw DottyPredef$.MODULE$.assertFail();
        }
        this.sysmsgStash = LatestFirstSystemMessageList$.MODULE$.$colon$colon$extension(this.sysmsgStash, msg);
    }

    private SystemMessage unstashAll() {
        SystemMessage unstashed = this.sysmsgStash;
        this.sysmsgStash = SystemMessageList$.MODULE$.LNil();
        return new LatestFirstSystemMessageList(unstashed).head();
    }

    public final void systemInvoke(SystemMessage message) {
        this.invokeAll$1(message, this.calculateState$1());
    }

    public final void invoke(Envelope messageHandle) {
        block8: {
            Object msg = messageHandle.message();
            Tuple2 timeoutBeforeReceive = this.cancelReceiveTimeoutIfNeeded(msg);
            try {
                try {
                    this.currentMessage_$eq(messageHandle);
                    if (msg instanceof AutoReceivedMessage) {
                        this.autoReceiveMessage(messageHandle);
                    } else {
                        this.receiveMessage(msg);
                    }
                    this.currentMessage_$eq(null);
                }
                catch (Throwable ex$) {
                    PartialFunction $3$ = this.handleNonFatalOrInterruptedException((Function1)(JProcedure1 & Serializable)e -> this.handleInvokeFailure((Iterable)package$.MODULE$.Nil(), (Throwable)e));
                    if ($3$.isDefinedAt((Object)ex$)) {
                        $3$.apply((Object)ex$);
                        break block8;
                    }
                    throw ex$;
                }
            }
            finally {
                this.checkReceiveTimeoutIfNeeded(msg, timeoutBeforeReceive);
            }
        }
    }

    public void autoReceiveMessage(Envelope msg) {
        Object object;
        if (this.system().settings().DebugAutoReceive()) {
            this.publish(Logging$Debug$.MODULE$.apply(this.self().path().toString(), this.clazz(this.actor()), "received AutoReceiveMessage " + msg));
        }
        if ((object = msg.message()) instanceof Terminated) {
            Terminated t = (Terminated)object;
            this.receivedTerminated(t);
        } else if (object instanceof AddressTerminated) {
            Address address;
            AddressTerminated addressTerminated = AddressTerminated$.MODULE$.unapply((AddressTerminated)object);
            Address address2 = address = addressTerminated._1();
            this.addressTerminated(address2);
        } else {
            if (Kill$.MODULE$.equals(object)) {
                throw ActorKilledException$.MODULE$.apply("Kill");
            }
            if (PoisonPill$.MODULE$.equals(object)) {
                this.self().stop();
            } else if (object instanceof ActorSelectionMessage) {
                ActorSelectionMessage sel = (ActorSelectionMessage)object;
                this.receiveSelection(sel);
            } else if (object instanceof Identify) {
                Object object2;
                Identify identify = Identify$.MODULE$.unapply((Identify)object);
                Object messageId = object2 = identify._1();
                ScalaActorRef scalaActorRef = ActorRef$.MODULE$.actorRef2Scala(this.sender());
                ActorIdentity actorIdentity = ActorIdentity$.MODULE$.apply(messageId, (Option<ActorRef>)Some$.MODULE$.apply((Object)this.self()));
                scalaActorRef.$bang(actorIdentity, scalaActorRef.$bang$default$2(actorIdentity));
            } else {
                throw new MatchError(object);
            }
        }
    }

    private void receiveSelection(ActorSelectionMessage sel) {
        if (sel.elements().isEmpty()) {
            this.invoke(Envelope$.MODULE$.apply(sel.msg(), this.sender(), this.system()));
        } else {
            ActorSelection$.MODULE$.deliverSelection(this.self(), this.sender(), sel);
        }
    }

    public final void receiveMessage(Object msg) {
        this.actor().aroundReceive((PartialFunction)this.behaviorStack.head(), msg);
    }

    @Override
    public final ActorRef sender() {
        Envelope msg;
        Envelope envelope = this.currentMessage();
        ActorRef actorRef = envelope == null ? this.system().deadLetters() : ((msg = envelope).sender() != null ? msg.sender() : this.system().deadLetters());
        return actorRef;
    }

    @Override
    public void become(PartialFunction behavior, boolean discardOld) {
        this.behaviorStack = (discardOld && this.behaviorStack.nonEmpty() ? (List)this.behaviorStack.tail() : this.behaviorStack).$colon$colon((Object)behavior);
    }

    public boolean become$default$2() {
        return true;
    }

    public void become(Procedure<Object> behavior) {
        this.become(behavior, true);
    }

    public void become(Procedure<Object> behavior, boolean discardOld) {
        this.become((PartialFunction)new Serializable(behavior){
            private final Procedure behavior$1;
            {
                this.behavior$1 = behavior$2;
            }

            public final boolean isDefinedAt(Object x) {
                Object object;
                Object msg = object = x;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object msg = object = x;
                this.behavior$1.apply(msg);
                return BoxedUnit.UNIT;
            }
        }, discardOld);
    }

    @Override
    public void unbecome() {
        List list;
        List<PartialFunction<Object, BoxedUnit>> original = this.behaviorStack;
        if (original.isEmpty() || ((List)original.tail()).isEmpty()) {
            PartialFunction partialFunction = this.actor().receive();
            list = ActorCell$.MODULE$.emptyBehaviorStack().$colon$colon((Object)partialFunction);
        } else {
            list = (List)original.tail();
        }
        this.behaviorStack = list;
    }

    /*
     * WARNING - void declaration
     */
    public Actor newActor() {
        void v2;
        ActorCell$.MODULE$.contextStack().set((List<ActorContext>)ActorCell$.MODULE$.contextStack().get().$colon$colon((Object)this));
        try {
            void var1_1;
            List list;
            this.behaviorStack = ActorCell$.MODULE$.emptyBehaviorStack();
            Actor instance = this.props().newActor();
            if (instance == null) {
                InternalActorRef internalActorRef = this.self();
                ActorInitializationException$.MODULE$.apply$default$3();
                throw ActorInitializationException$.MODULE$.apply(internalActorRef, "Actor instance passed to actorOf can't be 'null'", null);
            }
            if (this.behaviorStack.isEmpty()) {
                PartialFunction partialFunction = instance.receive();
                list = this.behaviorStack.$colon$colon((Object)partialFunction);
            } else {
                list = this.behaviorStack;
            }
            this.behaviorStack = list;
            this._actor = instance;
            v2 = var1_1;
        }
        catch (Throwable throwable) {
            List<ActorContext> stackAfter = ActorCell$.MODULE$.contextStack().get();
            if (stackAfter.nonEmpty()) {
                ActorCell$.MODULE$.contextStack().set((List<ActorContext>)(stackAfter.head() == null ? ((IterableOps)stackAfter.tail()).tail() : stackAfter.tail()));
            }
            throw throwable;
        }
        List<ActorContext> stackAfter = ActorCell$.MODULE$.contextStack().get();
        if (stackAfter.nonEmpty()) {
            ActorCell$.MODULE$.contextStack().set((List<ActorContext>)(stackAfter.head() == null ? ((IterableOps)stackAfter.tail()).tail() : stackAfter.tail()));
        }
        return v2;
    }

    public void create(Option<ActorInitializationException> failure) {
        failure.foreach((Function1)(JFunction1 & Serializable)_$3 -> {
            throw _$3;
        });
        try {
            Actor created = this.newActor();
            created.aroundPreStart();
            this.checkReceiveTimeout(true);
            if (this.system().settings().DebugLifecycle()) {
                this.publish(Logging$Debug$.MODULE$.apply(this.self().path().toString(), this.clazz(created), "started (" + created + ")"));
            }
        }
        catch (InterruptedException e) {
            this.failActor$1();
            Thread.currentThread().interrupt();
            throw ActorInitializationException$.MODULE$.apply(this.self(), "interruption during creation", e);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.failActor$1();
                Throwable throwable4 = e;
                if (throwable4 instanceof InstantiationException) {
                    InstantiationException i = (InstantiationException)throwable4;
                    throw ActorInitializationException$.MODULE$.apply(this.self(), "exception during creation, this problem is likely to occur because the class of the Actor you tried to create is either,\n               a non-static inner class (in which case make it a static inner class or use Props(new ...) or Props( new Creator ... )\n               or is missing an appropriate, reachable no-args constructor.\n              ", i.getCause());
                }
                Throwable x = throwable4;
                throw ActorInitializationException$.MODULE$.apply(this.self(), "exception during creation", x);
            }
            throw throwable;
        }
    }

    private void supervise(ActorRef child, boolean async) {
        if (!this.isTerminating()) {
            Option option = this.initChild(child);
            if (option instanceof Some) {
                this.handleSupervise(child, async);
                if (this.system().settings().DebugLifecycle()) {
                    this.publish(Logging$Debug$.MODULE$.apply(this.self().path().toString(), this.clazz(this.actor()), "now supervising " + child));
                }
            } else if (None$.MODULE$.equals(option)) {
                this.publish(Logging$Error$.MODULE$.apply(this.self().path().toString(), this.clazz(this.actor()), "received Supervise from unregistered child " + child + ", this will not end well"));
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public void handleSupervise(ActorRef child, boolean async) {
        block1: {
            ActorRef actorRef = child;
            if (!(actorRef instanceof RepointableActorRef)) break block1;
            RepointableActorRef r = (RepointableActorRef)actorRef;
            if (async) {
                r.point(true);
            }
        }
    }

    @InternalStableApi
    public final void clearActorFields(Actor actorInstance, boolean recreate) {
        this.currentMessage_$eq(null);
        this.behaviorStack = ActorCell$.MODULE$.emptyBehaviorStack();
    }

    public final void clearFieldsForTermination() {
        this.unstashAll();
        this._props = ActorCell$.MODULE$.terminatedProps();
        this._actor = null;
    }

    public final void publish(Logging.LogEvent e) {
        try {
            this.system().eventStream().publish(e);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
            }
            throw throwable;
        }
    }

    public final Class<?> clazz(Object o) {
        return o == null ? this.getClass() : o.getClass();
    }

    private final int calculateState$1() {
        return this.waitingForChildrenOrNull() != null ? 2 : (this.mailbox().isSuspended() ? 1 : 0);
    }

    private final void sendAllToDeadLetters$1(SystemMessage messages) {
        SystemMessage systemMessage = messages;
        while (EarliestFirstSystemMessageList$.MODULE$.nonEmpty$extension(systemMessage)) {
            SystemMessage tail = new EarliestFirstSystemMessageList(EarliestFirstSystemMessageList$.MODULE$.tail$extension(systemMessage)).head();
            SystemMessage msg = systemMessage;
            msg.unlink();
            ScalaActorRef scalaActorRef = ActorRef$.MODULE$.actorRef2Scala(this.provider().deadLetters());
            scalaActorRef.$bang(msg, scalaActorRef.$bang$default$2(msg));
            systemMessage = tail;
        }
    }

    private static final boolean shouldStash$1(SystemMessage m, int state) {
        boolean bl;
        int n = state;
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = m instanceof StashWhenFailed;
                break;
            }
            case 2: {
                bl = m instanceof StashWhenWaitingForChildren;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return bl;
    }

    private final void invokeAll$1(SystemMessage messages, int currentState) {
        int n = currentState;
        SystemMessage systemMessage = messages;
        while (true) {
            SystemMessage todo;
            SystemMessage rest = new EarliestFirstSystemMessageList(EarliestFirstSystemMessageList$.MODULE$.tail$extension(systemMessage)).head();
            SystemMessage message = systemMessage;
            message.unlink();
            try {
                SystemMessage message2;
                SystemMessage systemMessage2 = message;
                if (systemMessage2 != null && ActorCell.shouldStash$1(message2 = systemMessage2, n)) {
                    this.stash(message2);
                } else if (systemMessage2 instanceof Failed) {
                    Failed f = (Failed)systemMessage2;
                    this.handleFailure(f);
                } else if (systemMessage2 instanceof DeathWatchNotification) {
                    DeathWatchNotification deathWatchNotification = DeathWatchNotification$.MODULE$.unapply((DeathWatchNotification)systemMessage2);
                    ActorRef actorRef = deathWatchNotification._1();
                    boolean bl = deathWatchNotification._2();
                    boolean bl2 = deathWatchNotification._3();
                    ActorRef a = actorRef;
                    boolean ec = bl;
                    boolean at = bl2;
                    this.watchedActorTerminated(a, ec, at);
                } else if (systemMessage2 instanceof Create) {
                    Option<ActorInitializationException> option;
                    Create create = Create$.MODULE$.unapply((Create)systemMessage2);
                    Option<ActorInitializationException> failure = option = create._1();
                    this.create(failure);
                } else if (systemMessage2 instanceof Watch) {
                    Watch watch = Watch$.MODULE$.unapply((Watch)systemMessage2);
                    InternalActorRef internalActorRef = watch._1();
                    InternalActorRef internalActorRef2 = watch._2();
                    InternalActorRef watchee = internalActorRef;
                    InternalActorRef watcher = internalActorRef2;
                    this.addWatcher(watchee, watcher);
                } else if (systemMessage2 instanceof Unwatch) {
                    Unwatch unwatch = Unwatch$.MODULE$.unapply((Unwatch)systemMessage2);
                    ActorRef actorRef = unwatch._1();
                    ActorRef actorRef2 = unwatch._2();
                    ActorRef watchee = actorRef;
                    ActorRef watcher = actorRef2;
                    this.remWatcher(watchee, watcher);
                } else if (systemMessage2 instanceof Recreate) {
                    Throwable throwable;
                    Recreate recreate = Recreate$.MODULE$.unapply((Recreate)systemMessage2);
                    Throwable cause = throwable = recreate._1();
                    this.faultRecreate(cause);
                } else if (systemMessage2 instanceof Suspend && Suspend$.MODULE$.unapply((Suspend)systemMessage2)) {
                    this.faultSuspend();
                } else if (systemMessage2 instanceof Resume) {
                    Throwable throwable;
                    Resume resume = Resume$.MODULE$.unapply((Resume)systemMessage2);
                    Throwable inRespToFailure = throwable = resume._1();
                    this.faultResume(inRespToFailure);
                } else if (systemMessage2 instanceof Terminate && Terminate$.MODULE$.unapply((Terminate)systemMessage2)) {
                    this.terminate();
                } else if (systemMessage2 instanceof Supervise) {
                    Supervise supervise = Supervise$.MODULE$.unapply((Supervise)systemMessage2);
                    ActorRef actorRef = supervise._1();
                    boolean bl = supervise._2();
                    ActorRef child = actorRef;
                    boolean async = bl;
                    this.supervise(child, async);
                } else if (!NoMessage$.MODULE$.equals(systemMessage2)) {
                    throw new MatchError((Object)systemMessage2);
                }
            }
            catch (Throwable ex$) {
                PartialFunction $2$ = this.handleNonFatalOrInterruptedException((Function1)(JProcedure1 & Serializable)e -> this.handleInvokeFailure((Iterable)package$.MODULE$.Nil(), (Throwable)e));
                if ($2$.isDefinedAt((Object)ex$)) {
                    $2$.apply((Object)ex$);
                }
                throw ex$;
            }
            int newState = this.calculateState$1();
            SystemMessage systemMessage3 = todo = newState < n ? EarliestFirstSystemMessageList$.MODULE$.reversePrepend$extension(rest, this.unstashAll()) : rest;
            if (this.isTerminated()) {
                this.sendAllToDeadLetters$1(todo);
                break;
            }
            if (!EarliestFirstSystemMessageList$.MODULE$.nonEmpty$extension(todo)) break;
            SystemMessage systemMessage4 = todo;
            int n2 = newState;
            systemMessage = systemMessage4;
            n = n2;
        }
    }

    private final void failActor$1() {
        if (this._actor != null) {
            this.clearActorFields(this.actor(), false);
            this.setFailedFatally();
            this._actor = null;
        }
    }
}

