/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.Address$;
import akka.annotation.InternalApi;
import dotty.runtime.LazyVals$;
import dotty.runtime.function.JFunction1;
import java.io.Serializable;
import java.util.Optional;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;
import scala.util.matching.Regex;

public final class Address
implements Product,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(Address.class, "bitmap$0");
    public long bitmap$0;
    private final String protocol;
    private final String system;
    private final Option host;
    private final Option port;
    public int hashCode$lzy1;
    public String toString$lzy1;

    public static Regex InvalidHostRegex() {
        return Address$.MODULE$.InvalidHostRegex();
    }

    public static Ordering addressOrdering() {
        return Address$.MODULE$.addressOrdering();
    }

    public static Address apply(String string, String string2) {
        return Address$.MODULE$.apply(string, string2);
    }

    public static Address apply(String string, String string2, Option<String> option, Option<Object> option2) {
        return Address$.MODULE$.apply(string, string2, option, option2);
    }

    public static Address apply(String string, String string2, String string3, int n) {
        return Address$.MODULE$.apply(string, string2, string3, n);
    }

    public static Address fromProduct(Product product) {
        return Address$.MODULE$.fromProduct(product);
    }

    public static Address unapply(Address address) {
        return Address$.MODULE$.unapply(address);
    }

    public Address(String protocol, String system, Option<String> host, Option<Object> port) {
        this.protocol = protocol;
        this.system = system;
        this.host = host;
        this.port = port;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Address)) return false;
        Address address = (Address)object;
        String string = this.protocol();
        String string2 = address.protocol();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.system();
        String string4 = address.system();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<String> option = this.host();
        Option<String> option2 = address.host();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.port();
        Option<Object> option4 = address.port();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof Address;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "Address";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "protocol";
                break;
            }
            case 1: {
                string = "system";
                break;
            }
            case 2: {
                string = "host";
                break;
            }
            case 3: {
                string = "port";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public String protocol() {
        return this.protocol;
    }

    public String system() {
        return this.system;
    }

    public Option<String> host() {
        return this.host;
    }

    public Option<Object> port() {
        return this.port;
    }

    public Address(String protocol, String system) {
        this(protocol, system, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    public Address(String protocol, String system, String host, int port) {
        this(protocol, system, (Option<String>)Option$.MODULE$.apply((Object)host), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)port)));
    }

    public Optional<String> getHost() {
        Option option = OptionConverters$.MODULE$.RichOptionForJava8(this.host());
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(option);
    }

    public Optional<Integer> getPort() {
        Option option = OptionConverters$.MODULE$.RichOptionForJava8(this.port());
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(option);
    }

    public boolean hasLocalScope() {
        return this.host().isEmpty();
    }

    public boolean hasGlobalScope() {
        return this.host().isDefined();
    }

    public int hashCode() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    int n;
                    this.hashCode$lzy1 = n = MurmurHash3$.MODULE$.productHash((Product)this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return n;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.hashCode$lzy1;
    }

    public String toString() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    String string;
                    StringBuilder sb = new StringBuilder(this.protocol()).append("://").append(this.system());
                    if (this.host().isDefined()) {
                        sb.append('@').append((String)this.host().get());
                    }
                    if (this.port().isDefined()) {
                        sb.append(':').append(BoxesRunTime.unboxToInt((Object)this.port().get()));
                    }
                    this.toString$lzy1 = string = sb.toString();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return string;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.toString$lzy1;
    }

    public String hostPort() {
        return this.toString().substring(this.protocol().length() + 3);
    }

    @InternalApi
    public boolean hasInvalidHostCharacters() {
        return this.host().exists((Function1)(JFunction1 & Serializable)_$1 -> Address$.MODULE$.InvalidHostRegex().findFirstIn((CharSequence)_$1).nonEmpty());
    }

    @InternalApi
    public void checkHostCharacters() {
        Predef$.MODULE$.require(!this.hasInvalidHostCharacters(), this::checkHostCharacters$$anonfun$1);
    }

    public Address copy(String protocol, String system, Option<String> host, Option<Object> port) {
        return new Address(protocol, system, host, port);
    }

    public String copy$default$1() {
        return this.protocol();
    }

    public String copy$default$2() {
        return this.system();
    }

    public Option<String> copy$default$3() {
        return this.host();
    }

    public Option<Object> copy$default$4() {
        return this.port();
    }

    public String _1() {
        return this.protocol();
    }

    public String _2() {
        return this.system();
    }

    public Option<String> _3() {
        return this.host();
    }

    public Option<Object> _4() {
        return this.port();
    }

    private final String checkHostCharacters$$anonfun$1() {
        return "Using invalid host characters '" + this.host() + "' in the Address is not allowed.";
    }
}

