/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorRef;
import akka.actor.ChildRestartStats$;
import akka.actor.ChildStats;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ChildRestartStats
implements ChildStats,
Product,
Serializable {
    private final ActorRef child;
    private int maxNrOfRetriesCount;
    private long restartTimeWindowStartNanos;

    public static ChildRestartStats apply(ActorRef actorRef, int n, long l) {
        return ChildRestartStats$.MODULE$.apply(actorRef, n, l);
    }

    public static Function1 curried() {
        return ChildRestartStats$.MODULE$.curried();
    }

    public static ChildRestartStats fromProduct(Product product) {
        return ChildRestartStats$.MODULE$.fromProduct(product);
    }

    public static Function1 tupled() {
        return ChildRestartStats$.MODULE$.tupled();
    }

    public static ChildRestartStats unapply(ChildRestartStats childRestartStats) {
        return ChildRestartStats$.MODULE$.unapply(childRestartStats);
    }

    public static int $lessinit$greater$default$2() {
        return ChildRestartStats$.MODULE$.$lessinit$greater$default$2();
    }

    public static long $lessinit$greater$default$3() {
        return ChildRestartStats$.MODULE$.$lessinit$greater$default$3();
    }

    public ChildRestartStats(ActorRef child, int maxNrOfRetriesCount, long restartTimeWindowStartNanos) {
        this.child = child;
        this.maxNrOfRetriesCount = maxNrOfRetriesCount;
        this.restartTimeWindowStartNanos = restartTimeWindowStartNanos;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.child()));
        n = Statics.mix((int)n, (int)this.maxNrOfRetriesCount());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.restartTimeWindowStartNanos()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ChildRestartStats)) return false;
        ChildRestartStats childRestartStats = (ChildRestartStats)object;
        if (this.maxNrOfRetriesCount() != childRestartStats.maxNrOfRetriesCount()) return false;
        if (this.restartTimeWindowStartNanos() != childRestartStats.restartTimeWindowStartNanos()) return false;
        ActorRef actorRef = this.child();
        ActorRef actorRef2 = childRestartStats.child();
        if (actorRef != null) {
            if (!((Object)actorRef).equals(actorRef2)) return false;
            return true;
        }
        if (actorRef2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ChildRestartStats;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "ChildRestartStats";
    }

    public Object productElement(int n) {
        Comparable<ActorRef> comparable;
        int n2 = n;
        switch (n2) {
            case 0: {
                comparable = this._1();
                break;
            }
            case 1: {
                comparable = BoxesRunTime.boxToInteger((int)this._2());
                break;
            }
            case 2: {
                comparable = BoxesRunTime.boxToLong((long)this._3());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return comparable;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "maxNrOfRetriesCount";
                break;
            }
            case 2: {
                string = "restartTimeWindowStartNanos";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public ActorRef child() {
        return this.child;
    }

    public int maxNrOfRetriesCount() {
        return this.maxNrOfRetriesCount;
    }

    public void maxNrOfRetriesCount_$eq(int x$1) {
        this.maxNrOfRetriesCount = x$1;
    }

    public long restartTimeWindowStartNanos() {
        return this.restartTimeWindowStartNanos;
    }

    public void restartTimeWindowStartNanos_$eq(long x$1) {
        this.restartTimeWindowStartNanos = x$1;
    }

    public int uid() {
        return this.child().path().uid();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requestRestartPermission(Tuple2<Option<Object>, Option<Object>> retriesWindow) {
        Tuple2<Option<Object>, Option<Object>> tuple2 = retriesWindow;
        if (tuple2 == null) throw new MatchError(tuple2);
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (option instanceof Some) {
            int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            int retries = n;
            if (retries < 1) {
                return false;
            }
            int retries2 = n;
            if (None$.MODULE$.equals(option2)) {
                this.maxNrOfRetriesCount_$eq(this.maxNrOfRetriesCount() + 1);
                if (this.maxNrOfRetriesCount() > retries2) return false;
                return true;
            }
        }
        Option x = option;
        if (!(option2 instanceof Some)) {
            if (!None$.MODULE$.equals(option)) throw new MatchError(tuple2);
            return true;
        }
        int window = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
        boolean bl = this.retriesInWindowOkay(x.isDefined() ? BoxesRunTime.unboxToInt((Object)x.get()) : 1, window);
        return bl;
    }

    private boolean retriesInWindowOkay(int retries, int window) {
        boolean bl;
        boolean insideWindow;
        long l;
        int retriesDone = this.maxNrOfRetriesCount() + 1;
        long now = System.nanoTime();
        if (this.restartTimeWindowStartNanos() == 0L) {
            this.restartTimeWindowStartNanos_$eq(now);
            l = now;
        } else {
            l = this.restartTimeWindowStartNanos();
        }
        long windowStart = l;
        boolean bl2 = insideWindow = now - windowStart <= TimeUnit.MILLISECONDS.toNanos(Int$.MODULE$.int2long(window));
        if (insideWindow) {
            this.maxNrOfRetriesCount_$eq(retriesDone);
            bl = retriesDone <= retries;
        } else {
            this.maxNrOfRetriesCount_$eq(1);
            this.restartTimeWindowStartNanos_$eq(now);
            bl = true;
        }
        return bl;
    }

    public ChildRestartStats copy(ActorRef child, int maxNrOfRetriesCount, long restartTimeWindowStartNanos) {
        return new ChildRestartStats(child, maxNrOfRetriesCount, restartTimeWindowStartNanos);
    }

    public ActorRef copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.maxNrOfRetriesCount();
    }

    public long copy$default$3() {
        return this.restartTimeWindowStartNanos();
    }

    public ActorRef _1() {
        return this.child();
    }

    public int _2() {
        return this.maxNrOfRetriesCount();
    }

    public long _3() {
        return this.restartTimeWindowStartNanos();
    }
}

