/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.Done;
import akka.Done$;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$ActorSystemTerminateReason$;
import akka.actor.CoordinatedShutdown$ClusterDowningReason$;
import akka.actor.CoordinatedShutdown$ClusterJoinUnsuccessfulReason$;
import akka.actor.CoordinatedShutdown$ClusterLeavingReason$;
import akka.actor.CoordinatedShutdown$IncompatibleConfigurationDetectedReason$;
import akka.actor.CoordinatedShutdown$JvmExitReason$;
import akka.actor.CoordinatedShutdown$Phase$;
import akka.actor.CoordinatedShutdown$UnknownReason$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.actor.ExtensionIdProvider;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class CoordinatedShutdown$
implements ExtensionId<CoordinatedShutdown>,
ExtensionIdProvider,
Serializable {
    public static final CoordinatedShutdown$ MODULE$;
    private final String PhaseBeforeServiceUnbind;
    private final String PhaseServiceUnbind;
    private final String PhaseServiceRequestsDone;
    private final String PhaseServiceStop;
    private final String PhaseBeforeClusterShutdown;
    private final String PhaseClusterShardingShutdownRegion;
    private final String PhaseClusterLeave;
    private final String PhaseClusterExiting;
    private final String PhaseClusterExitingDone;
    private final String PhaseClusterShutdown;
    private final String PhaseBeforeActorSystemTerminate;
    private final String PhaseActorSystemTerminate;
    public final CoordinatedShutdown$UnknownReason$ UnknownReason;
    public final CoordinatedShutdown$ActorSystemTerminateReason$ ActorSystemTerminateReason;
    public final CoordinatedShutdown$JvmExitReason$ JvmExitReason;
    public final CoordinatedShutdown$ClusterDowningReason$ ClusterDowningReason;
    public final CoordinatedShutdown$ClusterJoinUnsuccessfulReason$ ClusterJoinUnsuccessfulReason;
    public final CoordinatedShutdown$IncompatibleConfigurationDetectedReason$ IncompatibleConfigurationDetectedReason;
    public final CoordinatedShutdown$ClusterLeavingReason$ ClusterLeavingReason;
    public volatile boolean akka$actor$CoordinatedShutdown$$$runningJvmHook;
    public final CoordinatedShutdown$Phase$ Phase;

    static {
        new CoordinatedShutdown$();
    }

    private CoordinatedShutdown$() {
        MODULE$ = this;
        this.PhaseBeforeServiceUnbind = "before-service-unbind";
        this.PhaseServiceUnbind = "service-unbind";
        this.PhaseServiceRequestsDone = "service-requests-done";
        this.PhaseServiceStop = "service-stop";
        this.PhaseBeforeClusterShutdown = "before-cluster-shutdown";
        this.PhaseClusterShardingShutdownRegion = "cluster-sharding-shutdown-region";
        this.PhaseClusterLeave = "cluster-leave";
        this.PhaseClusterExiting = "cluster-exiting";
        this.PhaseClusterExitingDone = "cluster-exiting-done";
        this.PhaseClusterShutdown = "cluster-shutdown";
        this.PhaseBeforeActorSystemTerminate = "before-actor-system-terminate";
        this.PhaseActorSystemTerminate = "actor-system-terminate";
        this.akka$actor$CoordinatedShutdown$$$runningJvmHook = false;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CoordinatedShutdown$.class);
    }

    public String PhaseBeforeServiceUnbind() {
        return this.PhaseBeforeServiceUnbind;
    }

    public String PhaseServiceUnbind() {
        return this.PhaseServiceUnbind;
    }

    public String PhaseServiceRequestsDone() {
        return this.PhaseServiceRequestsDone;
    }

    public String PhaseServiceStop() {
        return this.PhaseServiceStop;
    }

    public String PhaseBeforeClusterShutdown() {
        return this.PhaseBeforeClusterShutdown;
    }

    public String PhaseClusterShardingShutdownRegion() {
        return this.PhaseClusterShardingShutdownRegion;
    }

    public String PhaseClusterLeave() {
        return this.PhaseClusterLeave;
    }

    public String PhaseClusterExiting() {
        return this.PhaseClusterExiting;
    }

    public String PhaseClusterExitingDone() {
        return this.PhaseClusterExitingDone;
    }

    public String PhaseClusterShutdown() {
        return this.PhaseClusterShutdown;
    }

    public String PhaseBeforeActorSystemTerminate() {
        return this.PhaseBeforeActorSystemTerminate;
    }

    public String PhaseActorSystemTerminate() {
        return this.PhaseActorSystemTerminate;
    }

    public CoordinatedShutdown.Reason unknownReason() {
        return CoordinatedShutdown$UnknownReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason actorSystemTerminateReason() {
        return CoordinatedShutdown$ActorSystemTerminateReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason jvmExitReason() {
        return CoordinatedShutdown$JvmExitReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterDowningReason() {
        return CoordinatedShutdown$ClusterDowningReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterJoinUnsuccessfulReason() {
        return CoordinatedShutdown$ClusterJoinUnsuccessfulReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason incompatibleConfigurationDetectedReason() {
        return CoordinatedShutdown$IncompatibleConfigurationDetectedReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterLeavingReason() {
        return CoordinatedShutdown$ClusterLeavingReason$.MODULE$;
    }

    @Override
    public CoordinatedShutdown get(ActorSystem system) {
        return (CoordinatedShutdown)ExtensionId.super.get(system);
    }

    @Override
    public CoordinatedShutdown get(ClassicActorSystemProvider system) {
        return (CoordinatedShutdown)ExtensionId.super.get(system);
    }

    @Override
    public ExtensionId<? extends Extension> lookup() {
        return this;
    }

    @Override
    public CoordinatedShutdown createExtension(ExtendedActorSystem system) {
        Config conf = system.settings().config().getConfig("akka.coordinated-shutdown");
        scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases = this.phasesFromConfig(conf);
        CoordinatedShutdown coord = new CoordinatedShutdown(system, phases);
        this.initPhaseActorSystemTerminate(system, conf, coord);
        this.initJvmHook(system, conf, coord);
        try {
            system.registerOnTermination(() -> this.createExtension$$anonfun$1(coord));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.cleanupActorSystemJvmHook$1(coord);
        }
        return coord;
    }

    @InternalApi
    public Config confWithOverrides(Config conf, Option<CoordinatedShutdown.Reason> reason) {
        return (Config)reason.flatMap((Function1)(JFunction1 & Serializable)r -> {
            String basePath = "reason-overrides.\"" + r.getClass().getName() + "\"";
            return conf.hasPath(basePath) ? Some$.MODULE$.apply((Object)conf.getConfig(basePath).withFallback((ConfigMergeable)conf)) : None$.MODULE$;
        }).getOrElse(() -> this.confWithOverrides$$anonfun$2(conf));
    }

    private void initPhaseActorSystemTerminate(ExtendedActorSystem system, Config conf, CoordinatedShutdown coord) {
        coord.addTask(this.PhaseActorSystemTerminate(), "terminate-system", (Function0<Future<Done>>)(Function0 & Serializable)() -> {
            Future future;
            Config confForReason = this.confWithOverrides(conf, coord.shutdownReason());
            boolean terminateActorSystem = confForReason.getBoolean("terminate-actor-system");
            boolean exitJvm = confForReason.getBoolean("exit-jvm");
            int exitCode = confForReason.getInt("exit-code");
            if (exitJvm && terminateActorSystem) {
                FiniteDuration timeout = coord.timeout(this.PhaseActorSystemTerminate());
                Thread t = new Thread(system, exitCode, timeout){
                    private final ExtendedActorSystem system$1;
                    private final int exitCode$1;
                    private final FiniteDuration timeout$1;
                    {
                        this.system$1 = system$4;
                        this.exitCode$1 = exitCode$3;
                        this.timeout$1 = timeout$4;
                    }

                    public void run() {
                        if (Try$.MODULE$.apply(this::run$$anonfun$1).isFailure() && !CoordinatedShutdown$.MODULE$.akka$actor$CoordinatedShutdown$$$runningJvmHook) {
                            System.exit(this.exitCode$1);
                        }
                    }

                    private final Future run$$anonfun$1() {
                        return (Future)Await$.MODULE$.ready(this.system$1.whenTerminated(), (Duration)this.timeout$1);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$1()}, serializedLambda);
                    }
                };
                t.setName("CoordinatedShutdown-exit");
                t.start();
            }
            if (terminateActorSystem) {
                system.finalTerminate();
                future = system.whenTerminated().map((Function1)(JFunction1 & Serializable)_$1 -> {
                    if (exitJvm && !this.akka$actor$CoordinatedShutdown$$$runningJvmHook) {
                        System.exit(exitCode);
                    }
                    return Done$.MODULE$;
                }, ExecutionContexts$.MODULE$.parasitic());
            } else if (exitJvm) {
                System.exit(exitCode);
                future = Future$.MODULE$.successful((Object)Done$.MODULE$);
            } else {
                future = Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            return future;
        });
    }

    private void initJvmHook(ActorSystem system, Config conf, CoordinatedShutdown coord) {
        boolean runByJvmShutdownHook;
        boolean bl = runByJvmShutdownHook = system.settings().JvmShutdownHooks() && conf.getBoolean("run-by-jvm-shutdown-hook");
        if (runByJvmShutdownHook) {
            coord.akka$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(OptionVal$Some$.MODULE$.apply(coord.addCancellableJvmShutdownHook(() -> this.initJvmHook$$anonfun$1(system, coord))));
        }
    }

    public scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phasesFromConfig(Config conf) {
        String defaultPhaseTimeout = conf.getString("default-phase-timeout");
        Config phasesConf = conf.getConfig("phases");
        Config defaultPhaseConfig = ConfigFactory.parseString((String)("\n      timeout = " + defaultPhaseTimeout + "\n      recover = true\n      enabled = true\n      depends-on = []\n    "));
        return (scala.collection.immutable.Map)package$JavaConverters$.MODULE$.MapHasAsScala(phasesConf.root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1)(JFunction1 & Serializable)x$1 -> {
            String k;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Object object = tuple2._2();
                k = string;
                if (!(object instanceof Map)) {
                    String k2 = string;
                    Object v = object;
                    throw new IllegalArgumentException("Expected object value for [" + k2 + "], got [" + v + "]");
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Config c = phasesConf.getConfig(k).withFallback((ConfigMergeable)defaultPhaseConfig);
            Set dependsOn = package$JavaConverters$.MODULE$.ListHasAsScala(c.getStringList("depends-on")).asScala().toSet();
            FiniteDuration timeout = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(c.getDuration("timeout", TimeUnit.MILLISECONDS))).millis();
            boolean recover = c.getBoolean("recover");
            boolean enabled = c.getBoolean("enabled");
            Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)CoordinatedShutdown$Phase$.MODULE$.apply((Set<String>)dependsOn, timeout, recover, enabled));
        });
    }

    public List<String> topologicalSort(scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases) {
        ObjectRef result = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef unmarked = ObjectRef.create((Object)((Set)phases.keySet().$plus$plus((IterableOnce)phases.values().flatMap((Function1)(JFunction1 & Serializable)_$2 -> _$2.dependsOn()))));
        ObjectRef tempMark = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        while (((Set)unmarked.elem).nonEmpty()) {
            this.depthFirstSearch$1(phases, result, unmarked, tempMark, (String)((Set)unmarked.elem).head());
        }
        return ((List)result.elem).reverse();
    }

    private final void cleanupActorSystemJvmHook$1(CoordinatedShutdown coord$1) {
        block1: {
            Cancellable cancellable;
            Object object = coord$1.akka$actor$CoordinatedShutdown$$actorSystemJvmHook();
            Object object2 = OptionVal$Some$.MODULE$.unapply(object);
            if (OptionVal$.MODULE$.isEmpty$extension(object2)) break block1;
            Cancellable cancellable2 = cancellable = (Cancellable)OptionVal$.MODULE$.get$extension(object2);
            if (!this.akka$actor$CoordinatedShutdown$$$runningJvmHook && !cancellable2.isCancelled()) {
                cancellable2.cancel();
                coord$1.akka$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(OptionVal$.MODULE$.None());
            }
        }
    }

    private final void createExtension$$anonfun$1(CoordinatedShutdown coord$5) {
        this.cleanupActorSystemJvmHook$1(coord$5);
    }

    private final Config confWithOverrides$$anonfun$2(Config conf$2) {
        return conf$2;
    }

    private final void liftedTree3$1(CoordinatedShutdown coord$4) {
        try {
            FiniteDuration totalTimeout = coord$4.totalTimeout().max(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds());
            Await$.MODULE$.ready(coord$4.run(CoordinatedShutdown$JvmExitReason$.MODULE$), (Duration)totalTimeout);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                coord$4.log().warning("CoordinatedShutdown from JVM shutdown failed: {}", e.getMessage());
            }
            throw throwable;
        }
    }

    private final void initJvmHook$$anonfun$1(ActorSystem system$3, CoordinatedShutdown coord$3) {
        this.akka$actor$CoordinatedShutdown$$$runningJvmHook = true;
        if (!system$3.whenTerminated().isCompleted()) {
            coord$3.log().debug("Starting coordinated shutdown from JVM shutdown hook");
            this.liftedTree3$1(coord$3);
        }
    }

    private final void depthFirstSearch$1(scala.collection.immutable.Map phases$1, ObjectRef result$3, ObjectRef unmarked$1, ObjectRef tempMark$1, String u2) {
        if (((Set)tempMark$1.elem).apply((Object)u2)) {
            throw new IllegalArgumentException("Cycle detected in graph of phases. It must be a DAG. " + ("phase [" + u2 + "] depends transitively on itself. All dependencies: " + phases$1));
        }
        if (((Set)unmarked$1.elem).apply((Object)u2)) {
            Set set = (Set)((Set)tempMark$1.elem).$plus((Object)u2);
            tempMark$1.elem = set;
            Option option = phases$1.get((Object)u2);
            if (option instanceof Some) {
                CoordinatedShutdown.Phase p = (CoordinatedShutdown.Phase)((Some)option).value();
                p.dependsOn().foreach((Function1)(JProcedure1 & Serializable)u -> this.depthFirstSearch$1(phases$1, result$3, unmarked$1, tempMark$1, (String)u));
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
            Set set2 = (Set)((Set)unmarked$1.elem).$minus((Object)u2);
            unmarked$1.elem = set2;
            Set set3 = (Set)((Set)tempMark$1.elem).$minus((Object)u2);
            tempMark$1.elem = set3;
            List list = ((List)result$3.elem).$colon$colon((Object)u2);
            result$3.elem = list;
        }
    }
}

