/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.Actor$;
import akka.actor.ActorCell$;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorRefScope;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.AddressTerminated;
import akka.actor.AddressTerminated$;
import akka.actor.FunctionRef$;
import akka.actor.InternalActorRef;
import akka.actor.LocalRef;
import akka.actor.MinimalActorRef;
import akka.actor.Terminated$;
import akka.annotation.InternalApi;
import akka.dispatch.sysmsg.DeathWatchNotification;
import akka.dispatch.sysmsg.DeathWatchNotification$;
import akka.dispatch.sysmsg.SystemMessage;
import akka.dispatch.sysmsg.Unwatch;
import akka.dispatch.sysmsg.Unwatch$;
import akka.dispatch.sysmsg.Watch;
import akka.dispatch.sysmsg.Watch$;
import akka.event.AddressTerminatedTopic;
import akka.event.AddressTerminatedTopic$;
import akka.event.Logging;
import akka.event.Logging$Error$;
import akka.event.Logging$Warning$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@InternalApi
public final class FunctionRef
extends InternalActorRef
implements LocalRef,
MinimalActorRef {
    private final ActorPath path;
    private final ActorRefProvider provider;
    private final ActorSystem system;
    private Function2<ActorRef, Object, BoxedUnit> messageHandler;
    private Set<ActorRef> watching;
    private Set<ActorRef> _watchedBy;

    public static Function2<ActorRef, Object, BoxedUnit> deadLetterMessageHandler(ActorSystem actorSystem) {
        return FunctionRef$.MODULE$.deadLetterMessageHandler(actorSystem);
    }

    public FunctionRef(ActorPath path, ActorRefProvider provider, ActorSystem system, Function2<ActorRef, Object, BoxedUnit> f) {
        this.path = path;
        this.provider = provider;
        this.system = system;
        this.messageHandler = f;
        this.watching = ActorCell$.MODULE$.emptyActorRefSet();
        this._watchedBy = OptionVal$Some$.MODULE$.apply(ActorCell$.MODULE$.emptyActorRefSet());
    }

    @Override
    public ActorPath path() {
        return this.path;
    }

    @Override
    public ActorRefProvider provider() {
        return this.provider;
    }

    @Override
    public void $bang(Object message, ActorRef sender) {
        Object object = message;
        if (object instanceof AddressTerminated) {
            Address address;
            AddressTerminated addressTerminated = AddressTerminated$.MODULE$.unapply((AddressTerminated)object);
            Address address2 = address = addressTerminated._1();
            this.addressTerminated(address2);
        } else {
            this.messageHandler.apply((Object)sender, message);
        }
    }

    @Override
    public ActorRef $bang$default$2(Object message) {
        return Actor$.MODULE$.noSender();
    }

    @Override
    public void sendSystemMessage(SystemMessage message) {
        block1: {
            SystemMessage systemMessage;
            block2: {
                block0: {
                    systemMessage = message;
                    if (!(systemMessage instanceof Watch)) break block0;
                    Watch w = (Watch)systemMessage;
                    this.addWatcher(w.watchee(), w.watcher());
                    break block1;
                }
                if (!(systemMessage instanceof Unwatch)) break block2;
                Unwatch u = (Unwatch)systemMessage;
                this.remWatcher(u.watchee(), u.watcher());
                break block1;
            }
            if (!(systemMessage instanceof DeathWatchNotification)) break block1;
            DeathWatchNotification deathWatchNotification = DeathWatchNotification$.MODULE$.unapply((DeathWatchNotification)systemMessage);
            ActorRef actorRef = deathWatchNotification._1();
            boolean bl = deathWatchNotification._2();
            boolean bl2 = deathWatchNotification._3();
            ActorRef actorRef2 = actorRef;
            this.$bang(Terminated$.MODULE$.apply(actorRef2, true, false), actorRef2);
        }
    }

    @Override
    @InternalApi
    public boolean isTerminated() {
        Set<ActorRef> set = this._watchedBy;
        return OptionVal$.MODULE$.isEmpty$extension(set);
    }

    public void sendTerminated() {
        Tuple2 tuple2;
        FunctionRef functionRef = this;
        synchronized (functionRef) {
            Tuple2 tuple22;
            Set<ActorRef> set = this._watchedBy;
            Set<ActorRef> set2 = OptionVal$Some$.MODULE$.unapply(set);
            if (!OptionVal$.MODULE$.isEmpty$extension(set2)) {
                Set<ActorRef> set3;
                Set<ActorRef> wBy = set3 = OptionVal$.MODULE$.get$extension(set2);
                Set<ActorRef> oldWatching = this.watching;
                this.watching = Predef$.MODULE$.Set().empty();
                this.unsubscribeAddressTerminated();
                this._watchedBy = OptionVal$.MODULE$.None();
                tuple22 = Tuple2$.MODULE$.apply(oldWatching, wBy);
            } else {
                OptionVal<Object> optionVal = new OptionVal<Object>(OptionVal$.MODULE$.None());
                OptionVal<Set<ActorRef>> optionVal2 = new OptionVal<Set<ActorRef>>(set);
                if (!(optionVal != null ? !((Object)optionVal).equals(optionVal2) : optionVal2 != null)) {
                    tuple22 = Tuple2$.MODULE$.apply(ActorCell$.MODULE$.emptyActorRefSet(), ActorCell$.MODULE$.emptyActorRefSet());
                } else {
                    throw new MatchError(new OptionVal<Set<ActorRef>>(set));
                }
            }
            tuple2 = tuple22;
        }
        Tuple2 tuple23 = tuple2;
        if (!(tuple23 instanceof Tuple2)) {
            throw new MatchError((Object)tuple23);
        }
        Tuple2 tuple24 = tuple23;
        Set toUnwatch = (Set)tuple24._1();
        Set watchedBy = (Set)tuple24._2();
        Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)toUnwatch, (Object)watchedBy);
        Set toUnwatch2 = (Set)tuple25._1();
        Set watchedBy2 = (Set)tuple25._2();
        if (toUnwatch2.nonEmpty()) {
            toUnwatch2.foreach((Function1)(JProcedure1 & Serializable)watched -> this.unwatchWatched$1((ActorRef)watched));
        }
        if (watchedBy2.nonEmpty()) {
            watchedBy2.foreach((Function1)(JProcedure1 & Serializable)watcher -> this.sendTerminated(false, (ActorRef)watcher));
            watchedBy2.foreach((Function1)(JProcedure1 & Serializable)watcher -> this.sendTerminated(true, (ActorRef)watcher));
        }
    }

    private void sendTerminated(boolean ifLocal, ActorRef watcher) {
        if (((ActorRefScope)((Object)watcher)).isLocal() == ifLocal) {
            ((InternalActorRef)watcher).sendSystemMessage(DeathWatchNotification$.MODULE$.apply(this, true, false));
        }
    }

    private void addressTerminated(Address address) {
        Set<ActorRef> set;
        FunctionRef functionRef = this;
        synchronized (functionRef) {
            Set<ActorRef> set2;
            Set<ActorRef> set3 = this._watchedBy;
            OptionVal<Object> optionVal = new OptionVal<Object>(OptionVal$.MODULE$.None());
            OptionVal<Set<ActorRef>> optionVal2 = new OptionVal<Set<ActorRef>>(set3);
            if (!(optionVal != null ? !((Object)optionVal).equals(optionVal2) : optionVal2 != null)) {
                set2 = ActorCell$.MODULE$.emptyActorRefSet();
            } else {
                Set<ActorRef> set4 = OptionVal$Some$.MODULE$.unapply(set3);
                if (!OptionVal$.MODULE$.isEmpty$extension(set4)) {
                    Set<ActorRef> set5;
                    Set<ActorRef> watchedBy = set5 = OptionVal$.MODULE$.get$extension(set4);
                    this.maintainAddressTerminatedSubscription(OptionVal$.MODULE$.None(), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$1(address, watchedBy)));
                    set2 = this.watching;
                } else {
                    throw new MatchError(new OptionVal<Set<ActorRef>>(set3));
                }
            }
            set = set2;
        }
        Set<ActorRef> toNotify = set;
        toNotify.withFilter((Function1)(JFunction1 & Serializable)a -> {
            Address address = a.path().address();
            Address address2 = address;
            return !(address != null ? !((Object)address).equals(address2) : address2 != null);
        }).foreach((Function1)(JProcedure1 & Serializable)a -> this.sendSystemMessage(DeathWatchNotification$.MODULE$.apply((ActorRef)a, false, true)));
    }

    @Override
    public void stop() {
        this.sendTerminated();
        this.messageHandler = FunctionRef$.MODULE$.deadLetterMessageHandler(this.system);
    }

    private void addWatcher(ActorRef watchee, ActorRef watcher) {
        boolean bl;
        FunctionRef functionRef = this;
        synchronized (functionRef) {
            boolean bl2;
            Set<ActorRef> set = this._watchedBy;
            OptionVal<Object> optionVal = new OptionVal<Object>(OptionVal$.MODULE$.None());
            OptionVal<Set<ActorRef>> optionVal2 = new OptionVal<Set<ActorRef>>(set);
            if (!(optionVal != null ? !((Object)optionVal).equals(optionVal2) : optionVal2 != null)) {
                bl2 = true;
            } else {
                Set<ActorRef> set2 = OptionVal$Some$.MODULE$.unapply(set);
                if (!OptionVal$.MODULE$.isEmpty$extension(set2)) {
                    boolean watcherSelf;
                    Set<ActorRef> set3;
                    Set<ActorRef> watchedBy = set3 = OptionVal$.MODULE$.get$extension(set2);
                    ActorRef actorRef = watchee;
                    FunctionRef functionRef2 = this;
                    boolean watcheeSelf = !(actorRef != null ? !((Object)actorRef).equals(functionRef2) : functionRef2 != null);
                    ActorRef actorRef2 = watcher;
                    FunctionRef functionRef3 = this;
                    boolean bl3 = !(actorRef2 != null ? !((Object)actorRef2).equals(functionRef3) : functionRef3 != null) ? true : (watcherSelf = false);
                    if (watcheeSelf && !watcherSelf) {
                        if (!watchedBy.contains((Object)watcher)) {
                            this.maintainAddressTerminatedSubscription(OptionVal$Some$.MODULE$.apply(watcher), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$2(watcher, watchedBy)));
                        }
                    } else if (!watcheeSelf && watcherSelf) {
                        this.publish(Logging$Warning$.MODULE$.apply(this.path().toString(), FunctionRef.class, "externally triggered watch from " + watcher + " to " + watchee + " is illegal on FunctionRef"));
                    } else {
                        this.publish(Logging$Error$.MODULE$.apply(this.path().toString(), FunctionRef.class, "BUG: illegal Watch(" + watchee + "," + watcher + ") for " + this));
                    }
                    bl2 = false;
                } else {
                    throw new MatchError(new OptionVal<Set<ActorRef>>(set));
                }
            }
            bl = bl2;
        }
        boolean selfTerminated = bl;
        if (selfTerminated) {
            this.sendTerminated(true, watcher);
            this.sendTerminated(false, watcher);
        }
    }

    private void remWatcher(ActorRef watchee, ActorRef watcher) {
        block14: {
            FunctionRef functionRef = this;
            synchronized (functionRef) {
                Set<ActorRef> set;
                block15: {
                    OptionVal<Set<ActorRef>> optionVal;
                    OptionVal<Object> optionVal2;
                    block13: {
                        set = this._watchedBy;
                        optionVal2 = new OptionVal<Object>(OptionVal$.MODULE$.None());
                        optionVal = new OptionVal<Set<ActorRef>>(set);
                        if (optionVal2 != null) break block13;
                        if (optionVal == null) break block14;
                        break block15;
                    }
                    if (((Object)optionVal2).equals(optionVal)) break block14;
                }
                Set<ActorRef> set2 = OptionVal$Some$.MODULE$.unapply(set);
                if (!OptionVal$.MODULE$.isEmpty$extension(set2)) {
                    boolean watcherSelf;
                    Set<ActorRef> set3;
                    Set<ActorRef> watchedBy = set3 = OptionVal$.MODULE$.get$extension(set2);
                    ActorRef actorRef = watchee;
                    FunctionRef functionRef2 = this;
                    boolean watcheeSelf = !(actorRef != null ? !((Object)actorRef).equals(functionRef2) : functionRef2 != null);
                    ActorRef actorRef2 = watcher;
                    FunctionRef functionRef3 = this;
                    boolean bl = !(actorRef2 != null ? !((Object)actorRef2).equals(functionRef3) : functionRef3 != null) ? true : (watcherSelf = false);
                    if (watcheeSelf && !watcherSelf) {
                        if (watchedBy.contains((Object)watcher)) {
                            this.maintainAddressTerminatedSubscription(OptionVal$Some$.MODULE$.apply(watcher), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.remWatcher$$anonfun$1(watcher, watchedBy)));
                        }
                    } else if (!watcheeSelf && watcherSelf) {
                        this.publish(Logging$Warning$.MODULE$.apply(this.path().toString(), FunctionRef.class, "externally triggered unwatch from " + watcher + " to " + watchee + " is illegal on FunctionRef"));
                    } else {
                        this.publish(Logging$Error$.MODULE$.apply(this.path().toString(), FunctionRef.class, "BUG: illegal Unwatch(" + watchee + "," + watcher + ") for " + this));
                    }
                } else {
                    throw new MatchError(new OptionVal<Set<ActorRef>>(set));
                }
            }
        }
    }

    private void publish(Logging.LogEvent e) {
        try {
            this.system.eventStream().publish(e);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
            }
            throw throwable;
        }
    }

    public void watch(ActorRef actorRef) {
        FunctionRef functionRef = this;
        synchronized (functionRef) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)this.maintainAddressTerminatedSubscription(OptionVal$Some$.MODULE$.apply(actorRef), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.watch$$anonfun$1(actorRef)));
        }
        ((InternalActorRef)actorRef).sendSystemMessage(Watch$.MODULE$.apply((InternalActorRef)actorRef, this));
    }

    public void unwatch(ActorRef actorRef) {
        FunctionRef functionRef = this;
        synchronized (functionRef) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)this.maintainAddressTerminatedSubscription(OptionVal$Some$.MODULE$.apply(actorRef), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.unwatch$$anonfun$1(actorRef)));
        }
        ((InternalActorRef)actorRef).sendSystemMessage(Unwatch$.MODULE$.apply((InternalActorRef)actorRef, this));
    }

    public boolean isWatching(ActorRef actorRef) {
        boolean bl;
        FunctionRef functionRef = this;
        synchronized (functionRef) {
            bl = this.watching.contains((Object)actorRef);
        }
        return bl;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private Object maintainAddressTerminatedSubscription(Object change, Function0 block) {
        Object object;
        ActorRef actorRef;
        ActorRef ref;
        Object object2 = change;
        Object object3 = OptionVal$Some$.MODULE$.unapply(object2);
        if (!OptionVal$.MODULE$.isEmpty$extension(object3) && !FunctionRef.isNonLocal$1(ref = (actorRef = (ActorRef)OptionVal$.MODULE$.get$extension(object3)))) {
            object = block.apply();
        } else {
            boolean had = this.hasNonLocalAddress$1();
            Object result = block.apply();
            boolean has = this.hasNonLocalAddress$1();
            if (had && !has) {
                this.unsubscribeAddressTerminated();
            } else if (!had && has) {
                this.subscribeAddressTerminated();
            }
            object = result;
        }
        return object;
    }

    private void unsubscribeAddressTerminated() {
        ((AddressTerminatedTopic)AddressTerminatedTopic$.MODULE$.apply(this.system)).unsubscribe(this);
    }

    private void subscribeAddressTerminated() {
        ((AddressTerminatedTopic)AddressTerminatedTopic$.MODULE$.apply(this.system)).subscribe(this);
    }

    private final void unwatchWatched$1(ActorRef watched) {
        ((InternalActorRef)watched).sendSystemMessage(Unwatch$.MODULE$.apply(watched, this));
    }

    private final void $anonfun$1(Address address$1, Set watchedBy$1) {
        this._watchedBy = OptionVal$Some$.MODULE$.apply(watchedBy$1.filterNot((Function1)(JFunction1 & Serializable)_$3 -> {
            Address address = _$3.path().address();
            Address address2 = address$1;
            return !(address != null ? !((Object)address).equals(address2) : address2 != null);
        }));
    }

    private final void $anonfun$2(ActorRef watcher$1, Set watchedBy$2) {
        this._watchedBy = OptionVal$Some$.MODULE$.apply(watchedBy$2.$plus((Object)watcher$1));
    }

    private final void remWatcher$$anonfun$1(ActorRef watcher$2, Set watchedBy$3) {
        this._watchedBy = OptionVal$Some$.MODULE$.apply(watchedBy$3.$minus((Object)watcher$2));
    }

    private final void watch$$anonfun$1(ActorRef actorRef$1) {
        this.watching = (Set)this.watching.$plus((Object)actorRef$1);
    }

    private final void unwatch$$anonfun$1(ActorRef actorRef$2) {
        this.watching = (Set)this.watching.$minus((Object)actorRef$2);
    }

    private static final boolean isNonLocal$1(ActorRef ref) {
        InternalActorRef a;
        ActorRef actorRef = ref;
        return actorRef instanceof InternalActorRef && !(a = (InternalActorRef)actorRef).isLocal();
    }

    private final Set watchedByOrEmpty$1() {
        Set<ActorRef> set;
        Set<ActorRef> set2 = this._watchedBy;
        Set<ActorRef> set3 = OptionVal$Some$.MODULE$.unapply(set2);
        if (!OptionVal$.MODULE$.isEmpty$extension(set3)) {
            Set<ActorRef> set4;
            Set<ActorRef> watchedBy;
            set = watchedBy = (set4 = OptionVal$.MODULE$.get$extension(set3));
        } else {
            OptionVal<Object> optionVal = new OptionVal<Object>(OptionVal$.MODULE$.None());
            OptionVal<Set<ActorRef>> optionVal2 = new OptionVal<Set<ActorRef>>(set2);
            if (!(optionVal != null ? !((Object)optionVal).equals(optionVal2) : optionVal2 != null)) {
                set = ActorCell$.MODULE$.emptyActorRefSet();
            } else {
                throw new MatchError(new OptionVal<Set<ActorRef>>(set2));
            }
        }
        return set;
    }

    private final boolean hasNonLocalAddress$1() {
        return this.watching.exists((Function1)(JFunction1 & Serializable)ref -> FunctionRef.isNonLocal$1(ref)) || this.watchedByOrEmpty$1().exists((Function1)(JFunction1 & Serializable)ref -> FunctionRef.isNonLocal$1(ref));
    }
}

