/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.Cancellable;
import akka.actor.LightArrayRevolverScheduler$;
import akka.actor.Scheduler;
import akka.actor.SchedulerException;
import akka.actor.SchedulerException$;
import akka.dispatch.AbstractNodeQueue;
import akka.event.LoggingAdapter;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import akka.util.Helpers$Requiring$;
import akka.util.Unsafe;
import com.typesafe.config.Config;
import dotty.DottyPredef$;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

public class LightArrayRevolverScheduler
implements Scheduler,
Closeable {
    public final LoggingAdapter akka$actor$LightArrayRevolverScheduler$$log;
    public final ThreadFactory akka$actor$LightArrayRevolverScheduler$$threadFactory;
    private final int WheelSize;
    private final FiniteDuration TickDuration;
    private final FiniteDuration ShutdownTimeout;
    private final double maxFrequency;
    public final long akka$actor$LightArrayRevolverScheduler$$start;
    public final long akka$actor$LightArrayRevolverScheduler$$tickNanos;
    public final int akka$actor$LightArrayRevolverScheduler$$wheelMask;
    public final TaskQueue akka$actor$LightArrayRevolverScheduler$$queue;
    public final AtomicReference<Promise<Seq<TimerTask>>> akka$actor$LightArrayRevolverScheduler$$stopped;
    public volatile Thread akka$actor$LightArrayRevolverScheduler$$timerThread;

    public LightArrayRevolverScheduler(Config config, LoggingAdapter log, ThreadFactory threadFactory) {
        this.akka$actor$LightArrayRevolverScheduler$$log = log;
        this.akka$actor$LightArrayRevolverScheduler$$threadFactory = threadFactory;
        Integer n = Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)config.getInt("akka.scheduler.ticks-per-wheel")));
        this.WheelSize = BoxesRunTime.unboxToInt((Object)Helpers$Requiring$.MODULE$.requiring$extension(n, (JFunction1.mcZI.sp & Serializable)ticks -> (ticks & ticks - 1) == 0, (Function0<Object>)((Function0 & Serializable)LightArrayRevolverScheduler::$init$$$anonfun$2)));
        FiniteDuration finiteDuration = Helpers$.MODULE$.Requiring(Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "akka.scheduler.tick-duration"));
        FiniteDuration finiteDuration2 = Helpers$.MODULE$.Requiring(Helpers$Requiring$.MODULE$.requiring$extension(finiteDuration, (JFunction1 & Serializable)_$1 -> _$1.$greater$eq((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis()) || !Helpers$.MODULE$.isWindows(), (Function0<Object>)((Function0 & Serializable)LightArrayRevolverScheduler::$init$$$anonfun$4)));
        this.TickDuration = Helpers$Requiring$.MODULE$.requiring$extension(finiteDuration2, (JFunction1 & Serializable)_$2 -> _$2.$greater$eq((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis()), (Function0<Object>)((Function0 & Serializable)LightArrayRevolverScheduler::$init$$$anonfun$6));
        this.ShutdownTimeout = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "akka.scheduler.shutdown-timeout");
        this.maxFrequency = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second().$div((Duration)this.TickDuration());
        this.akka$actor$LightArrayRevolverScheduler$$start = this.clock();
        this.akka$actor$LightArrayRevolverScheduler$$tickNanos = this.TickDuration().toNanos();
        this.akka$actor$LightArrayRevolverScheduler$$wheelMask = this.WheelSize() - 1;
        this.akka$actor$LightArrayRevolverScheduler$$queue = new TaskQueue();
        this.akka$actor$LightArrayRevolverScheduler$$stopped = new AtomicReference();
        this.akka$actor$LightArrayRevolverScheduler$$timerThread = threadFactory.newThread(new Runnable(this){
            private int tick;
            private long totalTick;
            private final TaskQueue[] wheel;
            public final LightArrayRevolverScheduler akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer = $outer;
                this.tick = $outer.startTick();
                this.totalTick = Int$.MODULE$.int2long(this.tick());
                this.wheel = (TaskQueue[])Array$.MODULE$.fill($outer.WheelSize(), LightArrayRevolverScheduler::akka$actor$LightArrayRevolverScheduler$$anon$1$$_$$lessinit$greater$$anonfun$7, ClassTag$.MODULE$.apply(TaskQueue.class));
            }

            public int tick() {
                return this.tick;
            }

            public void tick_$eq(int x$1) {
                this.tick = x$1;
            }

            public long totalTick() {
                return this.totalTick;
            }

            public void totalTick_$eq(long x$1) {
                this.totalTick = x$1;
            }

            public TaskQueue[] wheel() {
                return this.wheel;
            }

            private Seq clearAll() {
                return (Seq)((IterableOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.WheelSize()).flatMap((Function1)((JFunction1 & Serializable)this::clearAll$$anonfun$adapted$1))).$plus$plus((IterableOnce)LightArrayRevolverScheduler.akka$actor$LightArrayRevolverScheduler$$anon$1$$_$collect$1(this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$queue, package$.MODULE$.Vector().empty()));
            }

            private void checkQueue(long time) {
                AbstractNodeQueue.Node<T> node;
                $anon$1 var3_2 = this;
                while ((node = var3_2.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$queue.pollNode()) != null) {
                    Boolean bl;
                    AbstractNodeQueue.Node<T> node2 = node;
                    int n = ((TaskHolder)node2.value).ticks();
                    if (0 == n) {
                        bl = BoxesRunTime.boxToBoolean((boolean)((TaskHolder)node2.value).executeTask());
                        continue;
                    }
                    int ticks = n;
                    int futureTick = (int)((time - var3_2.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$start + (long)ticks * var3_2.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$tickNanos + var3_2.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$tickNanos - 1L) / var3_2.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$tickNanos);
                    int offset = futureTick - var3_2.tick();
                    int bucket = futureTick & var3_2.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$wheelMask;
                    ((TaskHolder)node2.value).ticks_$eq(offset);
                    var3_2.wheel()[bucket].addNode(node2);
                    bl = BoxedUnit.UNIT;
                }
            }

            public final void run() {
                try {
                    this.nextTick();
                }
                catch (Throwable t) {
                    Promise promise;
                    this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$log.error(t, "exception on LARS\u2019 timer thread");
                    Promise<Seq<TimerTask>> promise2 = this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$stopped.get();
                    if (promise2 == null) {
                        BoxedUnit boxedUnit;
                        Thread thread = this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$threadFactory.newThread(this);
                        this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$log.info("starting new LARS thread");
                        try {
                            thread.start();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        catch (Throwable e) {
                            this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$log.error(e, "LARS cannot start new thread, ship\u2019s going down!");
                            this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$stopped.set((Promise<Seq<TimerTask>>)Promise$.MODULE$.successful((Object)package$.MODULE$.Nil()));
                            boxedUnit = this.clearAll();
                        }
                        this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$timerThread = thread;
                        promise = BoxedUnit.UNIT;
                    } else {
                        Promise<Seq<TimerTask>> p = promise2;
                        if (!this.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$stopped.compareAndSet(p, (Promise<Seq<TimerTask>>)Promise$.MODULE$.successful((Object)package$.MODULE$.Nil()))) {
                            throw DottyPredef$.MODULE$.assertFail(LightArrayRevolverScheduler::akka$actor$LightArrayRevolverScheduler$$anon$1$$_$run$$anonfun$1);
                        }
                        promise = p.success((Object)this.clearAll());
                    }
                    throw t;
                }
            }

            public final void nextTick() {
                Promise<Seq<TimerTask>> promise;
                $anon$1 var1_1 = this;
                do {
                    long time = var1_1.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.clock();
                    long sleepTime = var1_1.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$start + var1_1.totalTick() * var1_1.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$tickNanos - time;
                    if (sleepTime > 0L) {
                        var1_1.checkQueue(time);
                        var1_1.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.waitNanos(sleepTime);
                        continue;
                    }
                    int bucket = var1_1.tick() & var1_1.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$wheelMask;
                    TaskQueue tasks2 = var1_1.wheel()[bucket];
                    TaskQueue putBack = new TaskQueue();
                    LightArrayRevolverScheduler.akka$actor$LightArrayRevolverScheduler$$anon$1$$_$executeBucket$1(tasks2, putBack, var1_1);
                    var1_1.wheel()[bucket] = putBack;
                    var1_1.tick_$eq(var1_1.tick() + 1);
                    var1_1.totalTick_$eq(var1_1.totalTick() + 1L);
                } while ((promise = var1_1.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$stopped.get()) == null);
                Promise<Seq<TimerTask>> p = promise;
                if (!var1_1.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.akka$actor$LightArrayRevolverScheduler$$stopped.compareAndSet(p, (Promise<Seq<TimerTask>>)Promise$.MODULE$.successful((Object)package$.MODULE$.Nil()))) {
                    throw DottyPredef$.MODULE$.assertFail(LightArrayRevolverScheduler::akka$actor$LightArrayRevolverScheduler$$anon$1$$_$nextTick$$anonfun$1);
                }
                p.success((Object)var1_1.clearAll());
            }

            private final /* synthetic */ IterableOnce clearAll$$anonfun$1(int i) {
                return LightArrayRevolverScheduler.akka$actor$LightArrayRevolverScheduler$$anon$1$$_$collect$1(this.wheel()[i], package$.MODULE$.Vector().empty());
            }

            private final IterableOnce clearAll$$anonfun$adapted$1(Object i) {
                return this.clearAll$$anonfun$1(BoxesRunTime.unboxToInt((Object)i));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{akka$actor$LightArrayRevolverScheduler$$anon$1$$_$$lessinit$greater$$anonfun$7(), clearAll$$anonfun$adapted$1(java.lang.Object ), akka$actor$LightArrayRevolverScheduler$$anon$1$$_$run$$anonfun$1(), akka$actor$LightArrayRevolverScheduler$$anon$1$$_$nextTick$$anonfun$1()}, serializedLambda);
            }
        });
        this.akka$actor$LightArrayRevolverScheduler$$timerThread.start();
    }

    public int WheelSize() {
        return this.WheelSize;
    }

    public FiniteDuration TickDuration() {
        return this.TickDuration;
    }

    public FiniteDuration ShutdownTimeout() {
        return this.ShutdownTimeout;
    }

    public FiniteDuration akka$actor$LightArrayRevolverScheduler$$roundUp(FiniteDuration d) {
        long dn = d.toNanos();
        long r = ((dn - 1L) / this.akka$actor$LightArrayRevolverScheduler$$tickNanos + 1L) * this.akka$actor$LightArrayRevolverScheduler$$tickNanos;
        return r != dn && r > 0L && dn > 0L ? new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(r)).nanos() : d;
    }

    public long clock() {
        return System.nanoTime();
    }

    public int startTick() {
        return 0;
    }

    public FiniteDuration getShutdownTimeout() {
        return this.ShutdownTimeout();
    }

    public void waitNanos(long nanos) {
        long sleepMs = Helpers$.MODULE$.isWindows() ? (nanos + 4999999L) / 10000000L * 10L : (nanos + 999999L) / 1000000L;
        try {
            Thread.sleep(sleepMs);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        this.checkMaxDelay(this.akka$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        return Scheduler.super.scheduleWithFixedDelay(initialDelay, delay, runnable, executor);
    }

    @Override
    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        Cancellable cancellable;
        this.checkMaxDelay(this.akka$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        try {
            cancellable = new Cancellable(initialDelay, delay, runnable, executor, this){
                private final LightArrayRevolverScheduler $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$InitialRepeatMarker);
                    this.compareAndSet(LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$InitialRepeatMarker, $outer.akka$actor$LightArrayRevolverScheduler$$schedule(executor$1, new Runnable(initialDelay$1, delay$1, runnable$1, executor$1, $outer, this){
                        private final FiniteDuration delay$1;
                        private final Runnable runnable$1;
                        private final ExecutionContext executor$1;
                        private final $anon$2 $outer;
                        {
                            this.delay$1 = delay$3;
                            this.runnable$1 = runnable$3;
                            this.executor$1 = executor$3;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            super(LightArrayRevolverScheduler.akka$actor$LightArrayRevolverScheduler$$anon$2$$_$$anon$superArg$1$1(initialDelay$3, $outer$2));
                        }

                        public void run() {
                            try {
                                this.runnable$1.run();
                                long driftNanos = this.$outer.akka$actor$LightArrayRevolverScheduler$_$$anon$$$outer().clock() - this.getAndAdd(this.delay$1.toNanos());
                                if (this.$outer.get() != null) {
                                    this.$outer.akka$actor$LightArrayRevolverScheduler$$anon$2$$swap(this.$outer.akka$actor$LightArrayRevolverScheduler$_$$anon$$$outer().akka$actor$LightArrayRevolverScheduler$$schedule(this.executor$1, this, Duration$.MODULE$.fromNanos(Math.max(this.delay$1.toNanos() - driftNanos, 1L))));
                                }
                            }
                            catch (SchedulerException schedulerException) {}
                        }
                    }, $outer.akka$actor$LightArrayRevolverScheduler$$roundUp(initialDelay$1)));
                }

                public void akka$actor$LightArrayRevolverScheduler$$anon$2$$swap(Cancellable c) {
                    Cancellable cancellable;
                    Cancellable old;
                    $anon$2 var2_2 = this;
                    do {
                        if ((cancellable = (Cancellable)var2_2.get()) != null) continue;
                        if (c == null) break;
                        c.cancel();
                        break;
                    } while (!var2_2.compareAndSet(old = cancellable, c));
                }

                public final boolean cancel() {
                    boolean bl;
                    block3: {
                        Cancellable c;
                        $anon$2 var1_1 = this;
                        do {
                            Cancellable cancellable;
                            if ((cancellable = (Cancellable)var1_1.get()) == null) {
                                bl = false;
                            } else {
                                c = cancellable;
                                if (!c.cancel()) continue;
                                bl = var1_1.compareAndSet(c, null);
                            }
                            break block3;
                        } while (!var1_1.compareAndSet(c, null));
                        bl = true;
                    }
                    return bl;
                }

                public boolean isCancelled() {
                    return this.get() == null;
                }

                public final LightArrayRevolverScheduler akka$actor$LightArrayRevolverScheduler$_$$anon$$$outer() {
                    return this.$outer;
                }
            };
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SchedulerException) {
                String string;
                SchedulerException schedulerException = (SchedulerException)throwable2;
                SchedulerException schedulerException2 = SchedulerException$.MODULE$.unapply(schedulerException);
                String msg = string = schedulerException2._1();
                SchedulerException cause = schedulerException;
                throw new IllegalStateException(msg, cause);
            }
            throw throwable;
        }
        return cancellable;
    }

    @Override
    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        TimerTask timerTask;
        try {
            timerTask = this.akka$actor$LightArrayRevolverScheduler$$schedule(executor, runnable, this.akka$actor$LightArrayRevolverScheduler$$roundUp(delay));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SchedulerException) {
                String string;
                SchedulerException schedulerException = (SchedulerException)throwable2;
                SchedulerException schedulerException2 = SchedulerException$.MODULE$.unapply(schedulerException);
                String msg = string = schedulerException2._1();
                SchedulerException cause = schedulerException;
                throw new IllegalStateException(msg, cause);
            }
            throw throwable;
        }
        return timerTask;
    }

    @Override
    public void close() {
        ((IterableOnceOps)Await$.MODULE$.result(this.stop(), (Duration)this.getShutdownTimeout())).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            block1: {
                TaskHolder holder;
                Runnable runnable;
                TimerTask timerTask;
                block0: {
                    timerTask = x$1;
                    if (!(timerTask instanceof Scheduler.TaskRunOnClose)) break block0;
                    TimerTask task = (TimerTask)((Object)((Scheduler.TaskRunOnClose)((Object)timerTask)));
                    this.runTask$1(task);
                    break block1;
                }
                if (!(timerTask instanceof TaskHolder) || !((runnable = (holder = (TaskHolder)timerTask).task()) instanceof Scheduler.TaskRunOnClose)) break block1;
                Scheduler.TaskRunOnClose task = (Scheduler.TaskRunOnClose)runnable;
                this.runTask$1(task);
            }
        });
    }

    @Override
    public double maxFrequency() {
        return this.maxFrequency;
    }

    public TimerTask akka$actor$LightArrayRevolverScheduler$$schedule(ExecutionContext ec, Runnable r, FiniteDuration delay) {
        TimerTask timerTask;
        if (delay.length() <= 0L) {
            if (this.akka$actor$LightArrayRevolverScheduler$$stopped.get() != null) {
                throw SchedulerException$.MODULE$.apply("cannot enqueue after timer shutdown");
            }
            ec.execute(r);
            timerTask = LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$NotCancellable;
        } else {
            if (this.akka$actor$LightArrayRevolverScheduler$$stopped.get() != null) {
                throw SchedulerException$.MODULE$.apply("cannot enqueue after timer shutdown");
            }
            long delayNanos = delay.toNanos();
            this.checkMaxDelay(delayNanos);
            int ticks = (int)(delayNanos / this.akka$actor$LightArrayRevolverScheduler$$tickNanos);
            TaskHolder task = new TaskHolder(r, ticks, ec);
            this.akka$actor$LightArrayRevolverScheduler$$queue.add(task);
            if (this.akka$actor$LightArrayRevolverScheduler$$stopped.get() != null && task.cancel()) {
                throw SchedulerException$.MODULE$.apply("cannot enqueue after timer shutdown");
            }
            timerTask = task;
        }
        return timerTask;
    }

    private void checkMaxDelay(long delayNanos) {
        if (delayNanos / this.akka$actor$LightArrayRevolverScheduler$$tickNanos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Task scheduled with [" + new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(delayNanos)).nanos().toSeconds() + "] seconds delay, " + ("which is too far in future, maximum delay is [" + (new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(this.akka$actor$LightArrayRevolverScheduler$$tickNanos * Integer.MAX_VALUE)).nanos().toSeconds() - 1L) + "] seconds"));
        }
    }

    private Future<Seq<TimerTask>> stop() {
        Promise p = Promise$.MODULE$.apply();
        return this.akka$actor$LightArrayRevolverScheduler$$stopped.compareAndSet(null, (Promise<Seq<TimerTask>>)p) ? p.future() : Future$.MODULE$.successful((Object)package$.MODULE$.Nil());
    }

    private static final String $init$$$anonfun$2() {
        return "ticks-per-wheel must be a power of 2";
    }

    private static final String $init$$$anonfun$4() {
        return "minimum supported akka.scheduler.tick-duration on Windows is 10ms";
    }

    private static final String $init$$$anonfun$6() {
        return "minimum supported akka.scheduler.tick-duration is 1ms";
    }

    public static final TaskQueue akka$actor$LightArrayRevolverScheduler$$anon$1$$_$$lessinit$greater$$anonfun$7() {
        return new TaskQueue();
    }

    public static final Vector akka$actor$LightArrayRevolverScheduler$$anon$1$$_$collect$1(TaskQueue q, Vector acc) {
        TaskHolder taskHolder;
        Vector vector = acc;
        while ((taskHolder = (TaskHolder)q.poll()) != null) {
            TaskHolder x = taskHolder;
            vector = (Vector)vector.$colon$plus((Object)x);
        }
        return vector;
    }

    public static final String akka$actor$LightArrayRevolverScheduler$$anon$1$$_$run$$anonfun$1() {
        return "Stop signal violated in LARS";
    }

    public static final void akka$actor$LightArrayRevolverScheduler$$anon$1$$_$executeBucket$1(TaskQueue tasks$1, TaskQueue putBack$1, $anon$1 $this$1) {
        AbstractNodeQueue.Node node;
        while ((node = tasks$1.pollNode()) != null) {
            AbstractNodeQueue.Node node2 = node;
            TaskHolder task = (TaskHolder)node2.value;
            if (task.isCancelled()) continue;
            if (task.ticks() >= $this$1.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.WheelSize()) {
                task.ticks_$eq(task.ticks() - $this$1.akka$actor$LightArrayRevolverScheduler$$anon$1$$$outer.WheelSize());
                putBack$1.addNode(node2);
                continue;
            }
            task.executeTask();
        }
    }

    public static final String akka$actor$LightArrayRevolverScheduler$$anon$1$$_$nextTick$$anonfun$1() {
        return "Stop signal violated in LARS";
    }

    public static final long akka$actor$LightArrayRevolverScheduler$$anon$2$$_$$anon$superArg$1$1(FiniteDuration initialDelay$2, LightArrayRevolverScheduler $outer$1) {
        return $outer$1.clock() + initialDelay$2.toNanos();
    }

    private final void runTask$1(Runnable task) {
        try {
            task.run();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (SchedulerException schedulerException) {
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.akka$actor$LightArrayRevolverScheduler$$log.error(e, "exception while executing timer task");
            }
            throw throwable;
        }
    }

    public static class TaskHolder
    implements TimerTask {
        private Runnable task;
        private int ticks;
        private final ExecutionContext executionContext;

        public TaskHolder(Runnable task, int ticks, ExecutionContext executionContext) {
            this.task = task;
            this.ticks = ticks;
            this.executionContext = executionContext;
        }

        public Runnable task() {
            return this.task;
        }

        public void task_$eq(Runnable x$1) {
            this.task = x$1;
        }

        public int ticks() {
            return this.ticks;
        }

        public void ticks_$eq(int x$1) {
            this.ticks = x$1;
        }

        private final Runnable extractTask(Runnable replaceWith) {
            Runnable runnable;
            TaskHolder taskHolder = this;
            while (true) {
                Runnable x;
                Runnable runnable2;
                block7: {
                    Runnable t;
                    block4: {
                        Runnable runnable3;
                        Runnable runnable4;
                        block6: {
                            block5: {
                                Runnable runnable5;
                                Runnable runnable6;
                                block3: {
                                    runnable2 = taskHolder.task();
                                    runnable6 = LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$ExecutedTask;
                                    runnable5 = runnable2;
                                    if (runnable6 != null) break block3;
                                    if (runnable5 == null) break block4;
                                    break block5;
                                }
                                if (runnable6.equals(runnable5)) break block4;
                            }
                            runnable4 = LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$CancelledTask;
                            runnable3 = runnable2;
                            if (runnable4 != null) break block6;
                            if (runnable3 == null) break block4;
                            break block7;
                        }
                        if (!runnable4.equals(runnable3)) break block7;
                    }
                    runnable = t = runnable2;
                    break;
                }
                if (!Unsafe.instance.compareAndSwapObject(taskHolder, LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$taskOffset, x = runnable2, replaceWith)) continue;
                runnable = x;
                break;
            }
            return runnable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean executeTask() {
            Runnable runnable = this.extractTask(LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$ExecutedTask);
            Runnable runnable2 = LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$ExecutedTask;
            Runnable runnable3 = runnable;
            if (runnable2 == null) {
                if (runnable3 == null) return false;
            } else if (runnable2.equals(runnable3)) return false;
            Runnable runnable4 = LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$CancelledTask;
            Runnable runnable5 = runnable;
            if (runnable4 == null) {
                if (runnable5 == null) return false;
            } else if (runnable4.equals(runnable5)) {
                return false;
            }
            Runnable other = runnable;
            try {
                this.executionContext.execute(other);
                return true;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 == null) throw throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable3);
                if (option.isEmpty()) throw throwable;
                Throwable e = throwable2 = (Throwable)option.get();
                this.executionContext.reportFailure(e);
                return false;
            }
        }

        @Override
        public void run() {
            this.extractTask(LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$ExecutedTask).run();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean cancel() {
            Runnable runnable = this.extractTask(LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$CancelledTask);
            Runnable runnable2 = LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$ExecutedTask;
            Runnable runnable3 = runnable;
            if (runnable2 == null) {
                if (runnable3 == null) return false;
            } else if (runnable2.equals(runnable3)) return false;
            Runnable runnable4 = LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$CancelledTask;
            Runnable runnable5 = runnable;
            if (runnable4 != null) {
                if (!runnable4.equals(runnable5)) return true;
                return false;
            }
            if (runnable5 == null) return false;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.task() == LightArrayRevolverScheduler$.MODULE$.akka$actor$LightArrayRevolverScheduler$$$CancelledTask;
        }
    }

    private static class TaskQueue
    extends AbstractNodeQueue<TaskHolder> {
    }

    public static interface TimerTask
    extends Runnable,
    Cancellable {
    }
}

