/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorCell;
import akka.actor.ActorContext;
import akka.actor.ActorInitializationException$;
import akka.actor.ActorRef;
import akka.actor.StashOverflowException;
import akka.actor.StashOverflowException$;
import akka.actor.Terminated;
import akka.actor.Terminated$;
import akka.annotation.InternalStableApi;
import akka.dispatch.DequeBasedMessageQueueSemantics;
import akka.dispatch.Envelope;
import akka.dispatch.MessageQueue;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;

public interface StashSupport {
    default public void $init$() {
    }

    public ActorContext context();

    public ActorRef self();

    public Vector<Envelope> akka$actor$StashSupport$$theStash();

    default public Vector akka$actor$StashSupport$$initial$theStash() {
        return package$.MODULE$.Vector().empty();
    }

    public void akka$actor$StashSupport$$theStash_$eq(Vector<Envelope> var1);

    private ActorCell actorCell() {
        return (ActorCell)this.context();
    }

    public int akka$actor$StashSupport$$capacity();

    default public int akka$actor$StashSupport$$initial$capacity() {
        return this.context().system().mailboxes().stashCapacity(this.context().props().dispatcher(), this.context().props().mailbox());
    }

    public DequeBasedMessageQueueSemantics mailbox();

    default public DequeBasedMessageQueueSemantics initial$mailbox() {
        MessageQueue messageQueue = this.actorCell().mailbox().messageQueue();
        if (!(messageQueue instanceof DequeBasedMessageQueueSemantics)) {
            MessageQueue other = messageQueue;
            ActorRef actorRef = this.self();
            String string = "DequeBasedMailbox required, got: " + other.getClass().getName() + "\n" + StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("An (unbounded) deque-based mailbox can be configured as follows:\n          |  my-custom-mailbox {\n          |    mailbox-type = \"akka.dispatch.UnboundedDequeBasedMailbox\"\n          |  }\n          |"));
            ActorInitializationException$.MODULE$.apply$default$3();
            throw ActorInitializationException$.MODULE$.apply(actorRef, string, null);
        }
        MessageQueue queue = (MessageQueue)((Object)((DequeBasedMessageQueueSemantics)((Object)messageQueue)));
        return (DequeBasedMessageQueueSemantics)((Object)queue);
    }

    default public void stash() {
        Envelope currMsg = this.actorCell().currentMessage();
        if (this.akka$actor$StashSupport$$theStash().nonEmpty() && currMsg == this.akka$actor$StashSupport$$theStash().last()) {
            throw new IllegalStateException("Can't stash the same message " + currMsg + " more than once");
        }
        if (this.akka$actor$StashSupport$$capacity() > 0 && this.akka$actor$StashSupport$$theStash().size() >= this.akka$actor$StashSupport$$capacity()) {
            String string = "Couldn't enqueue message " + currMsg.message().getClass().getName() + " from " + currMsg.sender() + " to stash of " + this.self();
            StashOverflowException$.MODULE$.$lessinit$greater$default$2();
            throw new StashOverflowException(string, null);
        }
        this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)((Vector)this.akka$actor$StashSupport$$theStash().$colon$plus((Object)currMsg)));
    }

    default public void prepend(Seq<Envelope> others) {
        this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)((Vector)others.foldRight(this.akka$actor$StashSupport$$theStash(), (Function2)(JFunction2 & Serializable)(e, s) -> (Vector)s.$plus$colon(e))));
    }

    default public void unstash() {
        if (this.akka$actor$StashSupport$$theStash().nonEmpty()) {
            try {
                this.enqueueFirst((Envelope)this.akka$actor$StashSupport$$theStash().head());
            }
            finally {
                this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)this.akka$actor$StashSupport$$theStash().tail());
            }
        }
    }

    default public void unstashAll() {
        this.unstashAll((Function1<Object, Object>)(JFunction1 & Serializable)_$1 -> true);
    }

    @InternalStableApi
    default public void unstashAll(Function1<Object, Object> filterPredicate) {
        try {
            Iterator i = this.akka$actor$StashSupport$$theStash().reverseIterator().filter((Function1)(JFunction1 & Serializable)envelope -> BoxesRunTime.unboxToBoolean((Object)filterPredicate.apply(envelope.message())));
            while (i.hasNext()) {
                this.enqueueFirst((Envelope)i.next());
            }
        }
        finally {
            this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)package$.MODULE$.Vector().empty());
        }
    }

    /*
     * WARNING - void declaration
     */
    @InternalStableApi
    default public Vector<Envelope> clearStash() {
        void var1_1;
        Vector<Envelope> stashed = this.akka$actor$StashSupport$$theStash();
        this.akka$actor$StashSupport$$theStash_$eq((Vector<Envelope>)package$.MODULE$.Vector().empty());
        return var1_1;
    }

    private void enqueueFirst(Envelope envelope) {
        block0: {
            ActorRef actorRef;
            this.mailbox().enqueueFirst(this.self(), envelope);
            Object object = envelope.message();
            if (!(object instanceof Terminated)) break block0;
            Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
            ActorRef ref = actorRef = terminated._1();
            this.actorCell().terminatedQueuedFor(ref, (Option)None$.MODULE$);
        }
    }
}

