/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorContext;
import akka.actor.ActorInitializationException;
import akka.actor.ActorRef;
import akka.actor.ChildRestartStats;
import akka.actor.InternalActorRef;
import akka.actor.SupervisorStrategy$;
import akka.actor.SupervisorStrategy$Escalate$;
import akka.actor.SupervisorStrategy$Restart$;
import akka.actor.SupervisorStrategy$Resume$;
import akka.actor.SupervisorStrategy$Stop$;
import akka.event.Logging;
import akka.event.Logging$Error$;
import akka.event.Logging$Warning$;
import akka.japi.Function;
import java.lang.reflect.InvocationTargetException;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.util.control.NonFatal$;

public abstract class SupervisorStrategy {
    public static PartialFunction defaultDecider() {
        return SupervisorStrategy$.MODULE$.defaultDecider();
    }

    public static SupervisorStrategy defaultStrategy() {
        return SupervisorStrategy$.MODULE$.defaultStrategy();
    }

    public static SupervisorStrategy$Escalate$ escalate() {
        return SupervisorStrategy$.MODULE$.escalate();
    }

    public static Function1 escalateDefault() {
        return SupervisorStrategy$.MODULE$.escalateDefault();
    }

    public static PartialFunction makeDecider(Function function) {
        return SupervisorStrategy$.MODULE$.makeDecider(function);
    }

    public static PartialFunction<Throwable, Directive> makeDecider(Iterable<Tuple2<Class<? extends Throwable>, Directive>> iterable) {
        return SupervisorStrategy$.MODULE$.makeDecider(iterable);
    }

    public static PartialFunction<Throwable, Directive> makeDecider(java.lang.Iterable<Class<? extends Throwable>> iterable) {
        return SupervisorStrategy$.MODULE$.makeDecider(iterable);
    }

    public static PartialFunction<Throwable, Directive> makeDecider(Seq<Class<? extends Throwable>> seq) {
        return SupervisorStrategy$.MODULE$.makeDecider(seq);
    }

    public static Option<Object> maxNrOfRetriesOption(int n) {
        return SupervisorStrategy$.MODULE$.maxNrOfRetriesOption(n);
    }

    public static SupervisorStrategy$Restart$ restart() {
        return SupervisorStrategy$.MODULE$.restart();
    }

    public static SupervisorStrategy$Resume$ resume() {
        return SupervisorStrategy$.MODULE$.resume();
    }

    public static PartialFunction<Throwable, Directive> seqCauseDirective2Decider(Iterable<Tuple2<Class<? extends Throwable>, Directive>> iterable) {
        return SupervisorStrategy$.MODULE$.seqCauseDirective2Decider((Iterable)iterable);
    }

    public static PartialFunction<Throwable, Directive> seqThrowable2Decider(Seq<Class<? extends Throwable>> seq) {
        return SupervisorStrategy$.MODULE$.seqThrowable2Decider(seq);
    }

    public static Seq<Tuple2<Class<? extends Throwable>, Directive>> sort(Iterable<Tuple2<Class<? extends Throwable>, Directive>> iterable) {
        return SupervisorStrategy$.MODULE$.sort(iterable);
    }

    public static SupervisorStrategy$Stop$ stop() {
        return SupervisorStrategy$.MODULE$.stop();
    }

    public static SupervisorStrategy stoppingStrategy() {
        return SupervisorStrategy$.MODULE$.stoppingStrategy();
    }

    public static Option<Duration> withinTimeRangeOption(Duration duration) {
        return SupervisorStrategy$.MODULE$.withinTimeRangeOption(duration);
    }

    public abstract PartialFunction decider();

    public abstract void handleChildTerminated(ActorContext var1, ActorRef var2, Iterable<ActorRef> var3);

    public abstract void processFailure(ActorContext var1, boolean var2, ActorRef var3, Throwable var4, ChildRestartStats var5, Iterable<ChildRestartStats> var6);

    public boolean handleFailure(ActorContext context, ActorRef child, Throwable cause, ChildRestartStats stats, Iterable<ChildRestartStats> children) {
        boolean bl;
        Directive directive = (Directive)this.decider().applyOrElse((Object)cause, SupervisorStrategy$.MODULE$.escalateDefault());
        Directive directive2 = directive;
        if (SupervisorStrategy$Resume$.MODULE$.equals(directive2)) {
            this.logFailure(context, child, cause, directive);
            this.resumeChild(child, cause);
            bl = true;
        } else if (SupervisorStrategy$Restart$.MODULE$.equals(directive2)) {
            this.logFailure(context, child, cause, directive);
            this.processFailure(context, true, child, cause, stats, children);
            bl = true;
        } else if (SupervisorStrategy$Stop$.MODULE$.equals(directive2)) {
            this.logFailure(context, child, cause, directive);
            this.processFailure(context, false, child, cause, stats, children);
            bl = true;
        } else if (SupervisorStrategy$Escalate$.MODULE$.equals(directive2)) {
            this.logFailure(context, child, cause, directive);
            bl = false;
        } else {
            throw new MatchError((Object)directive2);
        }
        return bl;
    }

    public boolean loggingEnabled() {
        return true;
    }

    public void logFailure(ActorContext context, ActorRef child, Throwable cause, Directive decision) {
        block4: {
            Directive directive;
            String logMessage;
            block5: {
                String string;
                ActorInitializationException e;
                if (!this.loggingEnabled()) break block4;
                Throwable throwable = cause;
                if (throwable instanceof ActorInitializationException && (e = (ActorInitializationException)throwable).getCause() != null) {
                    InvocationTargetException ex;
                    Throwable throwable2 = e.getCause();
                    if (throwable2 instanceof InvocationTargetException && (ex = (InvocationTargetException)throwable2).getCause() != null) {
                        string = ex.getCause().getMessage();
                    } else {
                        Throwable ex2 = throwable2;
                        string = ex2.getMessage();
                    }
                } else {
                    Throwable e2 = throwable;
                    string = e2.getMessage();
                }
                logMessage = string;
                directive = decision;
                if (!SupervisorStrategy$Resume$.MODULE$.equals(directive)) break block5;
                this.publish(context, Logging$Warning$.MODULE$.apply(child.path().toString(), this.getClass(), logMessage));
                break block4;
            }
            if (SupervisorStrategy$Escalate$.MODULE$.equals(directive)) break block4;
            this.publish(context, Logging$Error$.MODULE$.apply(cause, child.path().toString(), this.getClass(), logMessage));
        }
    }

    private void publish(ActorContext context, Logging.LogEvent logEvent) {
        try {
            context.system().eventStream().publish(logEvent);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
            }
            throw throwable;
        }
    }

    public final void resumeChild(ActorRef child, Throwable cause) {
        ((InternalActorRef)child).resume(cause);
    }

    public final void restartChild(ActorRef child, Throwable cause, boolean suspendFirst) {
        InternalActorRef c = (InternalActorRef)child;
        if (suspendFirst) {
            c.suspend();
        }
        c.restart(cause);
    }

    public static interface Directive {
    }
}

