/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.NotInfluenceReceiveTimeout;
import akka.actor.Scheduler;
import akka.actor.TimerScheduler;
import akka.actor.TimerSchedulerImpl$FixedDelayMode$;
import akka.actor.TimerSchedulerImpl$FixedRateMode$;
import akka.actor.TimerSchedulerImpl$InfluenceReceiveTimeoutTimerMsg$;
import akka.actor.TimerSchedulerImpl$NotInfluenceReceiveTimeoutTimerMsg$;
import akka.actor.TimerSchedulerImpl$SingleMode$;
import akka.actor.TimerSchedulerImpl$Timer$;
import akka.annotation.InternalApi;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import dotty.runtime.function.JFunction1;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public class TimerSchedulerImpl
extends TimerScheduler {
    private final ActorContext ctx;
    private final LoggingAdapter log;
    private Map<Object, Timer> timers;
    private int timerGen;

    public TimerSchedulerImpl(ActorContext ctx) {
        this.ctx = ctx;
        this.log = Logging$.MODULE$.apply(ctx.system(), TimerScheduler.class, LogSource$.MODULE$.fromAnyClass());
        this.timers = Predef$.MODULE$.Map().empty();
        this.timerGen = 0;
    }

    private int nextTimerGen() {
        ++this.timerGen;
        return this.timerGen;
    }

    @Override
    public void startTimerAtFixedRate(Object key, Object msg, FiniteDuration interval) {
        this.startTimer(key, msg, interval, TimerSchedulerImpl$FixedRateMode$.MODULE$);
    }

    @Override
    public void startTimerWithFixedDelay(Object key, Object msg, FiniteDuration delay) {
        this.startTimer(key, msg, delay, TimerSchedulerImpl$FixedDelayMode$.MODULE$);
    }

    @Override
    public void startPeriodicTimer(Object key, Object msg, FiniteDuration interval) {
        this.startTimerAtFixedRate(key, msg, interval);
    }

    @Override
    public void startSingleTimer(Object key, Object msg, FiniteDuration timeout) {
        this.startTimer(key, msg, timeout, TimerSchedulerImpl$SingleMode$.MODULE$);
    }

    private void startTimer(Object key, Object msg, FiniteDuration timeout, TimerMode mode) {
        Cancellable cancellable;
        Option option = this.timers.get(key);
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            this.cancelTimer(t);
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        int nextGen = this.nextTimerGen();
        TimerMsg timerMsg = (TimerMsg)((Object)(msg instanceof NotInfluenceReceiveTimeout ? TimerSchedulerImpl$NotInfluenceReceiveTimeoutTimerMsg$.MODULE$.apply(key, nextGen, this) : TimerSchedulerImpl$InfluenceReceiveTimeoutTimerMsg$.MODULE$.apply(key, nextGen, this)));
        TimerMode timerMode = mode;
        if (TimerSchedulerImpl$SingleMode$.MODULE$.equals(timerMode)) {
            Scheduler scheduler = this.ctx.system().scheduler();
            ActorRef actorRef = this.ctx.self();
            cancellable = scheduler.scheduleOnce(timeout, actorRef, (Object)timerMsg, (ExecutionContext)this.ctx.dispatcher(), scheduler.scheduleOnce$default$5(timeout, actorRef, timerMsg));
        } else if (TimerSchedulerImpl$FixedDelayMode$.MODULE$.equals(timerMode)) {
            Scheduler scheduler = this.ctx.system().scheduler();
            ActorRef actorRef = this.ctx.self();
            cancellable = scheduler.scheduleWithFixedDelay(timeout, timeout, actorRef, (Object)timerMsg, (ExecutionContext)this.ctx.dispatcher(), scheduler.scheduleWithFixedDelay$default$6(timeout, timeout, actorRef, timerMsg));
        } else if (TimerSchedulerImpl$FixedRateMode$.MODULE$.equals(timerMode)) {
            Scheduler scheduler = this.ctx.system().scheduler();
            ActorRef actorRef = this.ctx.self();
            cancellable = scheduler.scheduleAtFixedRate(timeout, timeout, actorRef, (Object)timerMsg, (ExecutionContext)this.ctx.dispatcher(), scheduler.scheduleAtFixedRate$default$6(timeout, timeout, actorRef, timerMsg));
        } else {
            throw new MatchError((Object)timerMode);
        }
        Cancellable task = cancellable;
        Timer nextTimer = TimerSchedulerImpl$Timer$.MODULE$.apply(key, msg, mode.repeat(), nextGen, task);
        this.timers = (Map)this.timers.updated(key, (Object)nextTimer);
    }

    @Override
    public boolean isTimerActive(Object key) {
        return this.timers.contains(key);
    }

    @Override
    public void cancel(Object key) {
        Option option = this.timers.get(key);
        if (!None$.MODULE$.equals(option)) {
            if (option instanceof Some) {
                Timer t = (Timer)((Some)option).value();
                this.cancelTimer(t);
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private void cancelTimer(Timer timer) {
        this.log.debug("Cancel timer [{}] with generation [{}]", timer.key(), BoxesRunTime.boxToInteger((int)timer.generation()));
        timer.task().cancel();
        this.timers = (Map)this.timers.$minus(timer.key());
    }

    @Override
    public void cancelAll() {
        this.log.debug("Cancel all timers");
        this.timers.valuesIterator().foreach((Function1)(JFunction1 & Serializable)timer -> timer.task().cancel());
        this.timers = Predef$.MODULE$.Map().empty();
    }

    public Object interceptTimerMsg(TimerMsg timerMsg) {
        Object object;
        Option option = this.timers.get(timerMsg.key());
        if (None$.MODULE$.equals(option)) {
            this.log.debug("Received timer [{}] that has been removed, discarding", timerMsg.key());
            object = OptionVal$.MODULE$.None();
        } else if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            if (timerMsg.owner() != this) {
                this.log.debug("Received timer [{}] from old restarted instance, discarding", timerMsg.key());
                object = OptionVal$.MODULE$.None();
            } else if (timerMsg.generation() == t.generation()) {
                if (!t.repeat()) {
                    this.timers = (Map)this.timers.$minus(t.key());
                }
                object = OptionVal$Some$.MODULE$.apply(t.msg());
            } else {
                this.log.debug("Received timer [{}] from from old generation [{}], expected generation [{}], discarding", timerMsg.key(), BoxesRunTime.boxToInteger((int)timerMsg.generation()), BoxesRunTime.boxToInteger((int)t.generation()));
                object = OptionVal$.MODULE$.None();
            }
        } else {
            throw new MatchError((Object)option);
        }
        return object;
    }

    public static final class InfluenceReceiveTimeoutTimerMsg
    implements TimerMsg,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Object key;
        private final int generation;
        private final TimerSchedulerImpl owner;

        public static InfluenceReceiveTimeoutTimerMsg apply(Object object, int n, TimerSchedulerImpl timerSchedulerImpl) {
            return TimerSchedulerImpl$InfluenceReceiveTimeoutTimerMsg$.MODULE$.apply(object, n, timerSchedulerImpl);
        }

        public static Function1 curried() {
            return TimerSchedulerImpl$InfluenceReceiveTimeoutTimerMsg$.MODULE$.curried();
        }

        public static InfluenceReceiveTimeoutTimerMsg fromProduct(Product product) {
            return TimerSchedulerImpl$InfluenceReceiveTimeoutTimerMsg$.MODULE$.fromProduct(product);
        }

        public static Function1 tupled() {
            return TimerSchedulerImpl$InfluenceReceiveTimeoutTimerMsg$.MODULE$.tupled();
        }

        public static InfluenceReceiveTimeoutTimerMsg unapply(InfluenceReceiveTimeoutTimerMsg influenceReceiveTimeoutTimerMsg) {
            return TimerSchedulerImpl$InfluenceReceiveTimeoutTimerMsg$.MODULE$.unapply(influenceReceiveTimeoutTimerMsg);
        }

        public InfluenceReceiveTimeoutTimerMsg(Object key, int generation, TimerSchedulerImpl owner) {
            this.key = key;
            this.generation = generation;
            this.owner = owner;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.key()));
            n = Statics.mix((int)n, (int)this.generation());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.owner()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InfluenceReceiveTimeoutTimerMsg)) return false;
            InfluenceReceiveTimeoutTimerMsg influenceReceiveTimeoutTimerMsg = (InfluenceReceiveTimeoutTimerMsg)object;
            if (this.generation() != influenceReceiveTimeoutTimerMsg.generation()) return false;
            if (!BoxesRunTime.equals((Object)this.key(), (Object)influenceReceiveTimeoutTimerMsg.key())) return false;
            TimerSchedulerImpl timerSchedulerImpl = this.owner();
            TimerSchedulerImpl timerSchedulerImpl2 = influenceReceiveTimeoutTimerMsg.owner();
            if (timerSchedulerImpl != null) {
                if (!timerSchedulerImpl.equals(timerSchedulerImpl2)) return false;
                return true;
            }
            if (timerSchedulerImpl2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InfluenceReceiveTimeoutTimerMsg;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "InfluenceReceiveTimeoutTimerMsg";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "key";
                    break;
                }
                case 1: {
                    string = "generation";
                    break;
                }
                case 2: {
                    string = "owner";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public Object key() {
            return this.key;
        }

        @Override
        public int generation() {
            return this.generation;
        }

        @Override
        public TimerSchedulerImpl owner() {
            return this.owner;
        }

        public InfluenceReceiveTimeoutTimerMsg copy(Object key, int generation, TimerSchedulerImpl owner) {
            return new InfluenceReceiveTimeoutTimerMsg(key, generation, owner);
        }

        public Object copy$default$1() {
            return this.key();
        }

        public int copy$default$2() {
            return this.generation();
        }

        public TimerSchedulerImpl copy$default$3() {
            return this.owner();
        }

        public Object _1() {
            return this.key();
        }

        public int _2() {
            return this.generation();
        }

        public TimerSchedulerImpl _3() {
            return this.owner();
        }
    }

    public static final class NotInfluenceReceiveTimeoutTimerMsg
    implements TimerMsg,
    NoSerializationVerificationNeeded,
    NotInfluenceReceiveTimeout,
    Product,
    Serializable {
        private final Object key;
        private final int generation;
        private final TimerSchedulerImpl owner;

        public static NotInfluenceReceiveTimeoutTimerMsg apply(Object object, int n, TimerSchedulerImpl timerSchedulerImpl) {
            return TimerSchedulerImpl$NotInfluenceReceiveTimeoutTimerMsg$.MODULE$.apply(object, n, timerSchedulerImpl);
        }

        public static Function1 curried() {
            return TimerSchedulerImpl$NotInfluenceReceiveTimeoutTimerMsg$.MODULE$.curried();
        }

        public static NotInfluenceReceiveTimeoutTimerMsg fromProduct(Product product) {
            return TimerSchedulerImpl$NotInfluenceReceiveTimeoutTimerMsg$.MODULE$.fromProduct(product);
        }

        public static Function1 tupled() {
            return TimerSchedulerImpl$NotInfluenceReceiveTimeoutTimerMsg$.MODULE$.tupled();
        }

        public static NotInfluenceReceiveTimeoutTimerMsg unapply(NotInfluenceReceiveTimeoutTimerMsg notInfluenceReceiveTimeoutTimerMsg) {
            return TimerSchedulerImpl$NotInfluenceReceiveTimeoutTimerMsg$.MODULE$.unapply(notInfluenceReceiveTimeoutTimerMsg);
        }

        public NotInfluenceReceiveTimeoutTimerMsg(Object key, int generation, TimerSchedulerImpl owner) {
            this.key = key;
            this.generation = generation;
            this.owner = owner;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.key()));
            n = Statics.mix((int)n, (int)this.generation());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.owner()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotInfluenceReceiveTimeoutTimerMsg)) return false;
            NotInfluenceReceiveTimeoutTimerMsg notInfluenceReceiveTimeoutTimerMsg = (NotInfluenceReceiveTimeoutTimerMsg)object;
            if (this.generation() != notInfluenceReceiveTimeoutTimerMsg.generation()) return false;
            if (!BoxesRunTime.equals((Object)this.key(), (Object)notInfluenceReceiveTimeoutTimerMsg.key())) return false;
            TimerSchedulerImpl timerSchedulerImpl = this.owner();
            TimerSchedulerImpl timerSchedulerImpl2 = notInfluenceReceiveTimeoutTimerMsg.owner();
            if (timerSchedulerImpl != null) {
                if (!timerSchedulerImpl.equals(timerSchedulerImpl2)) return false;
                return true;
            }
            if (timerSchedulerImpl2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NotInfluenceReceiveTimeoutTimerMsg;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "NotInfluenceReceiveTimeoutTimerMsg";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "key";
                    break;
                }
                case 1: {
                    string = "generation";
                    break;
                }
                case 2: {
                    string = "owner";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public Object key() {
            return this.key;
        }

        @Override
        public int generation() {
            return this.generation;
        }

        @Override
        public TimerSchedulerImpl owner() {
            return this.owner;
        }

        public NotInfluenceReceiveTimeoutTimerMsg copy(Object key, int generation, TimerSchedulerImpl owner) {
            return new NotInfluenceReceiveTimeoutTimerMsg(key, generation, owner);
        }

        public Object copy$default$1() {
            return this.key();
        }

        public int copy$default$2() {
            return this.generation();
        }

        public TimerSchedulerImpl copy$default$3() {
            return this.owner();
        }

        public Object _1() {
            return this.key();
        }

        public int _2() {
            return this.generation();
        }

        public TimerSchedulerImpl _3() {
            return this.owner();
        }
    }

    public static final class Timer
    implements Product,
    Serializable {
        private final Object key;
        private final Object msg;
        private final boolean repeat;
        private final int generation;
        private final Cancellable task;

        public static Timer apply(Object object, Object object2, boolean bl, int n, Cancellable cancellable) {
            return TimerSchedulerImpl$Timer$.MODULE$.apply(object, object2, bl, n, cancellable);
        }

        public static Function1 curried() {
            return TimerSchedulerImpl$Timer$.MODULE$.curried();
        }

        public static Timer fromProduct(Product product) {
            return TimerSchedulerImpl$Timer$.MODULE$.fromProduct(product);
        }

        public static Function1 tupled() {
            return TimerSchedulerImpl$Timer$.MODULE$.tupled();
        }

        public static Timer unapply(Timer timer) {
            return TimerSchedulerImpl$Timer$.MODULE$.unapply(timer);
        }

        public Timer(Object key, Object msg, boolean repeat, int generation, Cancellable task) {
            this.key = key;
            this.msg = msg;
            this.repeat = repeat;
            this.generation = generation;
            this.task = task;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.key()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.msg()));
            n = Statics.mix((int)n, (int)(this.repeat() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.generation());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.task()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Timer)) return false;
            Timer timer = (Timer)object;
            if (this.repeat() != timer.repeat()) return false;
            if (this.generation() != timer.generation()) return false;
            if (!BoxesRunTime.equals((Object)this.key(), (Object)timer.key())) return false;
            if (!BoxesRunTime.equals((Object)this.msg(), (Object)timer.msg())) return false;
            Cancellable cancellable = this.task();
            Cancellable cancellable2 = timer.task();
            if (cancellable != null) {
                if (!cancellable.equals(cancellable2)) return false;
                return true;
            }
            if (cancellable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Timer;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Timer";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._3());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this._4());
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "key";
                    break;
                }
                case 1: {
                    string = "msg";
                    break;
                }
                case 2: {
                    string = "repeat";
                    break;
                }
                case 3: {
                    string = "generation";
                    break;
                }
                case 4: {
                    string = "task";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Object key() {
            return this.key;
        }

        public Object msg() {
            return this.msg;
        }

        public boolean repeat() {
            return this.repeat;
        }

        public int generation() {
            return this.generation;
        }

        public Cancellable task() {
            return this.task;
        }

        public Timer copy(Object key, Object msg, boolean repeat, int generation, Cancellable task) {
            return new Timer(key, msg, repeat, generation, task);
        }

        public Object copy$default$1() {
            return this.key();
        }

        public Object copy$default$2() {
            return this.msg();
        }

        public boolean copy$default$3() {
            return this.repeat();
        }

        public int copy$default$4() {
            return this.generation();
        }

        public Cancellable copy$default$5() {
            return this.task();
        }

        public Object _1() {
            return this.key();
        }

        public Object _2() {
            return this.msg();
        }

        public boolean _3() {
            return this.repeat();
        }

        public int _4() {
            return this.generation();
        }

        public Cancellable _5() {
            return this.task();
        }
    }

    private static interface TimerMode {
        public boolean repeat();
    }

    public static interface TimerMsg {
        public Object key();

        public int generation();

        public TimerSchedulerImpl owner();
    }
}

