/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.ConfigurationException;
import akka.actor.ActorSystem;
import akka.annotation.DoNotInherit;
import akka.annotation.InternalApi;
import akka.dispatch.BalancingDispatcherConfigurator;
import akka.dispatch.CachingConfig;
import akka.dispatch.DispatcherConfigurator;
import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.Dispatchers$;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.PinnedDispatcherConfigurator;
import akka.event.LoggingAdapter;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

@DoNotInherit
public class Dispatchers {
    private final ActorSystem.Settings settings;
    private final DispatcherPrerequisites prerequisites;
    private final LoggingAdapter logger;
    private final CachingConfig cachingConfig;
    private final Config defaultDispatcherConfig;
    private final ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators;
    private final MessageDispatcher internalDispatcher;

    public static String DefaultBlockingDispatcherId() {
        return Dispatchers$.MODULE$.DefaultBlockingDispatcherId();
    }

    public static String DefaultDispatcherId() {
        return Dispatchers$.MODULE$.DefaultDispatcherId();
    }

    @InternalApi
    public static String InternalDispatcherId() {
        return Dispatchers$.MODULE$.InternalDispatcherId();
    }

    @InternalApi
    public Dispatchers(ActorSystem.Settings settings, DispatcherPrerequisites prerequisites, LoggingAdapter logger) {
        this.settings = settings;
        this.prerequisites = prerequisites;
        this.logger = logger;
        this.cachingConfig = new CachingConfig(settings.config());
        this.defaultDispatcherConfig = this.idConfig("akka.actor.default-dispatcher").withFallback((ConfigMergeable)settings.config().getConfig("akka.actor.default-dispatcher"));
        this.dispatcherConfigurators = new ConcurrentHashMap();
        this.internalDispatcher = this.lookup("akka.actor.internal-dispatcher");
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public DispatcherPrerequisites prerequisites() {
        return this.prerequisites;
    }

    public CachingConfig cachingConfig() {
        return this.cachingConfig;
    }

    public Config defaultDispatcherConfig() {
        return this.defaultDispatcherConfig;
    }

    public MessageDispatcher defaultGlobalDispatcher() {
        return this.lookup("akka.actor.default-dispatcher");
    }

    public MessageDispatcher internalDispatcher() {
        return this.internalDispatcher;
    }

    public MessageDispatcher lookup(String id) {
        return this.lookupConfigurator(id, 0).dispatcher();
    }

    public boolean hasDispatcher(String id) {
        return this.dispatcherConfigurators.containsKey(id) || this.cachingConfig().hasPath(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MessageDispatcherConfigurator lookupConfigurator(String id, int depth) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        if (depth > Dispatchers$.MODULE$.akka$dispatch$Dispatchers$$$MaxDispatcherAliasDepth) {
            throw new ConfigurationException("Didn't find a concrete dispatcher config after following " + Dispatchers$.MODULE$.akka$dispatch$Dispatchers$$$MaxDispatcherAliasDepth + ", " + ("is there a loop in your config? last looked for id was " + id));
        }
        MessageDispatcherConfigurator messageDispatcherConfigurator2 = this.dispatcherConfigurators.get(id);
        if (messageDispatcherConfigurator2 == null) {
            MessageDispatcherConfigurator existing;
            MessageDispatcherConfigurator messageDispatcherConfigurator3;
            if (!this.cachingConfig().hasPath(id)) throw new ConfigurationException("Dispatcher [" + id + "] not configured");
            ConfigValue valueAtPath = this.cachingConfig().getValue(id);
            ConfigValueType configValueType = valueAtPath.valueType();
            if (ConfigValueType.STRING.equals(configValueType)) {
                String actualId = (String)valueAtPath.unwrapped();
                this.logger.debug("Dispatcher id [{}] is an alias, actual dispatcher will be [{}]", id, actualId);
                messageDispatcherConfigurator3 = this.lookupConfigurator(actualId, depth + 1);
            } else if (ConfigValueType.OBJECT.equals(configValueType)) {
                messageDispatcherConfigurator3 = this.configuratorFrom(this.config(id));
            } else {
                ConfigValueType unexpected = configValueType;
                throw new ConfigurationException("Expected either a dispatcher config or an alias at [" + id + "] but found [" + unexpected + "]");
            }
            MessageDispatcherConfigurator newConfigurator = messageDispatcherConfigurator3;
            MessageDispatcherConfigurator messageDispatcherConfigurator4 = this.dispatcherConfigurators.putIfAbsent(id, newConfigurator);
            messageDispatcherConfigurator = messageDispatcherConfigurator4 == null ? newConfigurator : (existing = messageDispatcherConfigurator4);
            return messageDispatcherConfigurator;
        } else {
            MessageDispatcherConfigurator existing;
            messageDispatcherConfigurator = existing = messageDispatcherConfigurator2;
        }
        return messageDispatcherConfigurator;
    }

    public boolean registerConfigurator(String id, MessageDispatcherConfigurator configurator) {
        return this.dispatcherConfigurators.putIfAbsent(id, configurator) == null;
    }

    public Config config(String id) {
        return this.config(id, this.settings().config().getConfig(id));
    }

    public Config config(String id, Config appConfig) {
        Object[] objectArray = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)Dispatchers.simpleName$1(id));
        return this.idConfig(id).withFallback((ConfigMergeable)appConfig).withFallback((ConfigMergeable)ConfigFactory.parseMap((java.util.Map)package$JavaConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava())).withFallback((ConfigMergeable)this.defaultDispatcherConfig());
    }

    private Config idConfig(String id) {
        Object[] objectArray = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)id);
        return ConfigFactory.parseMap((java.util.Map)package$JavaConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava());
    }

    public MessageDispatcher from(Config cfg) {
        return this.configuratorFrom(cfg).dispatcher();
    }

    private MessageDispatcherConfigurator configuratorFrom(Config cfg) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        if (!cfg.hasPath("id")) {
            throw new ConfigurationException("Missing dispatcher 'id' property in config: " + cfg.root().render());
        }
        String string = cfg.getString("type");
        if ("Dispatcher".equals(string)) {
            messageDispatcherConfigurator = new DispatcherConfigurator(cfg, this.prerequisites());
        } else {
            if ("BalancingDispatcher".equals(string)) {
                throw new IllegalArgumentException("BalancingDispatcher is deprecated, use a BalancingPool instead. During a migration period you can still use BalancingDispatcher by specifying the full class name: " + BalancingDispatcherConfigurator.class.getName());
            }
            if ("PinnedDispatcher".equals(string)) {
                messageDispatcherConfigurator = new PinnedDispatcherConfigurator(cfg, this.prerequisites());
            } else {
                String fqn = string;
                Object[] objectArray = new Tuple2[2];
                Object object = Predef$.MODULE$.ArrowAssoc(Config.class);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)cfg);
                Object object2 = Predef$.MODULE$.ArrowAssoc(DispatcherPrerequisites.class);
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, (Object)this.prerequisites());
                List args = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                messageDispatcherConfigurator = (MessageDispatcherConfigurator)this.prerequisites().dynamicAccess().createInstanceFor(fqn, (Seq<Tuple2<Class<?>, Object>>)args, ClassTag$.MODULE$.apply(MessageDispatcherConfigurator.class)).recover((PartialFunction)new Serializable(cfg, fqn){
                    private final Config cfg$1;
                    private final String fqn$1;
                    {
                        this.cfg$1 = cfg$2;
                        this.fqn$1 = fqn$2;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable;
                        Throwable exception = throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable;
                        Throwable exception = throwable = x;
                        throw new ConfigurationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cannot instantiate MessageDispatcherConfigurator type [%s], defined in [%s], make sure it has constructor with [com.typesafe.config.Config] and [akka.dispatch.DispatcherPrerequisites] parameters"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.fqn$1, this.cfg$1.getString("id")})), exception);
                    }
                }).get();
            }
        }
        return messageDispatcherConfigurator;
    }

    private static final String simpleName$1(String id$1) {
        return id$1.substring(id$1.lastIndexOf(46) + 1);
    }
}

