/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.ConfigurationException;
import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorRef$;
import akka.actor.ActorSystem;
import akka.actor.DeadLetter;
import akka.actor.DeadLetter$;
import akka.actor.DynamicAccess;
import akka.actor.Props;
import akka.actor.ScalaActorRef;
import akka.dispatch.BoundedMailbox;
import akka.dispatch.Envelope;
import akka.dispatch.Mailbox;
import akka.dispatch.MailboxType;
import akka.dispatch.Mailboxes$;
import akka.dispatch.MessageQueue;
import akka.dispatch.ProducesMessageQueue;
import akka.dispatch.ProducesPushTimeoutSemanticsMailbox;
import akka.dispatch.RequiresMessageQueue;
import akka.dispatch.UnboundedMailbox;
import akka.dispatch.UnboundedMailbox$;
import akka.dispatch.sysmsg.SystemMessage;
import akka.dispatch.sysmsg.SystemMessageList$;
import akka.event.EventStream;
import akka.event.Logging$Warning$;
import akka.util.Reflect$;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class Mailboxes {
    private final ActorSystem.Settings settings;
    private final EventStream eventStream;
    private final DynamicAccess dynamicAccess;
    public final ActorRef akka$dispatch$Mailboxes$$deadLetters;
    private final Mailbox deadLetterMailbox;
    private final ConcurrentHashMap<String, MailboxType> mailboxTypeConfigurators;
    private final scala.collection.immutable.Map<Class<?>, String> mailboxBindings;
    private final Class<RequiresMessageQueue<?>> rmqClass;
    private boolean mailboxSizeWarningIssued;
    private boolean mailboxNonZeroPushTimeoutWarningIssued;
    private final Config defaultMailboxConfig;
    private final AtomicReference<scala.collection.immutable.Map<String, Object>> stashCapacityCache;
    private final int defaultStashCapacity;

    public static String BoundedCapacityPrefix() {
        return Mailboxes$.MODULE$.BoundedCapacityPrefix();
    }

    public static String DefaultMailboxId() {
        return Mailboxes$.MODULE$.DefaultMailboxId();
    }

    public static String NoMailboxRequirement() {
        return Mailboxes$.MODULE$.NoMailboxRequirement();
    }

    public Mailboxes(ActorSystem.Settings settings, EventStream eventStream, DynamicAccess dynamicAccess, ActorRef deadLetters) {
        this.settings = settings;
        this.eventStream = eventStream;
        this.dynamicAccess = dynamicAccess;
        this.akka$dispatch$Mailboxes$$deadLetters = deadLetters;
        this.deadLetterMailbox = new Mailbox(this){
            private final Mailboxes $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.akka$dispatch$Mailboxes$$_$$anon$superArg$1$1());
                this.becomeClosed();
            }

            public void systemEnqueue(ActorRef receiver, SystemMessage handle) {
                ScalaActorRef scalaActorRef = ActorRef$.MODULE$.actorRef2Scala(this.$outer.akka$dispatch$Mailboxes$$deadLetters);
                DeadLetter deadLetter = DeadLetter$.MODULE$.apply((Object)handle, receiver, receiver);
                scalaActorRef.$bang(deadLetter, scalaActorRef.$bang$default$2(deadLetter));
            }

            public SystemMessage systemDrain(SystemMessage newContents) {
                return SystemMessageList$.MODULE$.ENil();
            }

            public boolean hasSystemMessages() {
                return false;
            }
        };
        this.mailboxTypeConfigurators = new ConcurrentHashMap();
        this.mailboxBindings = (scala.collection.immutable.Map)package$JavaConverters$.MODULE$.MapHasAsScala(settings.config().getConfig("akka.actor.mailbox.requirements").root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2)(JFunction2 & Serializable)(x$1, x$2) -> {
            scala.collection.immutable.Map m;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._2();
                    m = (scala.collection.immutable.Map)tuple22._1();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            return (scala.collection.immutable.Map)dynamicAccess.getClassFor(k, ClassTag$.MODULE$.Any()).map((Function1)(JFunction1 & Serializable)x -> (scala.collection.immutable.Map)m.updated(x, (Object)v.toString())).recover((PartialFunction)new Serializable(k, v){
                private final String k$1;
                private final Object v$1;
                {
                    this.k$1 = k$2;
                    this.v$1 = v$3;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    throw new ConfigurationException("Type [" + this.k$1 + "] specified as akka.actor.mailbox.requirement " + ("[" + this.v$1 + "] in config can't be loaded due to [" + e.getMessage() + "]"), e);
                }
            }).get();
        });
        this.rmqClass = RequiresMessageQueue.class;
        this.mailboxSizeWarningIssued = false;
        this.mailboxNonZeroPushTimeoutWarningIssued = false;
        this.defaultMailboxConfig = settings.config().getConfig("akka.actor.default-mailbox");
        this.stashCapacityCache = new AtomicReference<scala.collection.immutable.Map>(Predef$.MODULE$.Map().empty());
        this.defaultStashCapacity = this.stashCapacityFromConfig("akka.actor.default-dispatcher", "akka.actor.default-mailbox");
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public EventStream eventStream() {
        return this.eventStream;
    }

    public Mailbox deadLetterMailbox() {
        return this.deadLetterMailbox;
    }

    public MailboxType lookup(String id) {
        return this.lookupConfigurator(id);
    }

    public MailboxType lookupByQueueType(Class<?> queueType) {
        return this.lookup(this.lookupId(queueType));
    }

    public Class<?> getRequiredType(Class<? extends Actor> actorClass) {
        Type type;
        Type type2 = Reflect$.MODULE$.findMarker(actorClass, this.rmqClass);
        if (type2 instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type2;
            Object object = Predef$.MODULE$.refArrayOps((Object[])t.getActualTypeArguments());
            type = (Type)ArrayOps$.MODULE$.head$extension(object);
            if (!(type instanceof Class)) {
                Type x = type;
                throw new IllegalArgumentException("no wildcard type allowed in RequireMessageQueue argument (was [" + x + "])");
            }
        } else {
            throw new MatchError((Object)type2);
        }
        Class c = (Class)type;
        return c;
    }

    public Class<? extends Object> getMailboxRequirement(Config config) {
        Class clazz;
        String string = config.getString("mailbox-requirement");
        if ("".equals(string)) {
            clazz = MessageQueue.class;
        } else {
            String x = string;
            clazz = (Class)this.dynamicAccess.getClassFor(x, ClassTag$.MODULE$.apply(Object.class)).get();
        }
        return clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class<?> getProducedMessageQueueType(MailboxType mailboxType) {
        Class c;
        Class<ProducesMessageQueue> pmqClass = ProducesMessageQueue.class;
        if (!pmqClass.isAssignableFrom(mailboxType.getClass())) {
            return MessageQueue.class;
        }
        Type type = Reflect$.MODULE$.findMarker(mailboxType.getClass(), pmqClass);
        if (!(type instanceof ParameterizedType)) throw new MatchError((Object)type);
        ParameterizedType t = (ParameterizedType)type;
        Object object = Predef$.MODULE$.refArrayOps((Object[])t.getActualTypeArguments());
        Type type2 = (Type)ArrayOps$.MODULE$.head$extension(object);
        if (!(type2 instanceof Class)) {
            Type x = type2;
            throw new IllegalArgumentException("no wildcard type allowed in ProducesMessageQueue argument (was [" + x + "])");
        }
        Class clazz = c = (Class)type2;
        return clazz;
    }

    /*
     * Unable to fully structure code
     */
    public MailboxType getMailboxType(Props props, Config dispatcherConfig) {
        block12: {
            block11: {
                var3_3 = new LazyRef();
                id = dispatcherConfig.getString("id");
                deploy = props.deploy();
                actorClass = props.actorClass();
                v0 = mailboxRequirement = this.getMailboxRequirement(dispatcherConfig);
                var9_8 = MessageQueue.class;
                v1 = (v0 == null ? var9_8 != null : v0.equals(var9_8) == false) ? true : (hasMailboxRequirement = false);
                if (!dispatcherConfig.hasPath("mailbox-type")) ** GOTO lbl-1000
                v2 = dispatcherConfig.getString("mailbox-type");
                var11_10 = "";
                if (v2 == null ? var11_10 != null : v2.equals(var11_10) == false) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = hasMailboxType = false;
                }
                if (!hasMailboxType && !this.mailboxSizeWarningIssued && dispatcherConfig.hasPath("mailbox-size")) {
                    this.eventStream().publish(Logging$Warning$.MODULE$.apply("mailboxes", this.getClass(), "ignoring setting 'mailbox-size' for dispatcher [" + id + "], you need to specify 'mailbox-type=bounded'"));
                    this.mailboxSizeWarningIssued = true;
                }
                v4 = deploy.mailbox();
                var12_12 = "";
                if (!(v4 == null ? var12_12 != null : v4.equals(var12_12) == false)) break block11;
                v5 = this.verifyRequirements$1(id, actorClass, mailboxRequirement, hasMailboxRequirement, var3_3, this.lookup(deploy.mailbox()));
                break block12;
            }
            v6 = deploy.dispatcher();
            var13_13 = "";
            if (!(v6 == null ? var13_13 != null : v6.equals(var13_13) == false)) ** GOTO lbl-1000
            v7 = deploy.dispatcher();
            var14_14 = "..";
            if ((v7 == null ? var14_14 != null : v7.equals(var14_14) == false) && hasMailboxType) {
                v5 = this.verifyRequirements$1(id, actorClass, mailboxRequirement, hasMailboxRequirement, var3_3, this.lookup(dispatcherConfig.getString("id")));
            } else if (this.hasRequiredType(actorClass)) {
                try {
                    v5 = this.verifyRequirements$1(id, actorClass, mailboxRequirement, hasMailboxRequirement, var3_3, this.lookupByQueueType(this.getRequiredType(actorClass)));
                }
                catch (Throwable var15_15) {
                    var16_16 = var15_15;
                    if (var16_16 != null && !(var17_17 = NonFatal$.MODULE$.unapply(var16_16)).isEmpty()) {
                        var18_18 = (Throwable)var17_17.get();
                        if (hasMailboxRequirement) {
                            v5 = this.verifyRequirements$1(id, actorClass, mailboxRequirement, hasMailboxRequirement, var3_3, this.lookupByQueueType(mailboxRequirement));
                        }
                    }
                    throw var15_15;
                }
            } else {
                v5 = hasMailboxRequirement != false ? this.verifyRequirements$1(id, actorClass, mailboxRequirement, hasMailboxRequirement, var3_3, this.lookupByQueueType(mailboxRequirement)) : this.verifyRequirements$1(id, actorClass, mailboxRequirement, hasMailboxRequirement, var3_3, this.lookup("akka.actor.default-mailbox"));
            }
        }
        return v5;
    }

    public boolean hasRequiredType(Class<? extends Actor> actorClass) {
        return this.rmqClass.isAssignableFrom(actorClass);
    }

    private String lookupId(Class<?> queueType) {
        Option option = this.mailboxBindings.get(queueType);
        if (None$.MODULE$.equals(option)) {
            throw new ConfigurationException("Mailbox Mapping for [" + queueType + "] not configured");
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        String s = (String)((Some)option).value();
        return s;
    }

    private MailboxType lookupConfigurator(String id) {
        MailboxType mailboxType;
        MailboxType mailboxType2 = this.mailboxTypeConfigurators.get(id);
        if (mailboxType2 == null) {
            MailboxType existing;
            MailboxType mailboxType3;
            String string = id;
            if ("unbounded".equals(string)) {
                mailboxType3 = UnboundedMailbox$.MODULE$.apply();
            } else if ("bounded".equals(string)) {
                mailboxType3 = new BoundedMailbox(this.settings(), this.config(id));
            } else if (id.startsWith("bounded-capacity:")) {
                int capacity = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(id), ':')[1]));
                mailboxType3 = new BoundedMailbox(capacity, Duration$.MODULE$.Zero());
            } else {
                MailboxType m;
                MailboxType mailboxType4;
                if (!this.settings().config().hasPath(id)) {
                    throw new ConfigurationException("Mailbox Type [" + id + "] not configured");
                }
                Config conf = this.config(id);
                String string2 = conf.getString("mailbox-type");
                if ("".equals(string2)) {
                    throw new ConfigurationException("The setting mailbox-type, defined in [" + id + "] is empty");
                }
                String fqcn = string2;
                Object[] objectArray = new Tuple2[2];
                Object object = Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)this.settings());
                Object object2 = Predef$.MODULE$.ArrowAssoc(Config.class);
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, (Object)conf);
                List args = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                MailboxType mailboxType5 = (MailboxType)this.dynamicAccess.createInstanceFor(fqcn, (Seq<Tuple2<Class<?>, Object>>)args, ClassTag$.MODULE$.apply(MailboxType.class)).recover((PartialFunction)new Serializable(id, fqcn){
                    private final String id$1;
                    private final String fqcn$1;
                    {
                        this.id$1 = id$3;
                        this.fqcn$1 = fqcn$2;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable;
                        Throwable exception = throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable;
                        Throwable exception = throwable = x;
                        throw new IllegalArgumentException("Cannot instantiate MailboxType [" + this.fqcn$1 + "], defined in [" + this.id$1 + "], make sure it has a public" + " constructor with [akka.actor.ActorSystem.Settings, com.typesafe.config.Config] parameters", exception);
                    }
                }).get();
                if (!this.mailboxNonZeroPushTimeoutWarningIssued && (mailboxType4 = mailboxType5) instanceof ProducesPushTimeoutSemanticsMailbox && ((ProducesPushTimeoutSemanticsMailbox)((Object)(m = (MailboxType)((Object)((ProducesPushTimeoutSemanticsMailbox)((Object)mailboxType4)))))).pushTimeOut().toNanos() > 0L) {
                    this.warn("Configured potentially-blocking mailbox [" + id + "] configured with non-zero pushTimeOut (" + ((ProducesPushTimeoutSemanticsMailbox)((Object)m)).pushTimeOut() + "), " + "which can lead to blocking behavior when sending messages to this mailbox. " + ("Avoid this by setting `" + id + ".mailbox-push-timeout-time` to `0`."));
                    this.mailboxNonZeroPushTimeoutWarningIssued = true;
                }
                mailboxType3 = mailboxType5;
            }
            UnboundedMailbox newConfigurator = mailboxType3;
            MailboxType mailboxType6 = this.mailboxTypeConfigurators.putIfAbsent(id, newConfigurator);
            mailboxType = mailboxType6 == null ? newConfigurator : (existing = mailboxType6);
        } else {
            MailboxType existing;
            mailboxType = existing = mailboxType2;
        }
        return mailboxType;
    }

    private final void warn(String msg) {
        this.eventStream().publish(Logging$Warning$.MODULE$.apply("mailboxes", this.getClass(), msg));
    }

    private Config config(String id) {
        Object[] objectArray = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)id);
        return ConfigFactory.parseMap((java.util.Map)package$JavaConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).withFallback((ConfigMergeable)this.settings().config().getConfig(id)).withFallback((ConfigMergeable)this.defaultMailboxConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int stashCapacity(String dispatcher, String mailbox) {
        String key;
        scala.collection.immutable.Map<String, Object> cache;
        Option option;
        int n;
        String string = dispatcher;
        String string2 = "akka.actor.default-dispatcher";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = mailbox;
            String string4 = "akka.actor.default-mailbox";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                n = this.defaultStashCapacity;
                return n;
            }
        }
        if ((option = (cache = this.stashCapacityCache.get()).get((Object)(key = dispatcher + "-" + mailbox))) instanceof Some) {
            int value;
            n = value = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return n;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        int value = this.stashCapacityFromConfig(dispatcher, mailbox);
        this.updateCache$1(cache, key, value);
        n = value;
        return n;
    }

    private int stashCapacityFromConfig(String dispatcher, String mailbox) {
        Config disp = this.settings().config().getConfig(dispatcher);
        Config fallback = disp.withFallback((ConfigMergeable)this.settings().config().getConfig("akka.actor.default-mailbox"));
        String string = mailbox;
        String string2 = "akka.actor.default-mailbox";
        Config config = !(string != null ? !string.equals(string2) : string2 != null) ? fallback : this.settings().config().getConfig(mailbox).withFallback((ConfigMergeable)fallback);
        return config.getInt("stash-capacity");
    }

    public final MessageQueue akka$dispatch$Mailboxes$$_$$anon$superArg$1$1() {
        return new MessageQueue(this){
            private final Mailboxes $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void enqueue(ActorRef receiver, Envelope envelope) {
                block0: {
                    Object object = envelope.message();
                    if (object instanceof DeadLetter) break block0;
                    Object msg = object;
                    this.$outer.akka$dispatch$Mailboxes$$deadLetters.tell(DeadLetter$.MODULE$.apply(msg, envelope.sender(), receiver), envelope.sender());
                }
            }

            public Envelope dequeue() {
                return null;
            }

            public boolean hasMessages() {
                return false;
            }

            public int numberOfMessages() {
                return 0;
            }

            public void cleanUp(ActorRef owner, MessageQueue deadLetters) {
            }
        };
    }

    private final Class actorRequirement$lzyINIT1$1(Class actorClass$1, LazyRef actorRequirement$lzy1$1) {
        Class clazz;
        LazyRef lazyRef = actorRequirement$lzy1$1;
        synchronized (lazyRef) {
            clazz = (Class)(actorRequirement$lzy1$1.initialized() ? actorRequirement$lzy1$1.value() : actorRequirement$lzy1$1.initialize(this.getRequiredType(actorClass$1)));
        }
        return clazz;
    }

    private final Class actorRequirement$1(Class actorClass$2, LazyRef actorRequirement$lzy1$2) {
        return (Class)(actorRequirement$lzy1$2.initialized() ? actorRequirement$lzy1$2.value() : this.actorRequirement$lzyINIT1$1(actorClass$2, actorRequirement$lzy1$2));
    }

    private final Class mqType$lzyINIT1$1(MailboxType mailboxType$1, LazyRef mqType$lzy1$1) {
        Class clazz;
        LazyRef lazyRef = mqType$lzy1$1;
        synchronized (lazyRef) {
            clazz = (Class)(mqType$lzy1$1.initialized() ? mqType$lzy1$1.value() : mqType$lzy1$1.initialize(this.getProducedMessageQueueType(mailboxType$1)));
        }
        return clazz;
    }

    private final Class mqType$1(MailboxType mailboxType$2, LazyRef mqType$lzy1$2) {
        return (Class)(mqType$lzy1$2.initialized() ? mqType$lzy1$2.value() : this.mqType$lzyINIT1$1(mailboxType$2, mqType$lzy1$2));
    }

    private final MailboxType verifyRequirements$1(String id$1, Class actorClass$3, Class mailboxRequirement$1, boolean hasMailboxRequirement$1, LazyRef actorRequirement$lzy1$3, MailboxType mailboxType) {
        LazyRef lazyRef = new LazyRef();
        if (hasMailboxRequirement$1 && !mailboxRequirement$1.isAssignableFrom(this.mqType$1(mailboxType, lazyRef))) {
            throw new IllegalArgumentException("produced message queue type [" + this.mqType$1(mailboxType, lazyRef) + "] does not fulfill requirement for dispatcher [" + id$1 + "]. " + ("Must be a subclass of [" + mailboxRequirement$1 + "]."));
        }
        if (this.hasRequiredType(actorClass$3) && !this.actorRequirement$1(actorClass$3, actorRequirement$lzy1$3).isAssignableFrom(this.mqType$1(mailboxType, lazyRef))) {
            throw new IllegalArgumentException("produced message queue type [" + this.mqType$1(mailboxType, lazyRef) + "] does not fulfill requirement for actor class [" + actorClass$3 + "]. " + ("Must be a subclass of [" + this.actorRequirement$1(actorClass$3, actorRequirement$lzy1$3) + "]."));
        }
        return mailboxType;
    }

    private final boolean updateCache$1(scala.collection.immutable.Map cache, String key, int value) {
        scala.collection.immutable.Map<String, Object> map = cache;
        while (!this.stashCapacityCache.compareAndSet(map, (scala.collection.immutable.Map<String, Object>)map.updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)value)))) {
            map = this.stashCapacityCache.get();
        }
        return true;
    }
}

