/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.actor.ActorCell;
import akka.actor.Cell;
import akka.actor.Scheduler;
import akka.annotation.InternalStableApi;
import akka.dispatch.AbstractMessageDispatcher;
import akka.dispatch.BatchingExecutor;
import akka.dispatch.Envelope;
import akka.dispatch.Mailbox;
import akka.dispatch.MailboxType;
import akka.dispatch.Mailboxes;
import akka.dispatch.MessageDispatcher$;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.TaskInvocation;
import akka.dispatch.TaskInvocation$;
import akka.dispatch.sysmsg.SystemMessage;
import akka.event.EventStream;
import akka.event.Logging;
import akka.event.Logging$Error$;
import akka.util.Index;
import akka.util.Unsafe;
import dotty.runtime.LazyVals$;
import dotty.runtime.function.JFunction0;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class MessageDispatcher
extends AbstractMessageDispatcher
implements BatchingExecutor,
ExecutionContextExecutor {
    private final ThreadLocal akka$dispatch$BatchingExecutor$$_tasksLocal;
    private final ThreadLocal akka$dispatch$BatchingExecutor$$_blockContext;
    private final MessageDispatcherConfigurator configurator;
    private final Mailboxes mailboxes;
    private final EventStream eventStream;
    private volatile long _inhabitantsDoNotCallMeDirectly;
    private volatile int _shutdownScheduleDoNotCallMeDirectly;
    private final Function0<BoxedUnit> taskCleanup;
    private final Scheduler.TaskRunOnClose shutdownAction;
    private final boolean isThroughputDeadlineTimeDefined;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(MessageDispatcher$.class, "bitmap$0");

    public static int RESCHEDULED() {
        return MessageDispatcher$.MODULE$.RESCHEDULED();
    }

    public static int SCHEDULED() {
        return MessageDispatcher$.MODULE$.SCHEDULED();
    }

    public static int UNSCHEDULED() {
        return MessageDispatcher$.MODULE$.UNSCHEDULED();
    }

    public static Index actors() {
        return MessageDispatcher$.MODULE$.actors();
    }

    public static boolean debug() {
        return MessageDispatcher$.MODULE$.debug();
    }

    public static void printActors() {
        MessageDispatcher$.MODULE$.printActors();
    }

    public MessageDispatcher(MessageDispatcherConfigurator configurator) {
        this.configurator = configurator;
        this.akka$dispatch$BatchingExecutor$$_tasksLocal = BatchingExecutor.super.akka$dispatch$BatchingExecutor$$initial$_tasksLocal();
        this.akka$dispatch$BatchingExecutor$$_blockContext = BatchingExecutor.super.akka$dispatch$BatchingExecutor$$initial$_blockContext();
        ExecutionContext.$init$((ExecutionContext)this);
        this.mailboxes = configurator.prerequisites().mailboxes();
        this.eventStream = configurator.prerequisites().eventStream();
        this.taskCleanup = (JFunction0.mcV.sp & Serializable)() -> {
            if (this.addInhabitants(-1L) == 0L) {
                this.ifSensibleToDoSoThenScheduleShutdown();
            }
        };
        this.shutdownAction = new Scheduler.TaskRunOnClose(this){
            private final MessageDispatcher $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final void run() {
                block8: {
                    int n;
                    $anon$1 var1_1 = this;
                    while (true) {
                        n = var1_1.$outer.akka$dispatch$MessageDispatcher$$shutdownSchedule();
                        if (MessageDispatcher$.MODULE$.SCHEDULED() == n) {
                            try {
                                if (var1_1.$outer.inhabitants() == 0L) {
                                    var1_1.$outer.shutdown();
                                }
                                break block8;
                            }
                            finally {
                                while (!var1_1.$outer.akka$dispatch$MessageDispatcher$$updateShutdownSchedule(var1_1.$outer.akka$dispatch$MessageDispatcher$$shutdownSchedule(), MessageDispatcher$.MODULE$.UNSCHEDULED())) {
                                }
                            }
                        }
                        if (MessageDispatcher$.MODULE$.RESCHEDULED() != n) break;
                        if (!var1_1.$outer.akka$dispatch$MessageDispatcher$$updateShutdownSchedule(MessageDispatcher$.MODULE$.RESCHEDULED(), MessageDispatcher$.MODULE$.SCHEDULED())) continue;
                        var1_1.$outer.akka$dispatch$MessageDispatcher$$scheduleShutdownAction();
                        break block8;
                    }
                    if (MessageDispatcher$.MODULE$.UNSCHEDULED() != n) {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
            }
        };
        this.isThroughputDeadlineTimeDefined = this.throughputDeadlineTime().toMillis() > 0L;
    }

    public ThreadLocal akka$dispatch$BatchingExecutor$$_tasksLocal() {
        return this.akka$dispatch$BatchingExecutor$$_tasksLocal;
    }

    public ThreadLocal akka$dispatch$BatchingExecutor$$_blockContext() {
        return this.akka$dispatch$BatchingExecutor$$_blockContext;
    }

    public MessageDispatcherConfigurator configurator() {
        return this.configurator;
    }

    public Mailboxes mailboxes() {
        return this.mailboxes;
    }

    public EventStream eventStream() {
        return this.eventStream;
    }

    private int _dotty_pls_dont_remove_my_unused_private() {
        return this._shutdownScheduleDoNotCallMeDirectly;
    }

    private final long addInhabitants(long add) {
        long old = Unsafe.instance.getAndAddLong(this, AbstractMessageDispatcher.inhabitantsOffset, add);
        long ret = old + add;
        if (ret < 0L) {
            IllegalStateException e = new IllegalStateException("ACTOR SYSTEM CORRUPTED!!! A dispatcher can't have less than 0 inhabitants!");
            this.reportFailure(e);
            throw e;
        }
        return ret;
    }

    public final long inhabitants() {
        return Unsafe.instance.getLongVolatile(this, AbstractMessageDispatcher.inhabitantsOffset);
    }

    public final int akka$dispatch$MessageDispatcher$$shutdownSchedule() {
        return Unsafe.instance.getIntVolatile(this, AbstractMessageDispatcher.shutdownScheduleOffset);
    }

    public final boolean akka$dispatch$MessageDispatcher$$updateShutdownSchedule(int expect, int update) {
        return Unsafe.instance.compareAndSwapInt(this, AbstractMessageDispatcher.shutdownScheduleOffset, expect, update);
    }

    public abstract Mailbox createMailbox(Cell var1, MailboxType var2);

    public abstract String id();

    public final void attach(ActorCell actor) {
        this.register(actor);
        this.registerForExecution(actor.mailbox(), false, true);
    }

    public final void detach(ActorCell actor) {
        try {
            this.unregister(actor);
        }
        finally {
            this.ifSensibleToDoSoThenScheduleShutdown();
        }
    }

    @Override
    public final boolean resubmitOnBlock() {
        return true;
    }

    @Override
    public final void unbatchedExecute(Runnable r) {
        TaskInvocation invocation = TaskInvocation$.MODULE$.apply(this.eventStream(), r, this.taskCleanup);
        this.addInhabitants(1L);
        try {
            this.executeTask(invocation);
        }
        catch (Throwable t) {
            this.addInhabitants(-1L);
            throw t;
        }
    }

    public void reportFailure(Throwable t) {
        Throwable throwable = t;
        if (throwable instanceof Logging.LogEventException) {
            Logging.LogEventException e = (Logging.LogEventException)throwable;
            this.eventStream().publish(e.event());
        } else {
            this.eventStream().publish(Logging$Error$.MODULE$.apply(t, this.getClass().getName(), this.getClass(), t.getMessage()));
        }
    }

    private final void ifSensibleToDoSoThenScheduleShutdown() {
        MessageDispatcher messageDispatcher = this;
        while (messageDispatcher.inhabitants() <= 0L) {
            int n = messageDispatcher.akka$dispatch$MessageDispatcher$$shutdownSchedule();
            if (MessageDispatcher$.MODULE$.UNSCHEDULED() == n) {
                if (!messageDispatcher.akka$dispatch$MessageDispatcher$$updateShutdownSchedule(MessageDispatcher$.MODULE$.UNSCHEDULED(), MessageDispatcher$.MODULE$.SCHEDULED())) continue;
                messageDispatcher.akka$dispatch$MessageDispatcher$$scheduleShutdownAction();
                break;
            }
            if (MessageDispatcher$.MODULE$.SCHEDULED() == n) {
                if (messageDispatcher.akka$dispatch$MessageDispatcher$$updateShutdownSchedule(MessageDispatcher$.MODULE$.SCHEDULED(), MessageDispatcher$.MODULE$.RESCHEDULED())) break;
                continue;
            }
            if (MessageDispatcher$.MODULE$.RESCHEDULED() == n) break;
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
    }

    public void akka$dispatch$MessageDispatcher$$scheduleShutdownAction() {
        try {
            this.configurator().prerequisites().scheduler().scheduleOnce(this.shutdownTimeout(), (Runnable)this.shutdownAction, new ExecutionContext(this){
                private final MessageDispatcher $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    ExecutionContext.$init$((ExecutionContext)this);
                }

                public void execute(Runnable runnable) {
                    runnable.run();
                }

                public void reportFailure(Throwable t) {
                    this.$outer.reportFailure(t);
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            this.shutdown();
            this.akka$dispatch$MessageDispatcher$$updateShutdownSchedule(MessageDispatcher$.MODULE$.SCHEDULED(), MessageDispatcher$.MODULE$.UNSCHEDULED());
        }
    }

    public void register(ActorCell actor) {
        this.addInhabitants(1L);
    }

    public void unregister(ActorCell actor) {
        this.addInhabitants(-1L);
        Mailbox mailBox = actor.swapMailbox(this.mailboxes().deadLetterMailbox());
        mailBox.becomeClosed();
        mailBox.cleanUp();
    }

    public abstract FiniteDuration shutdownTimeout();

    public void suspend(ActorCell actor) {
        Mailbox mbox = actor.mailbox();
        if (mbox.actor() == actor && mbox.dispatcher() == this) {
            mbox.suspend();
        }
    }

    public void resume(ActorCell actor) {
        Mailbox mbox = actor.mailbox();
        if (mbox.actor() == actor && mbox.dispatcher() == this && mbox.resume()) {
            this.registerForExecution(mbox, false, false);
        }
    }

    public abstract void systemDispatch(ActorCell var1, SystemMessage var2);

    public abstract void dispatch(ActorCell var1, Envelope var2);

    public abstract boolean registerForExecution(Mailbox var1, boolean var2, boolean var3);

    public abstract int throughput();

    public abstract Duration throughputDeadlineTime();

    public final boolean isThroughputDeadlineTimeDefined() {
        return this.isThroughputDeadlineTimeDefined;
    }

    public abstract void executeTask(TaskInvocation var1);

    @InternalStableApi
    public abstract void shutdown();
}

