/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.dispatch.CachingConfig;
import akka.dispatch.DefaultExecutorServiceConfigurator;
import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.ExecutorServiceConfigurator;
import akka.dispatch.ForkJoinExecutorConfigurator;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.ThreadPoolExecutorConfigurator;
import akka.dispatch.affinity.AffinityPoolConfigurator;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public abstract class MessageDispatcherConfigurator {
    private final DispatcherPrerequisites prerequisites;
    private final Config config;

    public MessageDispatcherConfigurator(Config _config, DispatcherPrerequisites prerequisites) {
        this.prerequisites = prerequisites;
        this.config = new CachingConfig(_config);
    }

    public DispatcherPrerequisites prerequisites() {
        return this.prerequisites;
    }

    public Config config() {
        return this.config;
    }

    public abstract MessageDispatcher dispatcher();

    public ExecutorServiceConfigurator configureExecutor() {
        ExecutorServiceConfigurator executorServiceConfigurator;
        String string = this.config().getString("executor");
        if ("default-executor".equals(string)) {
            executorServiceConfigurator = new DefaultExecutorServiceConfigurator(this.config().getConfig("default-executor"), this.prerequisites(), this.configurator$1(this.config().getString("default-executor.fallback")));
        } else {
            String other = string;
            executorServiceConfigurator = this.configurator$1(other);
        }
        return executorServiceConfigurator;
    }

    private final ExecutorServiceConfigurator configurator$1(String executor) {
        ExecutorServiceConfigurator executorServiceConfigurator;
        String string = executor;
        if (string == null || "".equals(string) || "fork-join-executor".equals(string)) {
            executorServiceConfigurator = new ForkJoinExecutorConfigurator(this.config().getConfig("fork-join-executor"), this.prerequisites());
        } else if ("thread-pool-executor".equals(string)) {
            executorServiceConfigurator = new ThreadPoolExecutorConfigurator(this.config().getConfig("thread-pool-executor"), this.prerequisites());
        } else if ("affinity-pool-executor".equals(string)) {
            executorServiceConfigurator = new AffinityPoolConfigurator(this.config().getConfig("affinity-pool-executor"), this.prerequisites());
        } else {
            String fqcn = string;
            Object[] objectArray = new Tuple2[2];
            Object object = Predef$.MODULE$.ArrowAssoc(Config.class);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)this.config());
            Object object2 = Predef$.MODULE$.ArrowAssoc(DispatcherPrerequisites.class);
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, (Object)this.prerequisites());
            List args = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            executorServiceConfigurator = (ExecutorServiceConfigurator)this.prerequisites().dynamicAccess().createInstanceFor(fqcn, (Seq<Tuple2<Class<?>, Object>>)args, ClassTag$.MODULE$.apply(ExecutorServiceConfigurator.class)).recover((PartialFunction)new Serializable(fqcn, this){
                private final String fqcn$1;
                private final MessageDispatcherConfigurator $outer;
                {
                    this.fqcn$1 = fqcn$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable exception = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable exception = throwable = x;
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cannot instantiate ExecutorServiceConfigurator (\"executor = [%s]\"), defined in [%s],\n                make sure it has an accessible constructor with a [%s,%s] signature"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.fqcn$1, this.$outer.config().getString("id"), Config.class, DispatcherPrerequisites.class})), exception);
                }
            }).get();
        }
        return executorServiceConfigurator;
    }
}

