/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.dispatch.ExecutorServiceFactory;
import akka.dispatch.ExecutorServiceFactoryProvider;
import akka.dispatch.LoadMetrics;
import akka.dispatch.MonitorableThreadFactory;
import akka.dispatch.ThreadPoolConfig$;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Product;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ThreadPoolConfig
implements ExecutorServiceFactoryProvider,
Product,
Serializable {
    private final boolean allowCorePoolTimeout;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final Duration threadTimeout;
    private final Function0 queueFactory;
    private final RejectedExecutionHandler rejectionPolicy;

    public static ThreadPoolConfig apply(boolean bl, int n, int n2, Duration duration, Function0 function0, RejectedExecutionHandler rejectedExecutionHandler) {
        return ThreadPoolConfig$.MODULE$.apply(bl, n, n2, duration, function0, rejectedExecutionHandler);
    }

    public static Function0 arrayBlockingQueue(int n, boolean bl) {
        return ThreadPoolConfig$.MODULE$.arrayBlockingQueue(n, bl);
    }

    public static boolean defaultAllowCoreThreadTimeout() {
        return ThreadPoolConfig$.MODULE$.defaultAllowCoreThreadTimeout();
    }

    public static int defaultCorePoolSize() {
        return ThreadPoolConfig$.MODULE$.defaultCorePoolSize();
    }

    public static int defaultMaxPoolSize() {
        return ThreadPoolConfig$.MODULE$.defaultMaxPoolSize();
    }

    public static RejectedExecutionHandler defaultRejectionPolicy() {
        return ThreadPoolConfig$.MODULE$.defaultRejectionPolicy();
    }

    public static Duration defaultTimeout() {
        return ThreadPoolConfig$.MODULE$.defaultTimeout();
    }

    public static ThreadPoolConfig fromProduct(Product product) {
        return ThreadPoolConfig$.MODULE$.fromProduct(product);
    }

    public static Function0 linkedBlockingQueue() {
        return ThreadPoolConfig$.MODULE$.linkedBlockingQueue();
    }

    public static Function0 linkedBlockingQueue(int n) {
        return ThreadPoolConfig$.MODULE$.linkedBlockingQueue(n);
    }

    public static Function0<BlockingQueue<Runnable>> reusableQueue(BlockingQueue<Runnable> blockingQueue) {
        return ThreadPoolConfig$.MODULE$.reusableQueue(blockingQueue);
    }

    public static Function0 reusableQueue(Function0 function0) {
        return ThreadPoolConfig$.MODULE$.reusableQueue(function0);
    }

    public static int scaledPoolSize(int n, double d, int n2) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(n, d, n2);
    }

    public static Function0 synchronousQueue(boolean bl) {
        return ThreadPoolConfig$.MODULE$.synchronousQueue(bl);
    }

    public static ThreadPoolConfig unapply(ThreadPoolConfig threadPoolConfig) {
        return ThreadPoolConfig$.MODULE$.unapply(threadPoolConfig);
    }

    public static boolean $lessinit$greater$default$1() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$1();
    }

    public static int $lessinit$greater$default$2() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$3() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$3();
    }

    public static Duration $lessinit$greater$default$4() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function0 $lessinit$greater$default$5() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$5();
    }

    public static RejectedExecutionHandler $lessinit$greater$default$6() {
        return ThreadPoolConfig$.MODULE$.$lessinit$greater$default$6();
    }

    public ThreadPoolConfig(boolean allowCorePoolTimeout, int corePoolSize, int maxPoolSize, Duration threadTimeout, Function0 queueFactory, RejectedExecutionHandler rejectionPolicy) {
        this.allowCorePoolTimeout = allowCorePoolTimeout;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.threadTimeout = threadTimeout;
        this.queueFactory = queueFactory;
        this.rejectionPolicy = rejectionPolicy;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)(this.allowCorePoolTimeout() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)this.corePoolSize());
        n = Statics.mix((int)n, (int)this.maxPoolSize());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.threadTimeout()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.queueFactory()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rejectionPolicy()));
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ThreadPoolConfig)) return false;
        ThreadPoolConfig threadPoolConfig = (ThreadPoolConfig)object;
        if (this.allowCorePoolTimeout() != threadPoolConfig.allowCorePoolTimeout()) return false;
        if (this.corePoolSize() != threadPoolConfig.corePoolSize()) return false;
        if (this.maxPoolSize() != threadPoolConfig.maxPoolSize()) return false;
        Duration duration = this.threadTimeout();
        Duration duration2 = threadPoolConfig.threadTimeout();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!duration.equals(duration2)) return false;
        Function0 function0 = this.queueFactory();
        Function0 function02 = threadPoolConfig.queueFactory();
        if (function0 == null) {
            if (function02 != null) {
                return false;
            }
        } else if (!function0.equals(function02)) return false;
        RejectedExecutionHandler rejectedExecutionHandler = this.rejectionPolicy();
        RejectedExecutionHandler rejectedExecutionHandler2 = threadPoolConfig.rejectionPolicy();
        if (rejectedExecutionHandler == null) {
            if (rejectedExecutionHandler2 == null) return true;
            return false;
        } else {
            if (!rejectedExecutionHandler.equals(rejectedExecutionHandler2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ThreadPoolConfig;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "ThreadPoolConfig";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = BoxesRunTime.boxToBoolean((boolean)this._1());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this._2());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this._3());
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            case 5: {
                object = this._6();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "allowCorePoolTimeout";
                break;
            }
            case 1: {
                string = "corePoolSize";
                break;
            }
            case 2: {
                string = "maxPoolSize";
                break;
            }
            case 3: {
                string = "threadTimeout";
                break;
            }
            case 4: {
                string = "queueFactory";
                break;
            }
            case 5: {
                string = "rejectionPolicy";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public boolean allowCorePoolTimeout() {
        return this.allowCorePoolTimeout;
    }

    public int corePoolSize() {
        return this.corePoolSize;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public Duration threadTimeout() {
        return this.threadTimeout;
    }

    public Function0 queueFactory() {
        return this.queueFactory;
    }

    public RejectedExecutionHandler rejectionPolicy() {
        return this.rejectionPolicy;
    }

    @Override
    public ExecutorServiceFactory createExecutorServiceFactory(String id, ThreadFactory threadFactory) {
        ThreadFactory threadFactory2;
        ThreadFactory threadFactory3 = threadFactory;
        if (threadFactory3 instanceof MonitorableThreadFactory) {
            MonitorableThreadFactory m = (MonitorableThreadFactory)threadFactory3;
            threadFactory2 = m.withName(m.name() + "-" + id);
        } else {
            ThreadFactory other;
            threadFactory2 = other = threadFactory3;
        }
        ThreadFactory tf = threadFactory2;
        return new ThreadPoolExecutorServiceFactory(this, tf);
    }

    public ThreadPoolConfig copy(boolean allowCorePoolTimeout, int corePoolSize, int maxPoolSize, Duration threadTimeout, Function0 queueFactory, RejectedExecutionHandler rejectionPolicy) {
        return new ThreadPoolConfig(allowCorePoolTimeout, corePoolSize, maxPoolSize, threadTimeout, queueFactory, rejectionPolicy);
    }

    public boolean copy$default$1() {
        return this.allowCorePoolTimeout();
    }

    public int copy$default$2() {
        return this.corePoolSize();
    }

    public int copy$default$3() {
        return this.maxPoolSize();
    }

    public Duration copy$default$4() {
        return this.threadTimeout();
    }

    public Function0 copy$default$5() {
        return this.queueFactory();
    }

    public RejectedExecutionHandler copy$default$6() {
        return this.rejectionPolicy();
    }

    public boolean _1() {
        return this.allowCorePoolTimeout();
    }

    public int _2() {
        return this.corePoolSize();
    }

    public int _3() {
        return this.maxPoolSize();
    }

    public Duration _4() {
        return this.threadTimeout();
    }

    public Function0 _5() {
        return this.queueFactory();
    }

    public RejectedExecutionHandler _6() {
        return this.rejectionPolicy();
    }

    public class ThreadPoolExecutorServiceFactory
    implements ExecutorServiceFactory {
        private final ThreadFactory threadFactory;
        private final ThreadPoolConfig $outer;

        public ThreadPoolExecutorServiceFactory(ThreadPoolConfig $outer, ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ExecutorService createExecutorService() {
            void var1_1;
            LoadMetrics service = new LoadMetrics(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer.akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$1$1(), $outer.akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$2$1(), $outer.akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$3$1(), $outer.akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$4$1(), $outer.akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$5$1(), $outer.akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$6$1(), $outer.akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$7$1());
                }

                public boolean atFullThrottle() {
                    return this.getActiveCount() >= this.getPoolSize();
                }
            };
            ((ThreadPoolExecutor)((Object)service)).allowCoreThreadTimeOut(this.$outer.allowCorePoolTimeout());
            return var1_1;
        }

        public final ThreadPoolConfig akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$$outer() {
            return this.$outer;
        }

        public final int akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$1$1() {
            return this.$outer.corePoolSize();
        }

        public final int akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$2$1() {
            return this.$outer.maxPoolSize();
        }

        public final long akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$3$1() {
            return this.$outer.threadTimeout().length();
        }

        public final TimeUnit akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$4$1() {
            return this.$outer.threadTimeout().unit();
        }

        public final BlockingQueue akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$5$1() {
            return (BlockingQueue)this.$outer.queueFactory().apply();
        }

        public final ThreadFactory akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$6$1() {
            return this.threadFactory();
        }

        public final RejectedExecutionHandler akka$dispatch$ThreadPoolConfig$ThreadPoolExecutorServiceFactory$$_$_$$anon$superArg$7$1() {
            return this.$outer.rejectionPolicy();
        }
    }
}

